/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.antenna;

public class FqBandRanges {
    private static final FqBandRanges[] allRange = new FqBandRanges[]{new FqBandRanges(0, 32766, 0, 32766)};
    private final int minLowEdge;
    private final int maxLowEdge;
    private final int minHighEdge;
    private final int maxHighEdge;

    private FqBandRanges(int minLowEdge, int maxLowEdge, int minHighEdge, int maxHighEdge) {
        this.minLowEdge = minLowEdge;
        this.maxLowEdge = maxLowEdge;
        this.minHighEdge = minHighEdge;
        this.maxHighEdge = maxHighEdge;
    }

    public static FqBandRanges lookup(int lowEdge, int highEdge) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isInRange(lowEdge, highEdge)) continue;
            return allRange[i];
        }
        return null;
    }

    public static FqBandRanges lookupLowEdge(int value) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isLowEdgeInRange(value)) continue;
            return allRange[i];
        }
        return null;
    }

    public static FqBandRanges lookupHighEdge(int value) {
        for (int i = 0; i < allRange.length; ++i) {
            if (!allRange[i].isHighEdgeInRange(value)) continue;
            return allRange[i];
        }
        return null;
    }

    public boolean isLowEdgeInRange(int value) {
        return value >= this.minLowEdge && value <= this.maxLowEdge;
    }

    public boolean isHighEdgeInRange(int value) {
        return value >= this.minHighEdge && value <= this.maxHighEdge;
    }

    public boolean isInRange(int lowEdge, int highEdge) {
        return this.isHighEdgeInRange(highEdge) && this.isLowEdgeInRange(lowEdge);
    }
}

