/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.antenna;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.proxies.ScRfAccessProxy;
import se.ericsson.wcdma.rbs.boam.fpx.scmi.sigs.LrsRfapGetRetprofileRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RetProfileMo;

public class RetProfileMoImpl
extends BoamManagedObject
implements RetProfileMo {
    private static final String MANDATORY = "mandatory";
    private static final int CLIENT_ID = 0;
    private static final int CHECKSUM_MIN = 0;
    private static final int CHECKSUM_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_1_MIN = 0;
    private static final int RET_PARAM_1_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_2_MIN = 0;
    private static final int RET_PARAM_2_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_3_MIN = 0;
    private static final int RET_PARAM_3_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_4_MIN = 0;
    private static final int RET_PARAM_4_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_5_MIN = 0;
    private static final int RET_PARAM_5_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_6_MIN = 0;
    private static final int RET_PARAM_6_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_7_MIN = 0;
    private static final int RET_PARAM_7_MAX = Integer.MAX_VALUE;
    private static final int RET_PARAM_8_MIN = 0;
    private static final int RET_PARAM_8_MAX = Integer.MAX_VALUE;
    private static final String IDENTITY = "identity";
    public static final int MO_DATA_REVISION = 4030001;
    private MoData myData;
    protected ScRfAccessProxy scRfAccessProxy = ScRfAccessProxy.instance();

    public RetProfileMoImpl(ManagedObject parent, AttrList attributes, String identity, int checkedCheckSum, int checkedRetType, int checkedAntennaType, int checkedMinTilt, int checkedMaxTilt, int checkedRetParam1, int checkedRetParam2, int checkedRetParam3, int checkedRetParam4, int checkedRetParam5, int checkedRetParam6, int checkedRetParam7, int checkedRetParam8, Coordinator context) throws MoAccessException {
        super(parent, "RetProfile", identity, context);
        try {
            MessageLog.traceEnter(this.getClass(), "Normal constructor");
            this.initMoData(identity, checkedRetType, checkedAntennaType, attributes, context);
            this.scRfAccessProxy.rfapCreateRetProfile(this.getTxIdTransactional(context), 0, checkedRetType, checkedAntennaType, checkedMinTilt, checkedMaxTilt, checkedRetParam1, checkedRetParam2, checkedRetParam3, checkedRetParam4, checkedRetParam5, checkedRetParam6, checkedRetParam7, checkedRetParam8, checkedCheckSum);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 17) {
                MessageLog.trace(1, this.getClass(), "RetProfile with same antennaType and retType already created.");
            }
            throw e;
        }
    }

    public RetProfileMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter(this.getClass(), "Recovery constructor");
        this.myData = recoveredData;
        MessageLog.trace(1, this.getClass(), "Version Attribute in MoData = " + this.myData.getRevision());
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(RetProfileMoImpl.class, "create() ");
        RetProfileMoImpl thisMo = null;
        RetProfileMoImpl.checkTransaction(context);
        RetProfileMoImpl.checkParent(parent, "RetProfile");
        int checkedCheckSum = ValidateAttributes.checkAndGetIntAttribute(attributes, "checkSum", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetType = ValidateAttributes.checkAndGetIntAttribute(attributes, "retType", MANDATORY, 0, RET_TYPE_MIN_VALUES, RET_TYPE_MAX_VALUES, "RetProfile");
        int checkedAntennaType = ValidateAttributes.checkAndGetIntAttribute(attributes, "antennaType", MANDATORY, 0, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "RetProfile");
        int checkedMinTilt = ValidateAttributes.checkAndGetIntAttribute(attributes, "minTilt", MANDATORY, 0, MIN_TILT_MIN_VALUES, MIN_TILT_MAX_VALUES, "RetProfile");
        int checkedMaxTilt = ValidateAttributes.checkAndGetIntAttribute(attributes, "maxTilt", MANDATORY, 0, MAX_TILT_MIN_VALUES, MAX_TILT_MAX_VALUES, "RetProfile");
        if (checkedMinTilt > checkedMaxTilt) {
            throw new ValueOutOfRangeException("minTilt", "RetProfile");
        }
        int checkedRetParam1 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam1", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam2 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam2", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam3 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam3", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam4 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam4", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam5 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam5", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam6 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam6", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam7 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam7", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        int checkedRetParam8 = ValidateAttributes.checkAndGetIntAttribute(attributes, "retParam8", MANDATORY, 0, 0, Integer.MAX_VALUE, "RetProfile");
        ValidateAttributes.checkOtherAttributes(attributes, "RetProfile");
        thisMo = new RetProfileMoImpl(parent, attributes, identity, checkedCheckSum, checkedRetType, checkedAntennaType, checkedMinTilt, checkedMaxTilt, checkedRetParam1, checkedRetParam2, checkedRetParam3, checkedRetParam4, checkedRetParam5, checkedRetParam6, checkedRetParam7, checkedRetParam8, context);
        return thisMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() ");
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.scRfAccessProxy.rfapDeleteRetProfile(this.getTxIdNonTransactional(context), 0, this.bcmGetIntAttribute("retType", context), this.bcmGetIntAttribute("antennaType", context));
        super.delete(context);
        MessageLog.trace(1, this.getClass(), "RetProfile Mo is Deleted ");
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData() ");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent() ");
        return true;
    }

    public void proxiesAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "proxiesAvailable() ");
    }

    public void proxiesUnavailable() {
        MessageLog.traceEnter(this.getClass(), "proxiesUnavailable() ");
    }

    public String getType() {
        return "RetProfile";
    }

    public String getRetProfileId(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetProfileId()");
        return this.bcmGetStringAttribute(IDENTITY, context);
    }

    public int getCheckSum(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCheckSum()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return (int)rspSig.checkSum;
    }

    public int getRetType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetType()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retType;
    }

    public int getAntennaType(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAntennaType()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.antennaType;
    }

    public int getMinTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMinTilt()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.minTilt;
    }

    public int getMaxTilt(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxTilt()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.maxTilt;
    }

    public int getRetParam1(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam1()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam1;
    }

    public int getRetParam2(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam2()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam2;
    }

    public int getRetParam3(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam3()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam3;
    }

    public int getRetParam4(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam4()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam4;
    }

    public int getRetParam5(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam5()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam5;
    }

    public int getRetParam6(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam6()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam6;
    }

    public int getRetParam7(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam7()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam7;
    }

    public int getRetParam8(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getRetParam8()");
        LrsRfapGetRetprofileRspS rspSig = this.getRetProfileRoData(context);
        return rspSig.retParam8;
    }

    private void initMoData(String identity, int checkedRetType, int checkedAntennaType, AttrList attributes, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()");
        this.myData = new MoData(super.getLocalDistinguishedName(), this.getType(), true, context);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
        this.bcmStoreAndRegisterStringAttribute(IDENTITY, identity);
        this.bcmStoreAndRegisterIntAttribute("retType", checkedRetType);
        this.bcmStoreAndRegisterIntAttribute("antennaType", checkedAntennaType);
        this.myData.setRevision(4030001);
    }

    protected static void checkParent(ManagedObject parent, String moTypeName) throws IllegalParentException {
        if (!(parent instanceof EquipmentMo)) {
            IllegalParentException e = new IllegalParentException(moTypeName);
            throw e;
        }
    }

    private LrsRfapGetRetprofileRspS getRetProfileRoData(Coordinator context) throws MoAccessException {
        LrsRfapGetRetprofileRspS rspSig = this.scRfAccessProxy.rfapGetRetProfile(this.getTxIdNonTransactional(context), 0, this.bcmGetIntAttribute("retType", context), this.bcmGetIntAttribute("antennaType", context));
        return rspSig;
    }

    public int getVerticalBeamWidthMode(Coordinator c) throws MoAccessException {
        return 0;
    }

    public void setVerticalBeamWidthMode(int value, Coordinator c) throws MoAccessException {
    }
}

