/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.cell;

import se.ericsson.cello.equipment.EquipmentMo;
import se.ericsson.cello.mao.Reservable;
import se.ericsson.cello.moframework.AttrList;
import se.ericsson.cello.moframework.IllegalParentException;
import se.ericsson.cello.moframework.IntegerAttribute;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.MoNameAlreadyTakenException;
import se.ericsson.cello.support.debug.MessageLog;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.proxies.EqcSectorAntennaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.ecmi.sigs.EcCreateSaRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.ConfigurationNotSupportedException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.IdentityFormatIncorrectException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.ExternalAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorAntennaMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.SectorMo;

public class ExternalAntennaMoImpl
extends BoamManagedObject
implements ExternalAntennaMo {
    public static final Class SELF = ExternalAntennaMoImpl.class;
    public static final int MO_DATA_REVISION = 8013001;
    private static final int CREATE_DELETE = 1;
    private EqcSectorAntennaProxy eqcSectorAntennaProxy = EqcSectorAntennaProxy.instance();
    private MoData myData;
    private static final int CORRECT_IDENTITY_FORMAT_SEPARATOR_NUMBER = 2;

    protected ExternalAntennaMoImpl(ManagedObject parent, String moTypeName, String identity, Coordinator context, String userLabel, int antennaType, ManagedObject sectorRef, ManagedObject sectorAntennaRef) throws MoNameAlreadyTakenException, MoAccessException {
        super(parent, moTypeName, identity, context);
        MessageLog.traceEnter((Class)SELF, (String)"ExternalAntennaMoImpl()");
        if (!BoamHelper.checkIfIdentityFormatCorrect(identity, 2)) {
            MessageLog.traceError((Class)SELF, (String)("The format of ExternalAntenna identity is incorrect:" + identity + ", the correct format should be: {sectorIndex}-{sectorantenna number}-{sequence number}."));
            throw new IdentityFormatIncorrectException("The format of ExternalAntenna identity is incorrect, the correct format should be: {sectorIndex}-{sectorantenna number}-{sequence number}.");
        }
        EcCreateSaRspS ecSig = this.eqcSectorAntennaProxy.createAntenna(this.getTxIdTransactional(context), 0, ((SectorMo)sectorRef).getSectorFroId(context), true);
        int froId = (int)ecSig.saFroId;
        this.eqcSectorAntennaProxy.setAntennaType(this.getTxIdTransactional(context), 0, froId, antennaType);
        ((SectorMo)sectorRef).reserve(this, context);
        if (sectorAntennaRef != null) {
            ((SectorAntennaMo)sectorAntennaRef).reserve(this, context);
        }
        this.initMoData(userLabel, sectorRef, sectorAntennaRef, froId, context);
        MessageLog.trace((int)1, (Class)SELF, (String)"ExternalAntenna MO created.");
    }

    public ExternalAntennaMoImpl(MoData recoveredData) throws MoNameAlreadyTakenException {
        super(recoveredData.getLocalDistinguishedName());
        MessageLog.traceEnter((Class)SELF, (String)" ExternalAntennaMoImpl()");
        this.myData = recoveredData;
        MessageLog.trace((int)1, (Class)SELF, (String)"ExternalAntenna MO restored.");
    }

    public static synchronized ManagedObject create(ManagedObject parent, AttrList attributes, String identity, ManagedObject source, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"create()");
        ExternalAntennaMoImpl.checkTransaction(context);
        ExternalAntennaMoImpl.checkParent(parent);
        String checkedUserLabel = ValidateAttributes.checkAndGetStringAttribute(attributes, "userLabel", "optional", "", 0, 128, "ExternalAntenna");
        int checkedantennaType = ValidateAttributes.checkAndGetIntAttribute(attributes, "antennaType", "optional", 0, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "ExternalAntenna");
        ManagedObject checkedSectorRef = ExternalAntennaMoImpl.checkAndGetSectorRef("sectorRef", attributes, "mandatory", new String[]{"Sector"}, "ExternalAntenna", context);
        ManagedObject checkedSectorAntennaRef = ExternalAntennaMoImpl.checkAndGetSectorAntennaRef("sectorAntennaRef", attributes, "optional", new String[]{"SectorAntenna"}, "ExternalAntenna", context);
        ValidateAttributes.checkOtherAttributes(attributes, "ExternalAntenna");
        ExternalAntennaMoImpl createdMo = new ExternalAntennaMoImpl(parent, "ExternalAntenna", identity, context, checkedUserLabel, checkedantennaType, checkedSectorRef, checkedSectorAntennaRef);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"delete() ");
        this.getMyMoData().handleTransaction(context, MoData.WRITE_ACCESS);
        int froId = this.getFroId(context);
        this.eqcSectorAntennaProxy.deleteSectorAntenna(this.getTxIdTransactional(context), 0, froId);
        ((Reservable)this.getSectorRef(context)).release((ManagedObject)this, context);
        ManagedObject sectorAntenna = this.getSectorAntennaRef(context);
        if (sectorAntenna != null) {
            ((Reservable)sectorAntenna).release((ManagedObject)this, context);
        }
        super.delete(context);
        MessageLog.trace((int)1, (Class)SELF, (String)"MO is deleted");
    }

    private void initMoData(String userLabel, ManagedObject sectorRef, ManagedObject sectorAntennaRef, int froId, Coordinator context) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"initMoData() ");
        this.myData = new MoData(this.getLocalDistinguishedName(), this.getType(), true, context);
        this.bcmStoreAndRegisterStringAttribute("userLabel", userLabel);
        this.bcmStoreAndRegisterReferenceAttribute("sectorRef", sectorRef);
        this.bcmStoreAndRegisterReferenceAttribute("sectorAntennaRef", sectorAntennaRef);
        this.bcmStoreAndRegisterIntAttribute("froId", froId);
        this.myData.handleTransaction(context, MoData.WRITE_ACCESS);
    }

    private static ManagedObject checkAndGetSectorRef(String attributeName, AttrList attributes, String attrType, String[] refMoTypeNames, String moTypeName, Coordinator context) throws MoAccessException {
        ManagedObject sectorRef = ValidateAttributes.checkAndGetReferenceAttribute(attributeName, attributes, attrType, refMoTypeNames, moTypeName);
        ExternalAntennaMoImpl.isSectorInitialized((SectorMo)sectorRef, context);
        return sectorRef;
    }

    private static ManagedObject checkAndGetSectorAntennaRef(String attributeName, AttrList attributes, String attrType, String[] refMoTypeNames, String moTypeName, Coordinator context) throws MoAccessException {
        ManagedObject sectorAntennaRef = ValidateAttributes.checkAndGetReferenceAttribute(attributeName, attributes, attrType, refMoTypeNames, moTypeName);
        return sectorAntennaRef;
    }

    public static void isSectorInitialized(SectorMo sectorRef, Coordinator context) throws MoAccessException {
        if (sectorRef.isSectorInitialized(context)) {
            throw new ConfigurationNotSupportedException();
        }
    }

    private static void checkParent(ManagedObject parent) throws IllegalParentException {
        String msg = " Illegal parent, Expecting EquipmentMo[Impl], received: ";
        if (parent == null) {
            MessageLog.trace((int)1, (Class)ExternalAntennaMoImpl.class, (String)(msg + "null"));
            throw new IllegalParentException(msg);
        }
        if (!(parent instanceof EquipmentMo)) {
            MessageLog.trace((int)1, (Class)ExternalAntennaMoImpl.class, (String)(msg + parent.getClass().getName()));
            throw new IllegalParentException(msg);
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter((Class)SELF, (String)"getMyMoData() ");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        return true;
    }

    public String getType() {
        return "ExternalAntenna";
    }

    public int getAntennaType(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"getAntennaType() ");
        return this.eqcSectorAntennaProxy.getSaParam((int)this.getTxIdNonTransactional((Coordinator)c), (int)0, (int)this.getFroId((Coordinator)c)).antennaType;
    }

    public ManagedObject getSectorRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), (String)"getSectorRef()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("sectorRef", c);
    }

    public String getUserLabel(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"getUserLabel() ");
        return this.bcmGetStringAttribute("userLabel", c);
    }

    public void setAntennaType(int value, Coordinator c) throws MoAccessException {
        ValidateAttributes.checkTransaction(c);
        ExternalAntennaMoImpl.isSectorInitialized((SectorMo)this.getSectorRef(c), c);
        this.myData.handleTransaction(c, MoData.WRITE_ACCESS);
        ValidateAttributes.intValueRangeCheck("antennaType", value, ANTENNA_TYPE_MIN_VALUES, ANTENNA_TYPE_MAX_VALUES, "ExternalAntenna");
        this.eqcSectorAntennaProxy.setAntennaType(this.getTxIdTransactional(c), 0, this.getFroId(c), value);
        this.sendAVC("antennaType", value, c);
    }

    public void setUserLabel(String value, Coordinator c) throws MoAccessException {
        MessageLog.traceEnter((Class)SELF, (String)"setUserLabel() ");
        this.bcmSetStringAttribute("userLabel", value, 0, 128, "ExternalAntenna", c);
        this.sendAVC("userLabel", value, c);
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter((Class)SELF, (String)"getFroId()");
        IntegerAttribute intAttr = (IntegerAttribute)this.myData.getAttribute("froId");
        return intAttr.getValue(c);
    }

    public SectorAntennaMo getFirstSectorAntenna(Coordinator context) throws MoAccessException {
        SectorMo sector = (SectorMo)this.getSectorRef(context);
        if (sector == null) {
            MessageLog.traceError(this.getClass(), (String)"Could not get Sector MO from ExternalAntenna.sectorRef");
            return null;
        }
        ManagedObject[] sectorAntennaList = sector.getSectorAntennasRef(context);
        if (sectorAntennaList == null) {
            MessageLog.traceError(this.getClass(), (String)"Could not get sectorAntennasRef from sectorRef in ExternalAntenna");
            return null;
        }
        for (int i = 0; i < sectorAntennaList.length; ++i) {
            SectorAntennaMo sectorAntenna = (SectorAntennaMo)sectorAntennaList[i];
            if (sectorAntenna.getInternalSectorAntennaNo() != 1) continue;
            return sectorAntenna;
        }
        return null;
    }

    public ManagedObject getSectorAntennaRef(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), (String)"getSectorAntennaRef()");
        this.myData.handleTransaction(c, MoData.READ_ACCESS);
        return this.bcmGetReferenceAttribute("sectorAntennaRef", c);
    }
}

