/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import java.util.Iterator;
import java.util.List;
import se.ericsson.cello.moframework.AttrNotReadableException;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.ResourceLockedException;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.TransactionRequiredException;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.AichDeprecatedProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcMeasurementProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcPrachProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcGetAichParamRspS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AichMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.DbchDeviceSetMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.AichMoFactory;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.ChannelHelper;
import se.ericsson.wcdma.rbs.boam.pms.iface.ProxyScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.Counter;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class AichMoImpl
extends BoamManagedObject
implements AichMo {
    private final int aichFroId;
    private final DbchDeviceSetMo dbchDeviceSetRef;
    private final MoData myData;
    private final ChcPrachProxy chcPrachProxy = ChcPrachProxy.instance();
    private final ChcMeasurementProxy chcMeasurementProxy = ChcMeasurementProxy.instance();
    private final AichDeprecatedProxy deprecatedFroProxy = AichDeprecatedProxy.instance();
    private final MoScanner myScanner;
    private final MoScanner deprecatedScanner;

    private AichMoImpl(ManagedObject parent, int aichFroId, int dbchDeviceSetFroId, String thisMoName, String identity) throws MoAccessException {
        super(parent, thisMoName, identity, null);
        MessageLog.traceEnter(this.getClass(), "Aich Normal constructor");
        this.myData = new MoData(this.getLocalDistinguishedName(), "Aich", false, null);
        this.aichFroId = aichFroId;
        this.dbchDeviceSetRef = (DbchDeviceSetMo)ChannelHelper.resolveDeviceSetRefAndReserve(dbchDeviceSetFroId, "DbchDeviceSet", this);
        this.myScanner = this.createMoScanner(this.chcMeasurementProxy, AichMoFactory.instance().getNonDeprecatedCounters());
        this.deprecatedScanner = this.createMoScanner(this.deprecatedFroProxy, AichMoFactory.instance().getDeprecatedCounters());
        MessageLog.trace(1, this.getClass(), "MO Created");
    }

    private MoScanner createMoScanner(ProxyScanner proxy, List counters) {
        try {
            int[] additionalInfo = new int[2];
            ManagedObject parent = this.getParent();
            if (parent instanceof CarrierMo) {
                MaoHasFro rbsLocalCell = (MaoHasFro)BoamHelper.getFirstMatchingMo(((BoamManagedObject)parent).getReservedBy(null), "RbsLocalCell");
                additionalInfo[0] = rbsLocalCell.getFroId(null);
                additionalInfo[1] = ((MaoHasFro)parent).getFroId(null);
            } else {
                additionalInfo[0] = ((MaoHasFro)parent).getFroId(null);
            }
            return new MoScanner(this, proxy, this.aichFroId, 0, counters, additionalInfo, false, null);
        }
        catch (Exception pmse) {
            MessageLog.traceError(this.getClass(), "could not create MoScanner: " + pmse);
            return null;
        }
    }

    public static synchronized ManagedObject create(ManagedObject parent, int aichFroId, int dbchDeviceSetFroId, String thisMoName, String identity) throws MoAccessException {
        MessageLog.traceEnter(AichMoImpl.class, "create()");
        AichMoImpl createdMo = new AichMoImpl(parent, aichFroId, dbchDeviceSetFroId, thisMoName, identity);
        return createdMo;
    }

    public void delete(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete()");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void deleteAich(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "deleteAich()");
        if (this.myScanner != null) {
            this.myScanner.delete(context);
        }
        if (this.deprecatedScanner != null) {
            this.deprecatedScanner.delete(context);
        }
        if (super.isReserved(context)) {
            MessageLog.trace(1, this.getClass(), " this Mo is reserved and can not be deleted ");
            throw new UndeletableMoException((ManagedObject)this);
        }
        if (this.dbchDeviceSetRef != null) {
            this.dbchDeviceSetRef.release(this, null);
        }
        super.delete(context);
    }

    public String getType() {
        return "Aich";
    }

    public int getOperationalState(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        ChcGetAichParamRspS rspSig = this.chcPrachProxy.getAichParam(0, this.aichFroId);
        return rspSig.aichOpState;
    }

    public int getAvailabilityStatus(Coordinator context) throws MoAccessException, TransactionRequiredException, ResourceLockedException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        ChcGetAichParamRspS rspSig = this.chcPrachProxy.getAichParam(0, this.aichFroId);
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.aichAvailStatus);
    }

    public Struct actionReadNbapData(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myData.handleTransaction(context, MoData.READ_ACCESS);
        ChcGetAichParamRspS rspSig = this.chcPrachProxy.getAichParam(0, this.aichFroId);
        return this.convertSigToStruct(rspSig);
    }

    public ManagedObject getDbchDeviceSetRef(Coordinator context) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getDbchDeviceSetRef()");
        return this.dbchDeviceSetRef;
    }

    private Struct convertSigToStruct(ChcGetAichParamRspS rspSig) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "convertSigToStruct() ");
        String[] names = new String[4];
        Object[] values = new Object[4];
        names[0] = "dlChannelisationCodeNo";
        names[1] = "aichTiming";
        names[2] = "aichPower";
        names[3] = "phChId";
        Integer dlChanCodeNo = new Integer(rspSig.dlChanCodeNo);
        Integer aichTiming = new Integer(rspSig.aichTiming);
        Integer aichPower = new Integer(rspSig.aichPower);
        Integer aichPhysChId = new Integer(rspSig.aichPhysChId);
        values[0] = dlChanCodeNo;
        values[1] = aichTiming;
        values[2] = aichPower;
        values[3] = aichPhysChId;
        if (rspSig.nbapIsValid == 1) {
            return new StructImpl(names, values);
        }
        MessageLog.trace(2, this.getClass(), "Nbap data is not valid");
        throw new AttrNotReadableException((ManagedObject)this, "AichDataNotValid");
    }

    public int getFroId(Coordinator c) {
        MessageLog.traceEnter(this.getClass(), "getFroId()");
        return this.aichFroId;
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()");
        return false;
    }

    public int[] getScannerValue(String name) throws MoAccessException {
        if (this.myScanner == null || this.deprecatedScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        if (this.isDeprecatedCounter(name)) {
            return this.deprecatedScanner.getValue(name);
        }
        return this.myScanner.getValue(name);
    }

    public void moScannerServiceNotAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "moScannerServiceNotAvailable() ");
        this.myScanner.serviceRemoved(this.chcPrachProxy.getServiceName());
    }

    private boolean isDeprecatedCounter(String name) {
        Iterator iter = AichMoFactory.instance().getDeprecatedCounters().iterator();
        boolean result2 = false;
        while (iter.hasNext()) {
            Counter counter = (Counter)iter.next();
            if (!counter.getName().equals(name)) continue;
            result2 = true;
            break;
        }
        return result2;
    }
}

