/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.channel;

import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoData;
import se.ericsson.cello.moframework.Struct;
import se.ericsson.cello.moframework.StructImpl;
import se.ericsson.cello.moframework.UndeletableMoException;
import se.ericsson.cello.moframework.ValueOutOfRangeException;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.AvailabilityStatusIntToEnum;
import se.ericsson.wcdma.rbs.boam.common.FroRequestFailedException;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.proxies.ChcHsdpaProxy;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.ChcHsdpaGetMaxAvailMMExtraPowerRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaGetFixbufRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaGetHsdschParamRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaGetRdbtRspS;
import se.ericsson.wcdma.rbs.boam.fpx.chmi.sigs.LrsHsdpaHsdschCreatedIndS;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamHelper;
import se.ericsson.wcdma.rbs.boam.mao.bcm.BoamManagedObject;
import se.ericsson.wcdma.rbs.boam.mao.common.MaoHasFro;
import se.ericsson.wcdma.rbs.boam.mao.common.ValidateAttributes;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.AlreadyActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.InternalErrorException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NoTxDiversityException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotActiveException;
import se.ericsson.wcdma.rbs.boam.mao.iface.gen.excep.NotFoundException;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.CarrierMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.HsDschResourcesMo;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.RbsLocalCellMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.channel.HsDschResourcesMoFactory;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;

public class HsDschResourcesMoImpl
extends BoamManagedObject
implements HsDschResourcesMo {
    public static final int MO_DATA_REVISION = 0;
    private static final String TOTAL_POWER = "totalPower";
    private static final String NO_OF_HS_PDSCH_CODES = "noOfHsPdschCodes";
    private static final String HS_PDSCH_START_CODE_NUMBER = "hsPdschStartCodeNumber";
    private static final String NO_OF_HS_SCCH_CODES = "noOfHsScchCodes";
    private static final String HS_SCCH_CODE_NUMBER = "hsScchCodeNumber";
    private static final String SCRAMBLING_CODE = "scramblingCode";
    private static final ChcHsdpaProxy relatedProxy = ChcHsdpaProxy.instance();
    private final MoData myMoData;
    private final MoScanner myScanner;

    private HsDschResourcesMoImpl(ManagedObject checkedParent, String thisMoName, String identity, Coordinator context) throws MoAccessException {
        super(checkedParent, thisMoName, identity, context);
        MessageLog.traceEnter(this.getClass(), "HsDschResourcesMoImpl <---");
        this.myMoData = this.initMoData();
        MessageLog.trace(1, this.getClass(), "create MoScanner <---");
        int[] additionalInfo = new int[]{0};
        this.myScanner = new MoScanner(this, relatedProxy, this.getCellFroId(context), 0, HsDschResourcesMoFactory.instance().getCounters(), additionalInfo, false, context);
    }

    public static synchronized ManagedObject createHsDschResources(LrsHsdpaHsdschCreatedIndS sig) throws MoAccessException {
        MessageLog.traceEnter(HsDschResourcesMoImpl.class, "createHsDschResources() <---");
        RbsLocalCellMo cellRef = (RbsLocalCellMo)BoamHelper.getMoForFroId("RbsLocalCell", sig.cellFroId);
        RbsLocalCellMo parent = cellRef.isCombinedCell(null) ? cellRef : cellRef.getCarriersRef(null)[0];
        return new HsDschResourcesMoImpl(parent, "HsDschResources", "1", null);
    }

    public void delete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "delete() <---");
        throw new UndeletableMoException((ManagedObject)this);
    }

    public void sysDelete(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "sysDelete() <---");
        this.myMoData.delete(c);
        this.myScanner.delete(c);
        super.delete(c);
        MessageLog.trace(1, this.getClass(), "HsDschResources is deleted !");
    }

    private MoData initMoData() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "initMoData()<--");
        MoData result2 = new MoData(this.getLocalDistinguishedName(), this.getType(), false, null);
        result2.setRevision(0);
        return result2;
    }

    public String getType() {
        return "HsDschResources";
    }

    public int getAvailabilityStatus(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getAvailabilityStatus()");
        LrsHsdpaGetHsdschParamRspS rspSig = relatedProxy.getHsdschParam(0, ValidateAttributes.getTxIdNonTransactional(c), this.getCellFroId(c));
        return AvailabilityStatusIntToEnum.convGetAvailStatIntToEnum(rspSig.availStatus);
    }

    public int getOperationalState(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getOperationalState()");
        LrsHsdpaGetHsdschParamRspS rspSig = relatedProxy.getHsdschParam(0, ValidateAttributes.getTxIdNonTransactional(c), this.getCellFroId(c));
        return rspSig.operationalState;
    }

    public boolean getPnOnScchDschIsActive(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getPnOnScchDschIsActive()");
        return relatedProxy.getPnOnScchDschIsActive(0, this.getCellFroId(c), c);
    }

    public void actionStartPnOnHsScchHsDsch(int transmissionMode, int hsPdschDivMode, int hsPdschModulationScheme, int hsScchModulationScheme, int hsScchCodeNumber, int hsPdschCodeMap, int hsDschTbSize, int nir, int xrv, int ueId, int numOfHarq, int hsPdschPower, int hsScchPower, Coordinator c) throws MoAccessException {
        CarrierMo carrier;
        int numTxBranches;
        MessageLog.traceEnter(this.getClass(), "actionStartPnOnHsScchHsDsch()");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        if (hsPdschDivMode == 1 && (numTxBranches = (carrier = (CarrierMo)this.getParent()).getNumberOfTxBranches(c)) != 2) {
            throw new NoTxDiversityException("Precondition not met");
        }
        switch (transmissionMode) {
            case 3: 
            case 7: {
                break;
            }
            default: {
                throw new ValueOutOfRangeException("transmissionMode", "HsDschResources");
            }
        }
        ValidateAttributes.intValueRangeCheck("hsPdschDivMode", hsPdschDivMode, 0, 1, this.getType());
        ValidateAttributes.intValueRangeCheck("hsPdschModulationScheme", hsPdschModulationScheme, 0, 3, this.getType());
        ValidateAttributes.intValueRangeCheck("hsScchModulationScheme", hsScchModulationScheme, 0, 1, this.getType());
        ValidateAttributes.intValueRangeCheck(HS_SCCH_CODE_NUMBER, hsScchCodeNumber, 0, 127, this.getType());
        ValidateAttributes.intValueRangeCheck("hsPdschCodeMap", hsPdschCodeMap, 0, 127, this.getType());
        ValidateAttributes.intValueRangeCheck("hsDschTbSize", hsDschTbSize, 1, 63, this.getType());
        ValidateAttributes.intValueRangeCheck("xrv", xrv, 0, 7, this.getType());
        ValidateAttributes.intValueRangeCheck("ueId", ueId, 0, 65535, this.getType());
        ValidateAttributes.intValueRangeCheck("numOfHarq", numOfHarq, 1, 8, this.getType());
        ValidateAttributes.intValueRangeCheck("hsPdschPower", hsPdschPower, 0, 430, this.getType());
        ValidateAttributes.intValueRangeCheck("hsScchPower", hsScchPower, 0, 430, this.getType());
        try {
            relatedProxy.actionStartPnOnHsScchHsDsch(this.getCellFroId(c), transmissionMode, hsPdschDivMode, hsPdschModulationScheme, hsScchModulationScheme, hsScchCodeNumber, hsPdschCodeMap, hsDschTbSize, nir, xrv, ueId, numOfHarq, hsPdschPower, hsScchPower, c);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 17) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public void actionStopPnOnHsScchHsDsch(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionStopPnOnHsScchHsDsch()");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        try {
            relatedProxy.actionStopPnOnHsScchHsDsch(this.getCellFroId(c), c);
        }
        catch (FroRequestFailedException e) {
            if (e.getOrgErrorCode() == 17) {
                throw new AlreadyActiveException();
            }
            if (e.getOrgErrorCode() == 3) {
                throw new InternalErrorException();
            }
            throw e;
        }
    }

    public Struct actionReadNbapData(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "actionReadNbapData()");
        this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
        LrsHsdpaGetHsdschParamRspS rspSig = relatedProxy.getHsdschParam(0, ValidateAttributes.getTxIdNonTransactional(c), this.getCellFroId(c));
        return this.convertSigToStruct(rspSig);
    }

    private Struct convertSigToStruct(LrsHsdpaGetHsdschParamRspS rspSig) {
        if (rspSig == null) {
            return null;
        }
        String[] names = new String[]{TOTAL_POWER, SCRAMBLING_CODE, NO_OF_HS_PDSCH_CODES, HS_PDSCH_START_CODE_NUMBER, NO_OF_HS_SCCH_CODES, HS_SCCH_CODE_NUMBER, HS_SCCH_CODE_NUMBER, HS_SCCH_CODE_NUMBER, HS_SCCH_CODE_NUMBER};
        for (int i = 0; i < rspSig.hsScchCodeNumber.length; ++i) {
            int n = i + 5;
            names[n] = names[n] + i;
        }
        Object[] values = new Integer[]{new Integer(rspSig.totalPower), new Integer(rspSig.scramblingCode), new Integer(rspSig.noOfHsPdschCodes), new Integer(rspSig.hsPdschStartCodeNumber), new Integer(rspSig.noOfHsScchCodes), new Integer(rspSig.hsScchCodeNumber[0]), new Integer(rspSig.hsScchCodeNumber[1]), new Integer(rspSig.hsScchCodeNumber[2]), new Integer(rspSig.hsScchCodeNumber[3])};
        return new StructImpl(names, values);
    }

    private int getCellFroId(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getCellFroId");
        ManagedObject parent = this.getParent();
        if (parent instanceof CarrierMo) {
            RbsLocalCellMo cell = (RbsLocalCellMo)BoamHelper.getFirstMatchingMo(((CarrierMo)parent).getReservedBy(c), "RbsLocalCell");
            if (cell == null) {
                throw new NotFoundException("RbsLocalCell is not found");
            }
            return cell.getFroId(c);
        }
        return ((MaoHasFro)parent).getFroId(c);
    }

    public void actionSetFixedBuffersCellHidden(Coordinator c) throws MoAccessException {
        block3: {
            MessageLog.traceEnter(this.getClass(), "actionSetFixedBuffersCellHidden()");
            this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
            try {
                relatedProxy.actionSetFixedBuffersCellHidden(0, this.getCellFroId(c));
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() == 15) {
                    throw new AlreadyActiveException();
                }
                if (e.getOrgErrorCode() != 3) break block3;
                throw new InternalErrorException();
            }
        }
    }

    public void actionReleaseFixedBuffersCellHidden(Coordinator c) throws MoAccessException {
        block2: {
            MessageLog.traceEnter(this.getClass(), "actionReleaseFixedBuffersCellHidden()");
            this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
            try {
                relatedProxy.actionReleaseFixedBuffersCellHidden(0, this.getCellFroId(c));
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() != 16) break block2;
                throw new NotActiveException();
            }
        }
    }

    public void actionStopRdbtCellHidden(int measType, Coordinator c) throws MoAccessException {
        block2: {
            MessageLog.traceEnter(this.getClass(), "actionStopRdbtCellHidden");
            this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
            this.validateStopRdbtMeasType(measType);
            try {
                relatedProxy.actionStopRDBTCellHidden(0, measType, this.getCellFroId(c));
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() != 8) break block2;
                throw new NotActiveException();
            }
        }
    }

    private void validateStopRdbtMeasType(int measType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "validateStopRdbtMeasType() ");
        if (measType != 16) {
            throw new ValueOutOfRangeException("measType : " + measType, "HsDschResources");
        }
    }

    public void actionStartRdbtCellHidden(int measType, Coordinator c) throws MoAccessException {
        block3: {
            MessageLog.traceEnter(this.getClass(), "actionStartRdbtCellHidden()");
            this.myMoData.handleTransaction(c, MoData.READ_ACCESS);
            this.validateStartRdbtMeasType(measType);
            try {
                relatedProxy.actionStartRDBTCellHidden(0, measType, this.getCellFroId(c));
            }
            catch (FroRequestFailedException e) {
                if (e.getOrgErrorCode() == 7) {
                    throw new AlreadyActiveException();
                }
                if (e.getOrgErrorCode() != 3) break block3;
                throw new InternalErrorException();
            }
        }
    }

    private void validateStartRdbtMeasType(int measType) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "validateStartRdbtMeasType() ");
        if (measType != 16) {
            throw new ValueOutOfRangeException("measType : " + measType, "HsDschResources");
        }
    }

    public MoData getMyMoData() {
        MessageLog.traceEnter(this.getClass(), "getMyMoData()");
        return this.myMoData;
    }

    public boolean isMyMoDataPersistent() {
        MessageLog.traceEnter(this.getClass(), "isMyMoDataPersistent()<--");
        return false;
    }

    public int getActiveRdbtCellMeasurements(Coordinator c) throws FroRequestFailedException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getActiveRdbtCellMeasurements()");
        LrsHsdpaGetRdbtRspS lrsHsdpaGetRdbtRspS = relatedProxy.getRdbtCellMeasurements(0, this.getCellFroId(c), c);
        boolean uniqueElement = false;
        return lrsHsdpaGetRdbtRspS.activeMeasurement[0];
    }

    public boolean getFixedBuffersIsActive(Coordinator c) throws FroRequestFailedException, MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getFixedBuffersIsActive() ");
        LrsHsdpaGetFixbufRspS lrsHsdpaGetFixbufRspS = relatedProxy.getFixedBuffersIsActive(0, this.getCellFroId(c), c);
        return lrsHsdpaGetFixbufRspS.fixedBuffersIsActive == 1;
    }

    public int[] getScannerValue(String counterName) throws MoAccessException {
        if (this.myScanner == null) {
            throw new PmsException("MoScanner not available");
        }
        return this.myScanner.getValue(counterName);
    }

    public void moScannerServiceNotAvailable() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "moScannerServiceNotAvailable() ");
        this.myScanner.serviceRemoved(relatedProxy.getServiceName());
    }

    public int getMaxAvailMixedModeExtraPower(Coordinator c) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMaxAvailMixedModeExtraPower()");
        ChcHsdpaGetMaxAvailMMExtraPowerRspS rspSig = relatedProxy.getHsdschMaxAvailMMExtraPower(0, this.getCellFroId(c));
        return rspSig.maxAvailMixedModeExtraPower;
    }
}

