/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import java.util.ArrayList;
import se.ericsson.cello.equipment.PiuDeviceMo;
import se.ericsson.cello.equipment.PlugInUnitMo;
import se.ericsson.cello.moframework.ManagedObject;
import se.ericsson.cello.moframework.MibMgr;
import se.ericsson.cello.moframework.MoAccessException;
import se.ericsson.cello.moframework.MoIterator;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.mao.iface.mo.AuxPlugInUnitMo;
import se.ericsson.wcdma.rbs.boam.mao.rmo.node.NsaStatusAreas;

public class NsaStatusActions {
    public static final int CHK_LOCKED = 0;
    public static final int CHK_FAULTY = 1;
    private int statusArea;
    private int areaCheckType;
    private Coordinator context;
    boolean areaMatchedUnderPiu = false;

    public NsaStatusActions(int statusArea, int checkType, Coordinator context) {
        this.statusArea = statusArea;
        this.areaCheckType = checkType;
        this.context = context;
    }

    public ManagedObject[] getMos() throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "getMos() with area=" + NsaStatusAreas.areaName4Enum(this.statusArea) + " (" + this.statusArea + ")" + " checking " + this.checkName4Enum(this.areaCheckType) + "(" + this.statusArea + ")" + ".");
        ArrayList resultList = new ArrayList();
        if (this.areaCheckType == 0) {
            this.traverseAndCollect(1, resultList);
            if (resultList.size() > 0) {
                return new ManagedObject[0];
            }
        }
        this.traverseAndCollect(this.areaCheckType, resultList);
        return resultList.toArray(new ManagedObject[resultList.size()]);
    }

    private boolean checkLocked(ManagedObject mo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkLocked()");
        if (mo.getType().equals("PlugInUnit")) {
            if (((PlugInUnitMo)mo).getAdministrativeState(this.context) == 0) {
                return true;
            }
        } else if (mo.getType().equals("PiuDevice")) {
            if (((PiuDeviceMo)mo).getAdministrativeState(this.context) == 0) {
                return true;
            }
        } else if (mo.getType().equals("AuxPlugInUnit")) {
            if (((AuxPlugInUnitMo)mo).getAdministrativeState(this.context) == 0) {
                return true;
            }
        } else if (NsaStatusAreas.moSpecialForTransport(mo)) {
            Integer admState = (Integer)mo.getAttribute("administrativeState", this.context);
            Object reservedBy = mo.getAttribute("reservedByTraffic", this.context);
            if (reservedBy != null && admState == 0) {
                return true;
            }
        }
        return false;
    }

    private boolean checkFaulty(ManagedObject mo) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "checkFaulty()");
        Integer operState = new Integer(1);
        if (!mo.getType().equals("SwitchCoreUnit") && !mo.getType().equals("SwitchInternalLink")) {
            operState = (Integer)mo.getAttribute("operationalState", this.context);
        }
        Integer availStatus = new Integer(0);
        if (!(mo.getType().equals("GeneralProcessorUnit") || mo.getType().equals("SwitchCoreUnit") || mo.getType().equals("SwitchInternalLink"))) {
            availStatus = (Integer)mo.getAttribute("availabilityStatus", this.context);
        }
        return operState == 0 && (availStatus & 0x446) != 0;
    }

    private void traverseAndCollect(int checkType, ArrayList resultList) throws MoAccessException {
        ManagedObject rootMo = MibMgr.instance().getMib().getRootMo();
        this.traverseAndCollect(checkType, rootMo, resultList);
    }

    private void traverseAndCollect(int checkType, ManagedObject mo, ArrayList resultList) throws MoAccessException {
        MessageLog.traceEnter(this.getClass(), "traverseAndCollect() visiting " + mo.getLocalDistinguishedName() + ".");
        if (mo instanceof PlugInUnitMo || mo instanceof AuxPlugInUnitMo) {
            this.areaMatchedUnderPiu = false;
        }
        MoIterator childIter = mo.getChildren();
        while (childIter.hasMoreElements()) {
            this.traverseAndCollect(checkType, childIter.nextMo(), resultList);
        }
        if (NsaStatusAreas.moInArea(mo, this.statusArea)) {
            MessageLog.trace(2, this.getClass(), "traverseAndCollect() checking an area-matching MO: " + mo.getLocalDistinguishedName() + ".");
            this.areaMatchedUnderPiu = true;
            if (checkType == 0 && this.checkLocked(mo) || checkType == 1 && this.checkFaulty(mo)) {
                resultList.add(mo);
                MessageLog.trace(2, this.getClass(), "traverseAndCollect() non-PIU with condition found: " + mo.getLocalDistinguishedName() + " was added" + ".");
            }
        } else if (mo instanceof PlugInUnitMo || mo instanceof AuxPlugInUnitMo) {
            MessageLog.trace(2, this.getClass(), "traverseAndCollect() checking a PIU: " + mo.getLocalDistinguishedName() + ".");
            if (this.areaMatchedUnderPiu) {
                MessageLog.trace(2, this.getClass(), "traverseAndCollect() area found to be matched under PIU.");
                if (checkType == 0 && this.checkLocked(mo) || checkType == 1 && this.checkFaulty(mo)) {
                    resultList.add(mo);
                    MessageLog.trace(2, this.getClass(), "traverseAndCollect() PIU with condition found: " + mo.getLocalDistinguishedName() + " (" + mo.toString() + ")" + " was added" + ".");
                }
            }
        }
    }

    public String checkName4Enum(int checkType) {
        return checkType == 0 ? "LOCKED" : (checkType == 1 ? "FAULTY" : "unknown");
    }
}

