/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.mao.rmo.node;

import se.ericsson.cello.moframework.ManagedObject;

public class NsaStatusAreas {
    private static final String[] controlMoTypes = new String[]{"GeneralProcessorUnit", "SwitchCoreUnit", "SwitchInternalLink", "TimingUnit", "TuDeviceGroup", "TimDeviceSet", "TimDevice"};
    private static final String[] basebandMoTypes = new String[]{"TxDeviceGroup", "DbchDeviceSet", "DbccDeviceSet", "DbccDevice", "RaxDeviceGroup", "UbchDeviceSet", "ObifDeviceGroup", "RuifDeviceGroup", "EDbchDeviceSet", "EScDeviceSet", "HsDbchDeviceSet", "PiuDevice", "RAX", "TX", "DUI"};
    private static final String[] radioMoTypes = new String[]{"TrxDeviceGroup", "TrDeviceSet", "TrDevice", "AiuDeviceGroup", "SaiuDeviceGroup", "AiDeviceSet", "AiDevice", "McpaDeviceGroup", "PauDeviceGroup", "TpaDeviceSet", "TpaDevice", "RfifDeviceGroup", "DpclDeviceSet", "DpclDevice", "AscDeviceGroup", "TmaDeviceSet", "TmaDevice", "RruDeviceGroup", "FuDeviceGroup", "RuDeviceGroup", "RRU", "RUW", "RRUW"};
    private static final String[] transportMoTypes = new String[]{"ExchangeTerminal", "E3PhysPathTerm", "T3PhysPathTerm", "Os155SpiTtp", "E1PhysPathTerm", "T1PhysPathTerm", "J1PhysPathTerm", "ExchangeTerminalIp", "GigaBitEthernet"};
    private static final String[] specialTransportMoTypes = new String[]{"E1PhysPathTerm", "T1PhysPathTerm", "J1PhysPathTerm"};

    public static boolean moInArea(ManagedObject mo, int area) {
        if (mo.getType().equals("DeviceGroup")) {
            return NsaStatusAreas.inArray(mo.getNamingAttributeValue(), NsaStatusAreas.getMoTypesForArea(area));
        }
        return NsaStatusAreas.inArray(mo.getType(), NsaStatusAreas.getMoTypesForArea(area));
    }

    private static String[] getMoTypesForArea(int area) {
        switch (area) {
            case 0: {
                return controlMoTypes;
            }
            case 1: {
                return basebandMoTypes;
            }
            case 2: {
                return radioMoTypes;
            }
            case 3: {
                return transportMoTypes;
            }
        }
        return new String[0];
    }

    public static boolean moSpecialForTransport(ManagedObject mo) {
        return NsaStatusAreas.inArray(mo.getType(), NsaStatusAreas.getMoTypesSpecialForTransport());
    }

    private static String[] getMoTypesSpecialForTransport() {
        return specialTransportMoTypes;
    }

    public static String areaName4Enum(int enumValue) {
        switch (enumValue) {
            case 0: {
                return "CONTROL";
            }
            case 1: {
                return "BASEBAND";
            }
            case 2: {
                return "RADIO";
            }
            case 3: {
                return "TRANSPORT";
            }
        }
        return null;
    }

    private static boolean inArray(String sample, String[] array) {
        for (int i = 0; i < array.length; ++i) {
            if (!sample.equals(array[i])) continue;
            return true;
        }
        return false;
    }
}

