/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.boam.pms.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import se.ericsson.cello.pms.generic.BasicScanner;
import se.ericsson.cello.pms.generic.DataConsumer;
import se.ericsson.cello.pms.generic.GranularityAndAttributeActivationException;
import se.ericsson.cello.pms.generic.GranularityPeriod;
import se.ericsson.cello.pms.generic.GranularityPeriodNotSupportedException;
import se.ericsson.cello.pms.generic.MeasuredData;
import se.ericsson.cello.pms.generic.MeasuredDataUpdatable;
import se.ericsson.cello.pms.generic.NumberOfCountersExceededException;
import se.ericsson.cello.pms.generic.ObservationClass;
import se.ericsson.cello.pms.generic.ObservationObject;
import se.ericsson.cello.pms.generic.OverloadException;
import se.ericsson.cello.pms.generic.ParameterNotAcceptedException;
import se.ericsson.cello.pms.generic.PerformanceMonitoringState;
import se.ericsson.cello.transaction.Coordinator;
import se.ericsson.cello.transaction.InactiveTransactionException;
import se.ericsson.cello.transaction.Resource;
import se.ericsson.wcdma.rbs.boam.common.MoDistinguishedNameParser;
import se.ericsson.wcdma.rbs.boam.common.log.MessageLog;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterInOtherScannerException;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScanner;
import se.ericsson.wcdma.rbs.boam.pms.impl.CounterScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.DelayManager;
import se.ericsson.wcdma.rbs.boam.pms.impl.GroupInOtherScannerException;
import se.ericsson.wcdma.rbs.boam.pms.impl.LoadDistributer;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgent;
import se.ericsson.wcdma.rbs.boam.pms.impl.MoScannerAgentMgr;
import se.ericsson.wcdma.rbs.boam.pms.impl.PmsException;
import se.ericsson.wcdma.rbs.boam.pms.impl.PredefinedScannerMgr;
import se.ericsson.wcdma.rbs.boam.pms.impl.ScannedData;

public class RBScanner
extends BasicScanner {
    private final HashSet counterScannerAgentSet = new HashSet(1);
    private final HashSet counterScannerSet = new HashSet(1);
    private final Object counterScannerSetLock = new Object();
    private ObservationClass[] ocList;
    private PerformanceMonitoringState underFlyState;
    private boolean isSuspended = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RBScanner(ObservationClass[] ocList, ObservationObject[] ooList, GranularityPeriod granularityPeriod, PerformanceMonitoringState state, DataConsumer destination, String measurementName, Coordinator context) throws GranularityPeriodNotSupportedException, NumberOfCountersExceededException, GranularityAndAttributeActivationException, OverloadException, ParameterNotAcceptedException {
        super(granularityPeriod, state, destination, measurementName, context);
        this.underFlyState = state;
        String orgName = "";
        try {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "RBScanner() ");
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "CREATE_SCANNER_");
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The Scanner name:" + measurementName);
            this.handleCounters(ocList, ooList);
            this.handleTX(context, ScannerOperation.CREATE_OPERATION);
            this.checkForPredefScanner();
        }
        finally {
            this.changeThreadName2Org(orgName);
        }
    }

    private void changeThreadName(String orgName, String perfix) {
        Thread.currentThread().setName(perfix + orgName);
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Thread name changed for traceability: " + orgName + "  ==> " + perfix + orgName);
    }

    private void changeThreadName2Org(String orgName) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Operation finished, restoring original thread name: " + orgName);
        Thread.currentThread().setName(orgName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitCreate() {
        String orgName = "";
        try {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "commitCreate() ");
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "COMMIT_CREATE_SCANNER_");
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The Scanner name:" + this.name);
            this.initState(this.underFlyState);
        }
        finally {
            this.changeThreadName2Org(orgName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rollbackCreate() {
        String orgName = "";
        try {
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "ROLLBACK_CREATE_SCANNER_");
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "roolbeckCreate(),scanner name:" + this.name);
            this.release();
            PredefinedScannerMgr.instance().rollbackCreate(this);
        }
        finally {
            this.changeThreadName2Org(orgName);
        }
    }

    private void activate() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "activate(),scanner name:" + this.name);
        this.isSuspended = false;
        Iterator iter = this.counterScannerAgentSet.iterator();
        while (iter.hasNext()) {
            CounterScannerAgent cntAgent = (CounterScannerAgent)iter.next();
            cntAgent.activate();
        }
        PredefinedScannerMgr.instance().actviateSuspend(this, 3);
    }

    public void addCounterClass(CounterScannerAgent csAgent) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "addCounterClass(),scanner name:" + this.name);
        if (!this.counterScannerAgentSet.add(csAgent)) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The counter object allready exist: " + csAgent.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCounterObject(CounterScanner scanner) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "addCounterObject(),scanner name:" + this.name);
        Object object = this.counterScannerSetLock;
        synchronized (object) {
            if (!this.counterScannerSet.add(scanner)) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "The counter object allready exist: " + scanner.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HashSet getCounterObjectList() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "getCounterObjectList(),scanner name:" + this.name);
        Object object = this.counterScannerSetLock;
        synchronized (object) {
            return this.counterScannerSet;
        }
    }

    public void delete(Coordinator context) {
        super.delete(context);
        try {
            this.handleTX(context, ScannerOperation.DELETE_OPERATION);
        }
        catch (Exception e) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "Failed to delete() scanner, name:" + this.name + ", Excep:", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitDelete() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "commitDelete(),scanner name:" + this.name);
        String orgName = "";
        try {
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "DELETE_SCANNER_");
            this.release();
            PredefinedScannerMgr.instance().deleteScanner(this);
        }
        finally {
            this.changeThreadName2Org(orgName);
        }
    }

    public int getGPInMinutes() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "getGPInMinutes(),scanner name:" + this.name);
        return this.granularityPeriod.inSeconds() / 60;
    }

    private Collection getMoTypeList(Collection collection) {
        HashSet<String> moList = new HashSet<String>(1);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ScannedData data = (ScannedData)iter.next();
            moList.add(MoDistinguishedNameParser.getMoTypeName(data.getMoLdn()));
        }
        return moList;
    }

    private String[] getObservedObjectNameList(Object[] scannedDataList) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "getObservedObjectNameList(),scanner name:" + this.name);
        HashSet<String> nameList = new HashSet<String>(1);
        for (int i = 0; i < scannedDataList.length; ++i) {
            ScannedData data = (ScannedData)scannedDataList[i];
            nameList.add(data.getCounterName());
        }
        return nameList.toArray(new String[nameList.size()]);
    }

    private Collection getMoLdnList(Object[] moInstanceList) {
        HashSet<String> moList = new HashSet<String>(1);
        for (int i = 0; i < moInstanceList.length; ++i) {
            ScannedData data = (ScannedData)moInstanceList[i];
            moList.add(data.getMoLdn());
        }
        return moList;
    }

    private Object[] getScannedDataByMoType(String moTYpeName, Collection collection) {
        ArrayList<ScannedData> moList = new ArrayList<ScannedData>(1);
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            ScannedData data = (ScannedData)iter.next();
            if (!MoDistinguishedNameParser.getMoTypeName(data.getMoLdn()).equals(moTYpeName)) continue;
            moList.add(data);
        }
        return moList.toArray(new ScannedData[moList.size()]);
    }

    private List getSortedValueList(String[] objectNameList, Map dataList) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "getSortedValueList()");
        int[] unDefCounterValue = new int[]{-1};
        ArrayList<int[]> orderedDataList = new ArrayList<int[]>(1);
        StringBuffer msg = new StringBuffer("Counters name and value:");
        for (int i = 0; i < objectNameList.length; ++i) {
            String cntName = objectNameList[i];
            ScannedData data = (ScannedData)dataList.get(cntName);
            if (data == null) {
                MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Using un-default value scanned data not found for: " + cntName);
                orderedDataList.add(unDefCounterValue);
                msg.append("\n\n ").append(i).append("-  ").append(cntName).append("\t Value: ");
                msg.append("-1");
                continue;
            }
            msg.append("\n\n ").append(i).append("-  ").append(cntName).append("\t Value: ");
            msg.append(this.getScannedValueAsStr(data));
            orderedDataList.add(data.getCounterValues());
        }
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), msg.toString());
        return orderedDataList;
    }

    public String getName() {
        return this.name;
    }

    private void handleCounters(ObservationClass[] ocList, ObservationObject[] ooList) throws GranularityAndAttributeActivationException, ParameterNotAcceptedException {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "handleCounters(), scanner name: " + this.name);
        if (ocList == null || ocList.length == 0) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The ObservationClass list is empty.");
            throw new ParameterNotAcceptedException();
        }
        if (ooList != null && ooList.length > 0) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Currently the ObservationObject is not supported!!");
            throw new ParameterNotAcceptedException();
        }
        this.ocList = new ObservationClass[ocList.length];
        for (int i = 0; i < ocList.length; ++i) {
            this.ocList[i] = ocList[i];
            try {
                this.reserve(this.ocList[i]);
                continue;
            }
            catch (GranularityAndAttributeActivationException ge) {
                for (int j = 0; j < i; ++j) {
                    this.releaseReserved(ocList[j], ocList[j].class_attribute_list.length);
                }
                throw new GranularityAndAttributeActivationException(ocList);
            }
        }
    }

    private void handleTX(Coordinator context, ScannerOperation currentOperation) throws ParameterNotAcceptedException {
        if (context == null) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The context is null, transaction is requared!!");
            throw new ParameterNotAcceptedException();
        }
        try {
            context.registerResource((Resource)new PmsResource(this, currentOperation));
        }
        catch (InactiveTransactionException e) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The context is not active, transaction is requared!!");
            throw new ParameterNotAcceptedException();
        }
    }

    private void checkForPredefScanner() throws ParameterNotAcceptedException {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "checkForPredefScanner(),scanner name:" + this.name);
        try {
            PredefinedScannerMgr.instance().addToCreatedPredefScannerList(this);
        }
        catch (PmsException e) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Predefined Scanner out-of-date or already created: " + this.getName());
            throw new ParameterNotAcceptedException();
        }
    }

    private void initState(PerformanceMonitoringState state) {
        if (state.value() == 0 && this.isSuspended) {
            this.activate();
        } else if (state.value() == 1 && !this.isSuspended) {
            this.suspend();
        }
    }

    private void preperAndPush(Collection collection) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "preperAndPush(), scanner name:" + this.name);
        Collection moTypeList = this.getMoTypeList(collection);
        ArrayList<MeasuredDataUpdatable> mesDataList = new ArrayList<MeasuredDataUpdatable>();
        Iterator iter = moTypeList.iterator();
        while (iter.hasNext()) {
            String moTypeName = (String)iter.next();
            Object[] scannedDataByMoTypeList = this.getScannedDataByMoType(moTypeName, collection);
            String[] cntNames = this.getObservedObjectNameList(scannedDataByMoTypeList);
            MeasuredDataUpdatable mesData = new MeasuredDataUpdatable(cntNames);
            this.addDataToMeasuredDataUpdatable(mesData, scannedDataByMoTypeList, cntNames);
            mesDataList.add(mesData);
        }
        this.destination.push(mesDataList.toArray(new MeasuredData[mesDataList.size()]), this.getSeqNo());
    }

    private void addDataToMeasuredDataUpdatable(MeasuredDataUpdatable measData, Object[] scannedDataList, String[] objectNameList) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "addDataToMeasuredDataUpdatable()");
        this.traceMeasuredObjectsName(objectNameList);
        boolean isDataInvalidSuspectFlag = false;
        Collection moTypeList = this.getMoLdnList(scannedDataList);
        HashMap<String, ScannedData> valueTable = new HashMap<String, ScannedData>(1);
        Iterator ldnIter = moTypeList.iterator();
        while (ldnIter.hasNext()) {
            String moLDN = (String)ldnIter.next();
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "The measured objects for Mo: " + moLDN);
            for (int i = 0; i < scannedDataList.length; ++i) {
                ScannedData data = (ScannedData)scannedDataList[i];
                if (!data.getMoLdn().equals(moLDN)) continue;
                valueTable.put(data.getCounterName(), data);
            }
            List pushValue = this.getSortedValueList(objectNameList, valueTable);
            int numberOfUndefinedCounters = 0;
            Iterator iter = pushValue.iterator();
            while (iter.hasNext()) {
                int[] element = (int[])iter.next();
                if (!this.isDataInvalid(element)) continue;
                ++numberOfUndefinedCounters;
            }
            if (pushValue.size() == numberOfUndefinedCounters) {
                isDataInvalidSuspectFlag = true;
            }
            measData.addMeasuredValues(moLDN, pushValue.toArray(), isDataInvalidSuspectFlag);
            isDataInvalidSuspectFlag = false;
            valueTable.clear();
        }
    }

    private boolean isDataInvalid(int[] values) {
        int numOfInvalids = 0;
        for (int i = 0; i < values.length; ++i) {
            if (values[i] != -1) continue;
            values[i] = -2;
            ++numOfInvalids;
        }
        return numOfInvalids == values.length && values.length != 0;
    }

    private void traceMeasuredObjectsName(String[] counterNames) {
        StringBuffer msg = new StringBuffer("Counter names:\n");
        for (int i = 0; i < counterNames.length; ++i) {
            msg.append(i).append("-  ").append(counterNames[i]).append("\n ");
        }
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), msg.toString());
    }

    private String getScannedValueAsStr(ScannedData data) {
        if (data == null) {
            return "";
        }
        StringBuffer msg = new StringBuffer();
        for (int i = 0; i < data.getCounterValues().length; ++i) {
            msg.append(data.getCounterValues()[i]).append(", ");
        }
        return msg.toString();
    }

    private void release() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "release(),scanner name:" + this.name);
        LinkedList oList = new LinkedList(this.counterScannerAgentSet);
        ListIterator iter = oList.listIterator();
        while (iter.hasNext()) {
            CounterScannerAgent agent = (CounterScannerAgent)iter.next();
            agent.release(this);
        }
    }

    public void removeCounterClass(CounterScannerAgent csAgent) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "removeCounterClass(),scanner name:" + this.name);
        if (!this.counterScannerAgentSet.remove(csAgent)) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Counter couldn't found: " + csAgent.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCounterObject(CounterScanner scanner) {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "removeCounterObject(),RBScanner name:" + this.name + " CounterScanner :" + scanner.toString());
        Object object = this.counterScannerSetLock;
        synchronized (object) {
            if (!this.counterScannerSet.remove(scanner)) {
                MessageLog.traceError(((Object)((Object)this)).getClass(), "Counter scanner couldn't found: " + scanner.toString());
            }
        }
    }

    private void reserve(ObservationClass obsClass) throws GranularityAndAttributeActivationException, ParameterNotAcceptedException {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "reserve(), scanner name:" + this.name);
        MoScannerAgentMgr msaMgr = MoScannerAgentMgr.instance();
        MoScannerAgent msAgent = msaMgr.lookup(obsClass.object_class_name);
        if (msAgent == null) {
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Mo type not found: " + obsClass.object_class_name);
            this.release();
            throw new ParameterNotAcceptedException();
        }
        for (int i = 0; i < obsClass.class_attribute_list.length; ++i) {
            CounterScannerAgent cAgent = msAgent.lookup(obsClass.class_attribute_list[i]);
            if (cAgent == null) continue;
            try {
                cAgent.reserve(this);
                continue;
            }
            catch (GroupInOtherScannerException ge) {
                MessageLog.trace(3, ((Object)((Object)this)).getClass(), "reservation failed");
                this.releaseReserved(obsClass, i);
                throw new GranularityAndAttributeActivationException(this.ocList);
            }
            catch (CounterInOtherScannerException ce) {
                MessageLog.trace(3, ((Object)((Object)this)).getClass(), "reservation failed");
                this.releaseReserved(obsClass, i);
                throw new GranularityAndAttributeActivationException(this.ocList);
            }
        }
    }

    private void releaseReserved(ObservationClass obsClass, int noOfCounters) {
        MoScannerAgentMgr msaMgr = MoScannerAgentMgr.instance();
        MoScannerAgent msAgent = msaMgr.lookup(obsClass.object_class_name);
        for (int i = 0; i < noOfCounters; ++i) {
            CounterScannerAgent cAgent = msAgent.lookup(obsClass.class_attribute_list[i]);
            if (cAgent == null) continue;
            cAgent.release(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        String orgName = "";
        try {
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "SCAN_");
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "scan(),scanner name:" + this.name);
            DelayManager.delayIfNeeded(this.granularityPeriod.inSeconds());
            LoadDistributer.reserveLoadSession();
            ArrayList<Object> scannedData = new ArrayList<Object>(1);
            HashSet cntScannerListClone = null;
            Object object = this.counterScannerSetLock;
            synchronized (object) {
                cntScannerListClone = (HashSet)this.counterScannerSet.clone();
            }
            Iterator iter = cntScannerListClone.iterator();
            long startedScanAt = this.getTimeInSeconds();
            boolean scanOk = true;
            while (iter.hasNext()) {
                if (this.getTimeInSeconds() - startedScanAt > 300L) {
                    scanOk = false;
                    MessageLog.info(((Object)((Object)this)).getClass(), "Scan aborted after 5 minutes!! ");
                    break;
                }
                CounterScanner cntScanner = (CounterScanner)iter.next();
                try {
                    ScannedData sd = cntScanner.scan(this.granularityPeriod.inSeconds());
                    scannedData.add(sd.clone());
                }
                catch (Exception e) {
                    MessageLog.trace(3, ((Object)((Object)this)).getClass(), "Scan failed!! Counter: " + cntScanner + " due to " + e);
                }
            }
            if (scanOk) {
                this.preperAndPush(scannedData);
            }
        }
        catch (Exception e) {
            MessageLog.info(((Object)((Object)this)).getClass(), "Unexpected exception!! " + e);
        }
        finally {
            LoadDistributer.releaseLoadSession();
            this.changeThreadName2Org(orgName);
        }
    }

    public void setScannerState(PerformanceMonitoringState state, Coordinator context) throws OverloadException, GranularityAndAttributeActivationException {
        super.setScannerState(state, context);
        this.underFlyState = state;
        try {
            this.handleTX(context, ScannerOperation.SET_STATE_OPERATION);
        }
        catch (ParameterNotAcceptedException pe) {
            MessageLog.traceError(((Object)((Object)this)).getClass(), "Failed to setScannerState(),scanner name:" + this.name + ", due to exception: ", pe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commitSetState() {
        String orgName = "";
        try {
            orgName = Thread.currentThread().getName();
            this.changeThreadName(orgName, "COMMIT_SET_SCANNER_STATE_");
            MessageLog.trace(3, ((Object)((Object)this)).getClass(), "commitSetState(),scanner name:" + this.name);
            if (this.underFlyState.value() == 0 && this.isSuspended) {
                this.activate();
            } else if (this.underFlyState.value() == 1 && !this.isSuspended) {
                this.suspend();
            }
        }
        finally {
            this.changeThreadName2Org(orgName);
        }
    }

    private void suspend() {
        MessageLog.trace(3, ((Object)((Object)this)).getClass(), "suspend(), scanner name: " + this.name);
        this.isSuspended = true;
        Iterator iter = this.counterScannerAgentSet.iterator();
        while (iter.hasNext()) {
            CounterScannerAgent cntAgent = (CounterScannerAgent)iter.next();
            cntAgent.suspend();
        }
        PredefinedScannerMgr.instance().actviateSuspend(this, 1);
    }

    public boolean isSuspended() {
        return this.isSuspended;
    }

    public ObservationClass[] getObservationClassList() {
        return this.ocList;
    }

    private long getTimeInSeconds() {
        return System.currentTimeMillis() / 1000L;
    }

    static final class ScannerOperation {
        static final ScannerOperation CREATE_OPERATION = new ScannerOperation();
        static final ScannerOperation DELETE_OPERATION = new ScannerOperation();
        static final ScannerOperation SET_STATE_OPERATION = new ScannerOperation();

        private ScannerOperation() {
        }
    }

    private static class PmsResource
    implements Resource {
        private ScannerOperation currentOperation;
        private RBScanner delegate;

        public PmsResource(RBScanner mo, ScannerOperation currentOperation) {
            this.delegate = mo;
            this.currentOperation = currentOperation;
        }

        public void commit() {
            try {
                if (this.currentOperation == ScannerOperation.DELETE_OPERATION) {
                    this.delegate.commitDelete();
                } else if (this.currentOperation == ScannerOperation.SET_STATE_OPERATION) {
                    this.delegate.commitSetState();
                } else if (this.currentOperation == ScannerOperation.CREATE_OPERATION) {
                    this.delegate.commitCreate();
                }
            }
            catch (Exception e) {
                MessageLog.traceError(this.getClass(), "Commit failed due to exception!!", e);
            }
        }

        public boolean prepare() {
            return true;
        }

        public void rollback() {
            try {
                if (this.currentOperation == ScannerOperation.CREATE_OPERATION) {
                    this.delegate.rollbackCreate();
                }
            }
            catch (Exception e) {
                MessageLog.traceError(this.getClass(), "rollback failed due to exception!!", e);
            }
        }
    }
}

