/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.ISSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.PTrustManager;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.listener.SSLListenerUtil;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INITIALIZE;
import org.omg.CORBA.TIMEOUT;

public abstract class AbstractSSLSocketFactory
extends AbstractSocketFactory
implements ConfigurableSSLSocketFactory,
ISSLSocketFactory,
Configurable {
    protected KeyMaterialProvider keyMaterialProvider;
    private SocketFactory factory;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean cipherSuitesRethrow;
    private boolean protocolsRethrow;
    private boolean supportClientAuth;
    private boolean requireTrustInServer;
    protected final ORB orb;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    protected String keystore_provider = null;
    protected String keystore_provider_impl = null;
    protected String truststore_provider = null;
    protected String truststore_provider_impl = null;
    private String jsseProvider = null;
    private String jsseProviderImpl = null;

    public AbstractSSLSocketFactory(ORB oRB) {
        this.orb = oRB;
    }

    protected String getLoggerName() {
        return "prismtech.sec.jsse";
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        short s2;
        super.configure(configuration);
        org.jacorb.config.Configuration configuration2 = (org.jacorb.config.Configuration)configuration;
        this.cipherSuitesRethrow = configuration2.getAttributeAsBoolean("jacorb.security.ssl.client.cipher_suites_rethrow", true);
        this.protocolsRethrow = configuration2.getAttributeAsBoolean("jacorb.security.ssl.client.protocols_rethrow", true);
        List list = configuration2.getAttributeList("jacorb.security.ssl.client.cipher_suites");
        this.cipherSuites = list.toArray(new String[list.size()]);
        if (this.logger.isDebugEnabled() && !list.isEmpty()) {
            this.logger.debug("Using Cipher Suites: " + list);
            this.logger.debug("Any IllegalArgumentException will be " + (this.cipherSuitesRethrow ? "logged and rethrown" : "logged and not rethown"));
        }
        List list2 = configuration2.getAttributeList("jacorb.security.ssl.client.protocols");
        this.protocols = list2.toArray(new String[list2.size()]);
        if (this.logger.isDebugEnabled() && !list2.isEmpty()) {
            this.logger.debug("Using Protocols: " + list2);
            this.logger.debug("Any IllegalArgumentException will be " + (this.protocolsRethrow ? "logged and rethrown" : "logged and not rethown"));
        }
        this.requireTrustInServer = ((s2 = Short.parseShort(configuration2.getAttribute("jacorb.security.ssl.client.required_options", "20"), 16)) & 0x20) != 0;
        short s3 = Short.parseShort(configuration2.getAttribute("jacorb.security.ssl.client.supported_options", "20"), 16);
        this.supportClientAuth = (s3 & 0x40) != 0;
        this.logger.debug("require trust in server: " + this.requireTrustInServer);
        this.logger.debug("support client auth: " + this.supportClientAuth);
        this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.key_manager_algorithm", "SunX509");
        this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.trust_manager_algorithm", "SunX509");
        this.keystore_provider = configuration2.getAttribute("jacorb.security.keystore_provider", null);
        this.keystore_provider_impl = configuration2.getAttribute("jacorb.security.keystore_provider_impl", null);
        this.truststore_provider = configuration2.getAttribute("jacorb.security.truststore_provider", null);
        this.truststore_provider_impl = configuration2.getAttribute("jacorb.security.truststore_provider_impl", null);
        this.jsseProvider = configuration2.getAttribute("jacorb.security.jsse.provider", null);
        this.jsseProviderImpl = configuration2.getAttribute("jacorb.security.jsse.provider_impl", null);
        try {
            this.setKeyMaterialProvider((KeyMaterialProvider)((Object)this.orb.resolve_initial_references("SSLClientCurrent")));
        }
        catch (Exception exception) {
            throw new ConfigurationException("Failed to resolve \"SSLClientCurrent\"", exception);
        }
    }

    public final void setKeyMaterialProvider(KeyMaterialProvider keyMaterialProvider) {
        this.keyMaterialProvider = keyMaterialProvider;
        this.keyMaterialProvider.connectTo(this);
    }

    private synchronized SocketFactory getSocketFactory() {
        if (this.factory == null) {
            this.initialize();
        }
        return this.factory;
    }

    private void initialize() {
        try {
            Object object;
            KeyManager[] keyManagerArray = null;
            KeyStore keyStore = this.keyMaterialProvider.getKeyStore();
            char[] cArray = this.keyMaterialProvider.getKeyPassPhrase();
            X509Certificate[] x509CertificateArray = this.keyMaterialProvider.getTrustees();
            TrustManager[] trustManagerArray = this.keyMaterialProvider.getTrustManagers();
            if (this.supportClientAuth) {
                if (keyStore == null) {
                    throw new BAD_PARAM("EstablishTrustInClient is supported, but no keystore has been set");
                }
                object = null;
                if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                    KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                    object = KeyManagerFactory.getInstance(this.keyManagerAlgorithm, this.jsseProvider);
                } else {
                    object = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
                }
                ((KeyManagerFactory)object).init(keyStore, cArray);
                keyManagerArray = ((KeyManagerFactory)object).getKeyManagers();
            }
            if (trustManagerArray == null) {
                if (x509CertificateArray != null) {
                    trustManagerArray = new X509TrustManager[]{new PTrustManager(this.requireTrustInServer, x509CertificateArray, this.orb.getConfiguration())};
                } else if (keyStore != null) {
                    object = null;
                    if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                        KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                        object = TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.jsseProvider);
                    } else {
                        object = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
                    }
                    ((TrustManagerFactory)object).init(keyStore);
                    trustManagerArray = ((TrustManagerFactory)object).getTrustManagers();
                }
            }
            object = null;
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                object = SSLContext.getInstance("TLS", this.jsseProvider);
            } else {
                object = SSLContext.getInstance("TLS");
            }
            ((SSLContext)object).init(keyManagerArray, trustManagerArray, this.keyMaterialProvider.getSecureRandom());
            this.factory = ((SSLContext)object).getSocketFactory();
            this.keyMaterialProvider.setInitialConfigurationDone();
        }
        catch (Exception exception) {
            this.logger.error("Failed to create SSLSocketFactory from KeyStore", exception);
            throw new INITIALIZE("Failed to create SSLSocketFactory from KeyStore: " + exception);
        }
    }

    public final synchronized void reconfigure() {
        this.factory = null;
    }

    public final Socket createSocket(String string, int n2, int n3, int n4) throws UnknownHostException, IOException {
        SSLSocket sSLSocket;
        block9: {
            block8: {
                sSLSocket = (SSLSocket)this.getSocketFactory().createSocket();
                sSLSocket.bind(new InetSocketAddress((InetAddress)null, n3));
                try {
                    sSLSocket.connect(new InetSocketAddress(string, n2), n4);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    throw new TIMEOUT();
                }
                if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                    try {
                        sSLSocket.setEnabledCipherSuites(this.cipherSuites);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.logger.error("Failed to set enabled cipher suites on client socket: " + this.displayArray(this.cipherSuites), illegalArgumentException);
                        if (!this.cipherSuitesRethrow) break block8;
                        this.logger.error("Rethrowing IllegalArgumentException");
                        throw illegalArgumentException;
                    }
                }
            }
            if (this.protocols != null && this.protocols.length > 0) {
                try {
                    sSLSocket.setEnabledProtocols(this.protocols);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    this.logger.error("Failed to set enabled protocols on client socket: " + this.displayArray(this.protocols), illegalArgumentException);
                    if (!this.protocolsRethrow) break block9;
                    this.logger.error("Rethrowing IllegalArgumentException");
                    throw illegalArgumentException;
                }
            }
        }
        SSLListenerUtil.addListener(this.orb, sSLSocket);
        return sSLSocket;
    }

    private String displayArray(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            stringBuffer.append(stringArray[i2]);
            if (i2 >= stringArray.length - 1) continue;
            stringBuffer.append(",");
        }
        return stringBuffer.toString();
    }

    public final boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }
}

