/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.ISSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.SSLSocketFactory;
import java.io.IOException;
import java.net.BindException;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.factory.SocketFactory;

public class PortRangeSSLSocketFactory
extends AbstractSocketFactory
implements SocketFactory,
ConfigurableSSLSocketFactory,
Configurable {
    private final ISSLSocketFactory delegate;
    public static final String MIN_PROP = "jacorb.ssl.socket_factory.port_min";
    public static final String MAX_PROP = "jacorb.ssl.socket_factory.port_max";
    private int portMin;
    private int portMax;

    public PortRangeSSLSocketFactory(ORB orb) {
        this(new SSLSocketFactory(orb));
    }

    public PortRangeSSLSocketFactory(ISSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.portMin = configuration.getAttributeAsInteger(MIN_PROP);
        this.portMax = configuration.getAttributeAsInteger(MAX_PROP);
        if (this.portMin > this.portMax) {
            throw new ConfigurationException("PortRangeFactory: minimum port number not less than or equal to maximum");
        }
        if (this.delegate instanceof Configurable) {
            ((Configurable)((Object)this.delegate)).configure(configuration);
        }
    }

    public Socket createSocket(String host, int port) throws IOException {
        return this.createSocketInConfiguredRange(host, port, 0);
    }

    protected Socket doCreateSocket(String host, int port, int timeout) throws IOException, UnknownHostException {
        return this.createSocketInConfiguredRange(host, port, 0);
    }

    public boolean isSSL(Socket socket) {
        return this.delegate.isSSL(socket);
    }

    private Socket createSocketInConfiguredRange(String host, int port, int timeout) throws IOException {
        for (int localPort = this.portMin; localPort <= this.portMax; ++localPort) {
            try {
                Socket socket = this.createSocketOnLocalPort(host, port, localPort);
                if (this.logger.isInfoEnabled()) {
                    this.logger.info("PortRangeSSLSocketFactory: Created socket between localhost:" + localPort + " and " + host + ":" + port);
                }
                return socket;
            }
            catch (IOException e2) {
                this.logger.debug("couldn't open socket.", e2);
                continue;
            }
        }
        this.logger.error("Cannot bind socket between ports " + this.portMin + " and " + this.portMax + " to target " + host + ":" + port);
        throw new BindException("PortRangeSocketFactory: no free port between " + this.portMin + " and " + this.portMax);
    }

    private Socket createSocketOnLocalPort(String host, int port, int localPort) throws IOException {
        return this.delegate.createSocket(host, port, localPort, 0);
    }

    public void setKeyMaterialProvider(KeyMaterialProvider provider) {
        if (this.delegate instanceof ConfigurableSSLSocketFactory) {
            ((ConfigurableSSLSocketFactory)((Object)this.delegate)).setKeyMaterialProvider(provider);
        }
    }

    public void reconfigure() {
        if (this.delegate instanceof ConfigurableSSLSocketFactory) {
            ((ConfigurableSSLSocketFactory)((Object)this.delegate)).reconfigure();
        }
    }
}

