/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.corba.jacorb;

import com.prismtech.corba.jacorb.ConfigurableSSLSocketFactory;
import com.prismtech.corba.jacorb.KeyMaterialProvider;
import com.prismtech.corba.jacorb.PTrustManager;
import com.prismtech.corba.security.SSLServerCurrentImpl;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.ServerSocketFactory;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.INITIALIZE;

public class SSLServerSocketFactory
implements ServerSocketFactory,
ConfigurableSSLSocketFactory,
Configurable {
    private javax.net.ServerSocketFactory factory;
    private boolean requireMutualAuth;
    private boolean supportClientAuth;
    private String[] cipherSuites;
    private String[] protocols;
    private boolean cipherSuitesRethrow;
    private boolean protocolsRethrow;
    private Logger logger;
    private ORB orb;
    private boolean initialized;
    private KeyMaterialProvider keyMaterialProvider;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    protected String keystore_provider = null;
    protected String keystore_provider_impl = null;
    private String jsseProvider = null;
    private String jsseProviderImpl = null;

    public SSLServerSocketFactory(ORB orb) {
        this.orb = orb;
    }

    public void configure(Configuration config) throws ConfigurationException {
        short requiredSSLOptions;
        org.jacorb.config.Configuration cfg = (org.jacorb.config.Configuration)config;
        this.logger = cfg.getNamedLogger("prismtech.sec.jsse");
        this.keyManagerAlgorithm = config.getAttribute("jacorb.security.jsse.server.key_manager_algorithm", "SunX509");
        this.trustManagerAlgorithm = config.getAttribute("jacorb.security.jsse.server.trust_manager_algorithm", "SunX509");
        this.keystore_provider = config.getAttribute("jacorb.security.keystore_provider", null);
        this.keystore_provider_impl = config.getAttribute("jacorb.security.keystore_provider_impl", null);
        this.jsseProvider = config.getAttribute("jacorb.security.jsse.provider", null);
        this.jsseProviderImpl = config.getAttribute("jacorb.security.jsse.provider_impl", null);
        short supportedSSLOptions = Short.parseShort(config.getAttribute("jacorb.security.ssl.server.supported_options"), 16);
        if ((supportedSSLOptions & 0x40) != 0) {
            this.logger.info("Will create SSL sockets that request client authentication");
            this.supportClientAuth = true;
        }
        if (((requiredSSLOptions = Short.parseShort(config.getAttribute("jacorb.security.ssl.server.required_options"), 16)) & 0x40) != 0) {
            this.requireMutualAuth = true;
            this.supportClientAuth = false;
            this.logger.info("Will create SSL sockets that require client authentication");
        }
        this.cipherSuitesRethrow = cfg.getAttributeAsBoolean("jacorb.security.ssl.server.cipher_suites_rethrow", true);
        this.protocolsRethrow = cfg.getAttributeAsBoolean("jacorb.security.ssl.server.protocols_rethrow", true);
        List cipher_suite_list = cfg.getAttributeList("jacorb.security.ssl.server.cipher_suites");
        this.cipherSuites = cipher_suite_list.toArray(new String[cipher_suite_list.size()]);
        if (this.logger.isDebugEnabled() && !cipher_suite_list.isEmpty()) {
            this.logger.debug("Using Cipher Suites: " + cipher_suite_list);
            this.logger.debug("Any IllegalArgumentException will be " + (this.cipherSuitesRethrow ? "logged and rethrown" : "logged and not rethown"));
        }
        List protocols_list = cfg.getAttributeList("jacorb.security.ssl.server.protocols");
        this.protocols = protocols_list.toArray(new String[protocols_list.size()]);
        if (this.logger.isDebugEnabled() && !protocols_list.isEmpty()) {
            this.logger.debug("Using Protocols: " + protocols_list);
            this.logger.debug("Any IllegalArgumentException will be " + (this.protocolsRethrow ? "logged and rethrown" : "logged and not rethown"));
        }
        try {
            this.setKeyMaterialProvider((SSLServerCurrentImpl)this.orb.resolve_initial_references("SSLServerCurrent"));
        }
        catch (Exception e2) {
            this.logger.fatalError("Failed to resolve \"SSLServerCurrent\"", e2);
            throw new RuntimeException("Failed to resolve \"SSLServerCurrent\" " + e2);
        }
    }

    public void setKeyMaterialProvider(KeyMaterialProvider keyMaterialProvider) {
        this.keyMaterialProvider = keyMaterialProvider;
        this.keyMaterialProvider.connectTo(this);
    }

    public ServerSocket createServerSocket(int port) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.getSocketFactory().createServerSocket(port);
        this.initSocket(s2);
        return s2;
    }

    private void initSocket(SSLServerSocket s2) {
        block10: {
            block9: {
                if (this.supportClientAuth) {
                    s2.setNeedClientAuth(this.supportClientAuth);
                } else if (this.requireMutualAuth) {
                    s2.setNeedClientAuth(this.requireMutualAuth);
                }
                if (this.cipherSuites != null && this.cipherSuites.length > 0) {
                    try {
                        s2.setEnabledCipherSuites(this.cipherSuites);
                    }
                    catch (IllegalArgumentException iae) {
                        this.logger.error("Failed to set enabled cipher suites on server socket: " + this.displayArray(this.cipherSuites), iae);
                        if (!this.cipherSuitesRethrow) break block9;
                        this.logger.error("Rethrowing IllegalArgumentException");
                        throw iae;
                    }
                }
            }
            if (this.protocols != null && this.protocols.length > 0) {
                try {
                    s2.setEnabledProtocols(this.protocols);
                }
                catch (IllegalArgumentException iae) {
                    this.logger.error("Failed to set enabled protocols on server socket: " + this.displayArray(this.protocols), iae);
                    if (!this.protocolsRethrow) break block10;
                    this.logger.error("Rethrowing IllegalArgumentException");
                    throw iae;
                }
            }
        }
    }

    private String displayArray(String[] items) {
        StringBuffer sb = new StringBuffer();
        for (int i2 = 0; i2 < items.length; ++i2) {
            sb.append(items[i2]);
            if (i2 >= items.length - 1) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public ServerSocket createServerSocket(int port, int backlog) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.getSocketFactory().createServerSocket(port, backlog);
        this.initSocket(s2);
        return s2;
    }

    public ServerSocket createServerSocket(int port, int backlog, InetAddress ifAddress) throws IOException {
        SSLServerSocket s2 = (SSLServerSocket)this.getSocketFactory().createServerSocket(port, backlog, ifAddress);
        this.initSocket(s2);
        return s2;
    }

    public boolean isSSL(ServerSocket s2) {
        return s2 instanceof SSLServerSocket;
    }

    public void switchToClientMode(Socket socket) {
    }

    private synchronized javax.net.ServerSocketFactory getSocketFactory() {
        if (this.factory == null) {
            this.initialize();
        }
        return this.factory;
    }

    private void initialize() {
        try {
            KeyStore ks = this.keyMaterialProvider.getKeyStore();
            char[] keyPass = this.keyMaterialProvider.getKeyPassPhrase();
            X509Certificate[] trustees = this.keyMaterialProvider.getTrustees();
            TrustManager[] trustManagers = this.keyMaterialProvider.getTrustManagers();
            if (ks == null) {
                throw new BAD_INV_ORDER("The SSLServerSocketFactory hasn't been initialized with a KeyStore");
            }
            KeyManagerFactory kmf = null;
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm, this.jsseProvider);
            } else {
                kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
            }
            kmf.init(ks, keyPass);
            if (trustManagers == null && (this.requireMutualAuth || this.supportClientAuth)) {
                if (trustees != null) {
                    trustManagers = new X509TrustManager[]{new PTrustManager(this.requireMutualAuth, trustees, this.orb.getConfiguration())};
                } else {
                    TrustManagerFactory tmf = null;
                    if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                        KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                        tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.jsseProvider);
                    } else {
                        tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
                    }
                    tmf.init(ks);
                    trustManagers = tmf.getTrustManagers();
                }
            }
            SSLContext ctx = null;
            if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                ctx = SSLContext.getInstance("TLS", this.jsseProvider);
            } else {
                ctx = SSLContext.getInstance("TLS");
            }
            ctx.init(kmf.getKeyManagers(), trustManagers, this.keyMaterialProvider.getSecureRandom());
            this.factory = ctx.getServerSocketFactory();
            if (this.initialized && this.orb.getBasicAdapter() != null) {
                this.orb.getBasicAdapter().renewSSLServerSockets();
            }
            this.initialized = true;
            this.keyMaterialProvider.setInitialConfigurationDone();
        }
        catch (Exception e2) {
            this.logger.error("Failed to create SSLServerSocketFactory from KeyStore", e2);
            throw new INITIALIZE("Failed to create SSLServerSocketFactory from KeyStore: " + e2);
        }
    }

    public synchronized void reconfigure() {
        this.factory = null;
        this.initialize();
    }
}

