/*
 * Decompiled with CFR 0.152.
 */
package com.prismtech.cos.CosNamingME;

import com.prismtech.cos.CosNamingME.BindingIteratorImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.naming.INSUtil;
import org.jacorb.orb.naming.Iiop;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CosNaming.Binding;
import org.omg.CosNaming.BindingIteratorHelper;
import org.omg.CosNaming.BindingIteratorHolder;
import org.omg.CosNaming.BindingListHolder;
import org.omg.CosNaming.BindingType;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContext;
import org.omg.CosNaming.NamingContextExt;
import org.omg.CosNaming.NamingContextExtHelper;
import org.omg.CosNaming.NamingContextExtPOA;
import org.omg.CosNaming.NamingContextExtPackage.InvalidAddress;
import org.omg.CosNaming.NamingContextHelper;
import org.omg.CosNaming.NamingContextPackage.AlreadyBound;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotEmpty;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.ObjectAlreadyActive;
import org.omg.PortableServer.POAPackage.ObjectNotActive;
import org.omg.PortableServer.POAPackage.ServantAlreadyActive;
import org.omg.PortableServer.POAPackage.WrongPolicy;

public class NamingContextImpl
extends NamingContextExtPOA {
    private final HashMap bindings = new HashMap();
    private final Logger logger;
    private ORB orb;
    private POA poa;
    private int child_count;
    private boolean destroyed;
    private String oid;

    NamingContextImpl(String key, ORB o2, POA p2) {
        this.orb = o2;
        this.poa = p2;
        this.oid = key;
        this.logger = ((org.jacorb.orb.ORB)o2).getConfiguration().getNamedLogger("jacorb.naming");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair != null) {
                    throw new AlreadyBound();
                }
                this.bindings.put(name, new BindingPair(obj, BindingType.nobject));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Bound " + name + " with obj " + this.orb.object_to_string(obj));
                }
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                child.bind(ncc, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind(NameComponent[] nc, Object obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair != null && pair.type == BindingType.ncontext) {
                    throw new NotFound(NotFoundReason.not_object, nc);
                }
                if (pair == null) {
                    pair = new BindingPair(obj, BindingType.nobject);
                } else {
                    if (pair.object != null) {
                        pair.object._release();
                    }
                    pair.object = obj;
                }
                this.bindings.put(name, pair);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rebound " + name + " with obj " + this.orb.object_to_string(obj));
                }
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                child.rebind(ncc, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rebind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM("Can't rebind with null context");
        }
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair != null && pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair == null) {
                    pair = new BindingPair(obj, BindingType.ncontext);
                } else {
                    if (pair.object != null) {
                        pair.object._release();
                    }
                    pair.object = obj;
                }
                this.bindings.put(name, pair);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Rebound " + name + " with ctx " + this.orb.object_to_string(obj));
                }
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                child.rebind_context(ncc, obj);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bind_context(NameComponent[] nc, NamingContext obj) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        if (obj == null) {
            throw new BAD_PARAM("Cannot bind null context");
        }
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair != null) {
                    throw new AlreadyBound();
                }
                this.bindings.put(name, new BindingPair(obj, BindingType.ncontext));
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Bound context " + name);
                }
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                child.bind_context(ncc, obj);
            }
        }
    }

    public synchronized NamingContext bind_new_context(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName, AlreadyBound {
        NamingContext newCtx = this.new_context();
        this.bind_context(nc, newCtx);
        return newCtx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NamingContext new_context() {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        NamingContextExt ctx = null;
        try {
            int child;
            NamingContextImpl namingContextImpl = this;
            synchronized (namingContextImpl) {
                child = ++this.child_count;
            }
            StringBuffer oidStrB = new StringBuffer(this.oid);
            oidStrB.append("_ctx");
            oidStrB.append(child);
            String oidStr = oidStrB.toString();
            byte[] oid = oidStr.getBytes();
            this.poa.activate_object_with_id(oid, new NamingContextImpl(oidStr, this.orb, this.poa));
            ctx = NamingContextExtHelper.narrow(this.poa.id_to_reference(oid));
            if (this.logger.isInfoEnabled()) {
                this.logger.info("New context with oid " + oidStr);
            }
        }
        catch (ServantAlreadyActive e2) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Internal error - failed to create a new context", e2);
            }
            throw new INTERNAL("Internal error - failed to create a new context");
        }
        catch (ObjectAlreadyActive e3) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Internal error - failed to create a new context", e3);
            }
            throw new INTERNAL("Internal error - failed to create a new context");
        }
        catch (ObjectNotActive e4) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Internal error - failed to create a new context", e4);
            }
            throw new INTERNAL("Internal error - failed to create a new context");
        }
        catch (WrongPolicy e5) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Internal error - failed to create a new context", e5);
            }
            throw new INTERNAL("Internal error - failed to create a new context");
        }
        return NamingContextExtHelper.narrow(ctx);
    }

    public void destroy() throws NotEmpty {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (!this.bindings.isEmpty()) {
            throw new NotEmpty();
        }
        this.bindings.clear();
        this.destroyed = true;
        try {
            this.poa.deactivate_object(this.oid.getBytes());
        }
        catch (WrongPolicy ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Caught WrongPolicy when destroying ", ex);
            }
            throw new INTERNAL("Caught WrongPolicy when destroying");
        }
        catch (ObjectNotActive ex) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Caught ObjectNotActive when destroying ", ex);
            }
            throw new INTERNAL("Caught ObjectNotActive when destroying");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object resolve(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        Object result = null;
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                result = ((BindingPair)this.bindings.get((java.lang.Object)name)).object;
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                result = child.resolve(ncc);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unbind(NameComponent[] nc) throws NotFound, CannotProceed, InvalidName {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        if (nc == null || nc.length == 0) {
            throw new InvalidName();
        }
        String name = INSUtil.convertCOStoString(nc[0]);
        HashMap hashMap = this.bindings;
        synchronized (hashMap) {
            BindingPair pair = (BindingPair)this.bindings.get(name);
            if (nc.length == 1) {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                this.bindings.remove(name);
                if (pair.object != null) {
                    pair.object._release();
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Removed " + name);
                }
            } else {
                if (pair == null) {
                    throw new NotFound(NotFoundReason.missing_node, nc);
                }
                if (pair.type == BindingType.nobject) {
                    throw new NotFound(NotFoundReason.not_context, nc);
                }
                if (pair.type == BindingType.ncontext && pair.object == null) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("Internal error - found a context type null binding");
                    }
                    throw new INTERNAL("Internal error - found a context type null binding");
                }
                NamingContext child = NamingContextHelper.narrow(pair.object);
                NameComponent[] ncc = new NameComponent[nc.length - 1];
                System.arraycopy(nc, 1, ncc, 0, ncc.length);
                child.unbind(ncc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void list(int how_many, BindingListHolder bl, BindingIteratorHolder bi) {
        if (this.destroyed) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Context already destroyed");
            }
            throw new OBJECT_NOT_EXIST("Context already destroyed");
        }
        ArrayList<Binding> blResult = new ArrayList<Binding>();
        HashSet<Binding> biResult = null;
        try {
            HashMap hashMap = this.bindings;
            synchronized (hashMap) {
                Iterator it = this.bindings.entrySet().iterator();
                if (how_many > 0) {
                    for (int i2 = 0; i2 < how_many && it.hasNext(); ++i2) {
                        Map.Entry entry = it.next();
                        Binding b2 = new Binding(new NameComponent[]{INSUtil.convertStringToCOS((String)entry.getKey())}, ((BindingPair)entry.getValue()).type);
                        blResult.add(b2);
                    }
                }
                if (it.hasNext()) {
                    biResult = new HashSet<Binding>();
                    while (it.hasNext()) {
                        Map.Entry entry = it.next();
                        Binding b3 = new Binding(new NameComponent[]{INSUtil.convertStringToCOS((String)entry.getKey())}, ((BindingPair)entry.getValue()).type);
                        biResult.add(b3);
                    }
                }
            }
            bl.value = new Binding[blResult.size()];
            blResult.toArray(bl.value);
            if (biResult != null) {
                byte[] oid = ((org.jacorb.orb.ORB)this.orb).getRootPOA().activate_object(new BindingIteratorImpl(biResult));
                Object o2 = ((org.jacorb.orb.ORB)this.orb).getRootPOA().id_to_reference(oid);
                bi.value = BindingIteratorHelper.narrow(o2);
            }
        }
        catch (Exception e2) {
            this.logger.debug("Caught exception while creating list", e2);
            throw new INTERNAL("Caught " + e2);
        }
    }

    public String to_string(NameComponent[] n2) throws InvalidName {
        return INSUtil.componentToIns(n2);
    }

    public NameComponent[] to_name(String sn) throws InvalidName {
        return INSUtil.insToComponent(sn);
    }

    public String to_url(String address, String name) throws InvalidAddress, InvalidName {
        if (address == null || address.length() == 0) {
            this.logger.warn("Address component may not be empty");
            throw new InvalidAddress();
        }
        if (!Iiop.parseStringified(name)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parse failed on name: " + name);
            }
            throw new InvalidName();
        }
        StringBuffer str = new StringBuffer();
        str.append("corbaname:");
        str.append(address);
        if (name != null && name.length() != 0) {
            str.append("#");
            str.append(INSUtil.encode(name));
        }
        if (!Iiop.parseIiop(str.toString())) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Parse failed on string: " + str);
            }
            throw new InvalidAddress();
        }
        return str.toString();
    }

    public Object resolve_str(String n2) throws NotFound, CannotProceed, InvalidName {
        return this.resolve(this.to_name(n2));
    }

    static class BindingPair {
        Object object;
        BindingType type;

        BindingPair(Object o2, BindingType t2) {
            this.object = o2;
            this.type = t2;
        }
    }
}

