/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.orb.ORB;
import org.jacorb.orb.dsi.ServerRequest;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.MessageReceptorPool;
import org.jacorb.orb.giop.NoBiDirServerReplyListener;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.ServerGIOPConnection;
import org.jacorb.orb.giop.ServerRequestListener;
import org.jacorb.orb.giop.TransportManager;
import org.jacorb.orb.iiop.IIOPAddress;
import org.jacorb.orb.iiop.IIOPListener;
import org.jacorb.orb.iiop.IIOPProfile;
import org.jacorb.poa.except.ParentIsHolding;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UNKNOWN;
import org.omg.ETF.Connection;
import org.omg.ETF.Factories;
import org.omg.ETF.Listener;
import org.omg.ETF.Profile;
import org.omg.ETF._HandleLocalBase;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAPackage.WrongAdapter;

public class BasicAdapter
extends _HandleLocalBase
implements Configurable {
    private final List listeners = new ArrayList();
    private MessageReceptorPool receptor_pool = null;
    private final ServerRequestListener request_listener;
    private ReplyListener reply_listener = null;
    private final TransportManager transport_manager;
    private final GIOPConnectionManager giop_connection_manager;
    private org.jacorb.config.Configuration configuration = null;
    private Logger logger = null;
    private final ORB orb;

    BasicAdapter(ORB orb, org.jacorb.poa.POA poa, TransportManager transport_manager, GIOPConnectionManager giop_connection_manager) {
        this.orb = orb;
        this.transport_manager = transport_manager;
        this.giop_connection_manager = giop_connection_manager;
        this.request_listener = new ServerRequestListener(orb, poa);
    }

    public void configure(Configuration myConfiguration) throws ConfigurationException {
        this.configuration = (org.jacorb.config.Configuration)myConfiguration;
        this.logger = this.configuration.getNamedLogger("jacorb.orb.basic");
        this.receptor_pool = new MessageReceptorPool("server", "ServerMessageReceptor", myConfiguration);
        this.request_listener.configure(this.configuration);
        this.reply_listener = new NoBiDirServerReplyListener();
        Iterator i2 = this.getListenerFactories().iterator();
        while (i2.hasNext()) {
            Factories factories = (Factories)i2.next();
            Listener listener = factories.create_listener(null, 0, (short)0);
            listener.set_handle(this);
            this.listeners.add(listener);
        }
        i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            ((Listener)i2.next()).listen();
        }
    }

    private List getListenerFactories() {
        ArrayList<Factories> result = new ArrayList<Factories>();
        List tags = this.configuration.getAttributeList("jacorb.transport.server.listeners");
        if (tags.isEmpty()) {
            result.addAll(this.transport_manager.getFactoriesList());
        } else {
            if (tags.contains("off")) {
                tags.remove("off");
            }
            Iterator i2 = tags.iterator();
            while (i2.hasNext()) {
                String s2 = (String)i2.next();
                int tag = -1;
                try {
                    tag = Integer.parseInt(s2);
                }
                catch (NumberFormatException ex) {
                    throw new IllegalArgumentException("could not parse profile tag for listener: " + s2 + " (should have been a number)");
                }
                Factories factories = this.transport_manager.getFactories(tag);
                if (factories == null) {
                    throw new IllegalArgumentException("could not find Factories for profile tag: " + tag);
                }
                result.add(factories);
            }
        }
        return result;
    }

    public RequestListener getRequestListener() {
        return this.request_listener;
    }

    public List getEndpointProfiles() {
        ArrayList<Profile> result = new ArrayList<Profile>();
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            Listener listener = (Listener)i2.next();
            result.add(listener.endpoint());
        }
        return result;
    }

    private IIOPListener getIIOPListener() {
        if (this.listeners.size() == 1) {
            Listener listener = (Listener)this.listeners.get(0);
            if (listener instanceof IIOPListener) {
                return (IIOPListener)listener;
            }
            return null;
        }
        return null;
    }

    public int getPort() {
        IIOPListener l2 = this.getIIOPListener();
        if (l2 != null) {
            IIOPProfile profile = (IIOPProfile)l2.endpoint();
            return ((IIOPAddress)profile.getAddress()).getPort();
        }
        throw new RuntimeException("Cannot find server port for non-IIOP transport");
    }

    public int getSSLPort() {
        IIOPListener listener = this.getIIOPListener();
        if (listener != null) {
            return ((IIOPProfile)listener.endpoint()).getSSLPort();
        }
        throw new RuntimeException("Non-IIOP transport does not have an SSL port");
    }

    public boolean hasSSLListener() {
        return this.getSSLPort() != -1;
    }

    public String getAddress() {
        IIOPListener l2 = this.getIIOPListener();
        if (l2 != null) {
            IIOPProfile profile = (IIOPProfile)l2.endpoint();
            return ((IIOPAddress)profile.getAddress()).getHostname();
        }
        throw new RuntimeException("Cannot find server address for non-IIOP transport");
    }

    public void deliverRequest(ServerRequest request, POA poa) {
        org.jacorb.poa.POA tmp_poa = (org.jacorb.poa.POA)poa;
        String[] scopes = request.remainingPOAName();
        request.setRemainingPOAName(null);
        try {
            for (int i2 = 0; i2 < scopes.length && !scopes[i2].equals(""); ++i2) {
                try {
                    tmp_poa = tmp_poa._getChildPOA(scopes[i2]);
                    continue;
                }
                catch (ParentIsHolding p2) {
                    String[] rest_of_name = new String[scopes.length - i2];
                    for (int j2 = 0; j2 < rest_of_name.length; ++j2) {
                        rest_of_name[j2] = scopes[j2 + i2];
                    }
                    request.setRemainingPOAName(rest_of_name);
                    break;
                }
            }
            if (tmp_poa == null) {
                throw new INTERNAL("Request POA null!");
            }
            tmp_poa._invoke(request);
        }
        catch (WrongAdapter e2) {
            request.setSystemException(new OBJECT_NOT_EXIST("unknown oid"));
            request.reply();
        }
        catch (SystemException e3) {
            request.setSystemException(e3);
            request.reply();
        }
        catch (RuntimeException e4) {
            request.setSystemException(new UNKNOWN(e4.toString()));
            request.reply();
            this.logger.warn("unexpected exception", e4);
        }
        catch (Throwable e5) {
            request.setSystemException(new UNKNOWN(e5.toString()));
            request.reply();
            this.logger.error("unexpected exception", e5);
        }
    }

    public void return_result(ServerRequest request) {
        request.reply();
    }

    public void stopListeners() {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            ((Listener)i2.next()).destroy();
        }
        this.receptor_pool.shutdown();
    }

    public void renewSSLServerSockets() {
        Iterator i2 = this.listeners.iterator();
        while (i2.hasNext()) {
            Object o2 = i2.next();
            if (!(o2 instanceof IIOPListener)) continue;
            ((IIOPListener)o2).renewSSLServerSocket();
        }
    }

    public boolean add_input(Connection conn) {
        ServerGIOPConnection giopConnection = this.giop_connection_manager.createServerGIOPConnection(conn.get_server_profile(), conn, this.request_listener, this.reply_listener);
        this.receptor_pool.connectionCreated(giopConnection);
        return true;
    }

    public void closed_by_peer(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public void signal_data_available(Connection conn) {
        throw new NO_IMPLEMENT();
    }

    public ORB getORB() {
        return this.orb;
    }
}

