/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.ft;

import java.util.Date;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.config.Configuration;
import org.jacorb.orb.CDRInputStream;
import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ft.ClientIDFactory;
import org.jacorb.orb.portableInterceptor.ClientRequestInfoImpl;
import org.jacorb.orb.portableInterceptor.DefaultClientInterceptor;
import org.jacorb.util.Time;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TRANSIENT;
import org.omg.FT.FTGroupVersionServiceContext;
import org.omg.FT.FTGroupVersionServiceContextHelper;
import org.omg.FT.FTRequestServiceContext;
import org.omg.FT.FTRequestServiceContextHelper;
import org.omg.FT.RequestDurationPolicy;
import org.omg.FT.RequestDurationPolicyHelper;
import org.omg.FT.TagFTGroupTaggedComponent;
import org.omg.FT.TagFTGroupTaggedComponentHelper;
import org.omg.IOP.ServiceContext;
import org.omg.IOP.TaggedComponent;
import org.omg.PortableInterceptor.ClientRequestInfo;
import org.omg.PortableInterceptor.ForwardRequest;
import org.omg.TimeBase.UtcT;

public class FaultTolerantClientRequestInterceptor
extends DefaultClientInterceptor {
    public static final String PARAM_SEND_EXTENDED_GROUPTC = "ORBFTSendFullGroupTC";
    private final Logger logger;
    private final Object uid = ClientIDFactory.newClientID();
    private final boolean sendExtendedServiceContext;
    private final ORB orb;
    private int retentionId;

    public FaultTolerantClientRequestInterceptor(ORB orb, Logger logger, Configuration config) {
        this.orb = orb;
        this.logger = logger;
        this.sendExtendedServiceContext = config.getAttributeAsBoolean(PARAM_SEND_EXTENDED_GROUPTC, false);
        logger.info("option ORBFTSendFullGroupTC is set to " + this.sendExtendedServiceContext);
    }

    public String name() {
        return "JacORB_FaultTolerantClientRequestInterceptor";
    }

    public void send_request(ClientRequestInfo ri) throws ForwardRequest {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("send_request: " + ri.operation());
            this.logger.debug("date: " + new Date());
        }
        try {
            TaggedComponent tc = ri.get_effective_component(27);
            this.setGroupVersionContext(ri, tc);
            this.setRequestServiceContext(ri);
        }
        catch (BAD_PARAM bAD_PARAM) {
            // empty catch block
        }
    }

    public void receive_other(ClientRequestInfo ri) throws ForwardRequest {
        ClientRequestInfoImpl info = (ClientRequestInfoImpl)ri;
        if (!info.hasFtExpirationTime()) {
            return;
        }
        short replyStatus = ri.reply_status();
        switch (replyStatus) {
            case 3: 
            case 4: {
                if (!Time.hasPassed(new UtcT(info.getFtExpirationTime(), 0, 0, 0))) break;
                this.logger.info("receive_other: LOCATION_FORWARD received after request expiration.");
                throw new TRANSIENT();
            }
            default: {
                return;
            }
        }
    }

    private void setRequestServiceContext(ClientRequestInfo ri) {
        RequestDurationPolicy policy = RequestDurationPolicyHelper.narrow(ri.get_request_policy(47));
        ClientRequestInfoImpl jacorbClientRequestInfo = (ClientRequestInfoImpl)ri;
        FTRequestServiceContext ftContext = new FTRequestServiceContext();
        ftContext.client_id = this.uid.toString();
        if (jacorbClientRequestInfo.hasFtExpirationTime()) {
            ftContext.retention_id = jacorbClientRequestInfo.getFtRetentionId();
            ftContext.expiration_time = jacorbClientRequestInfo.getFtExpirationTime();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("creating new FT_REQUEST service context");
            }
            ftContext.retention_id = this.getNextRetentionId();
            ftContext.expiration_time = this.getRequestExpirationTime(policy);
            jacorbClientRequestInfo.setFtExpirationTime(ftContext.expiration_time);
            jacorbClientRequestInfo.setFtRetentionId(ftContext.retention_id);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("FT_REQUEST service context: ");
            this.logger.debug("client_id: " + ftContext.client_id);
            this.logger.debug("retention_id: " + ftContext.retention_id);
            this.logger.debug("expiration_time: " + ftContext.expiration_time);
            this.logger.debug("expiration_time as date: " + Time.javaDate(ftContext.expiration_time));
        }
        ServiceContext context = new ServiceContext();
        this.marshalFTRequestServiceContext(context, ftContext);
        ri.add_request_service_context(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void marshalFTRequestServiceContext(ServiceContext context, FTRequestServiceContext ftContext) {
        context.context_id = 13;
        CDROutputStream out = new CDROutputStream(this.orb);
        try {
            out.beginEncapsulatedArray();
            FTRequestServiceContextHelper.write(out, ftContext);
            context.context_data = out.getBufferCopy();
        }
        finally {
            out.close();
        }
    }

    private long getRequestExpirationTime(RequestDurationPolicy policy) {
        long request_duration_value = policy.request_duration_value();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("using request_duration_value " + request_duration_value + " corba time units (" + Time.timeTTomillis(request_duration_value) + " ms).");
        }
        UtcT corbaFuture = Time.corbaFuture(request_duration_value);
        return corbaFuture.time;
    }

    private void setGroupVersionContext(ClientRequestInfo ri, TaggedComponent tc) {
        ServiceContext context = new ServiceContext();
        context.context_id = 12;
        if (this.sendExtendedServiceContext) {
            context.context_data = tc.component_data;
        } else {
            TagFTGroupTaggedComponent groupTag = this.getFtGroupTaggedComponent(tc);
            this.initFtGroupVersionServiceContext(context, groupTag.object_group_ref_version);
        }
        ri.add_request_service_context(context, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TagFTGroupTaggedComponent getFtGroupTaggedComponent(TaggedComponent tc) {
        TagFTGroupTaggedComponent groupTag;
        CDRInputStream in = new CDRInputStream(tc.component_data);
        try {
            in.openEncapsulatedArray();
            groupTag = TagFTGroupTaggedComponentHelper.read(in);
        }
        finally {
            in.close();
        }
        return groupTag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFtGroupVersionServiceContext(ServiceContext context, int objectGroupRefVersion) {
        FTGroupVersionServiceContext ftContext = new FTGroupVersionServiceContext(objectGroupRefVersion);
        CDROutputStream out = new CDROutputStream(this.orb);
        try {
            out.beginEncapsulatedArray();
            FTGroupVersionServiceContextHelper.write(out, ftContext);
            context.context_data = out.getBufferCopy();
        }
        finally {
            out.close();
        }
    }

    private synchronized int getNextRetentionId() {
        return ++this.retentionId;
    }
}

