/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import java.util.List;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ClientGIOPConnection
extends GIOPConnection
implements Configurable {
    private boolean ignore_pending_messages_on_timeout = false;

    public ClientGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider) {
        super(profile, transport, request_listener, reply_listener, statistics_provider);
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.ignore_pending_messages_on_timeout = configuration.getAttributeAsBoolean("jacorb.connection.client.timeout_ignores_pending_messages", false);
        int max_request_write_time = configuration.getAttributeAsInteger("jacorb.connection.request.write_timeout", 0);
        this.init_write_monitor(max_request_write_time);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readTimedOut() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": readTimedOut()");
        }
        Object object = this.pendingUndecidedSync;
        synchronized (object) {
            if (this.ignore_pending_messages_on_timeout) {
                this.streamClosed();
            } else if (!this.hasPendingMessages()) {
                this.closeAllowReopen();
            } else if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": cannot close because there are pending messages");
            }
        }
    }

    protected void streamClosed() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": streamClosed()");
        }
        this.closeAllowReopen();
        if (this.connection_listener != null) {
            this.connection_listener.streamClosed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAllowReopen() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": closeAllowReopen()");
        }
        try {
            this.getWriteLock(0L);
            Object object = this.connect_sync;
            synchronized (object) {
                this.transport.close();
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public String toString() {
        return "ClientGIOPConnection to " + this.profile.toString() + " (" + Integer.toHexString(this.hashCode()) + ")";
    }

    public byte[] addContextKey(GIOPConnection gc, byte[] object_key, byte[] oid, List scopes) {
        return null;
    }

    public GIOPConnectionManager.ContextKey getContextKey(GIOPConnection gc, byte[] key) {
        return null;
    }
}

