/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.giop;

import edu.emory.mathcs.backport.java.util.concurrent.ConcurrentLinkedQueue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.giop.GIOPConnection;
import org.jacorb.orb.giop.GIOPConnectionManager;
import org.jacorb.orb.giop.ReplyListener;
import org.jacorb.orb.giop.RequestListener;
import org.jacorb.orb.giop.StatisticsProvider;
import org.jacorb.orb.iiop.IIOPConnection;
import org.jacorb.util.ObjectUtil;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.ETF.Connection;
import org.omg.ETF.Profile;

public class ServerGIOPConnection
extends GIOPConnection {
    private static final byte[] CLOSE_CONNECTION_MESSAGE;
    private final GIOPConnectionManager manager;
    private boolean closeOnReadTimeout = false;
    private boolean delayClose = false;
    private final Set indices = new HashSet();
    public ConcurrentLinkedQueue outstandingRequests;
    static final /* synthetic */ boolean $assertionsDisabled;

    public ServerGIOPConnection(Profile profile, Connection transport, RequestListener request_listener, ReplyListener reply_listener, StatisticsProvider statistics_provider, GIOPConnectionManager manager) {
        super(profile, transport, request_listener, reply_listener, statistics_provider);
        if (!$assertionsDisabled && manager == null) {
            throw new AssertionError();
        }
        this.manager = manager;
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        super.configure(configuration);
        this.delayClose = configuration.getAttributeAsBoolean("jacorb.connection.delay_close", false);
        if (configuration.getAttributeAsBoolean("jacorb.poa.checkRequestIDs", false)) {
            this.outstandingRequests = new ConcurrentLinkedQueue();
        }
        int max_reply_write_time = configuration.getAttributeAsInteger("jacorb.connection.reply.write_timeout", 0);
        this.init_write_monitor(max_reply_write_time);
    }

    boolean tryClose() {
        if (this.tryDiscard()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug(this.toString() + ": tryClose() -- will send CloseConnection");
            }
            this.sendCloseConnection();
            this.closeOnReadTimeout = true;
            if (this.connection_listener != null) {
                this.connection_listener.connectionClosed();
            }
            return true;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": tryClose() -- CloseConnection cannot be sent. Connection has " + this.getPendingMessagesCount() + " pending messages and/or " + this.getPendingWritesCount() + " pending writes.");
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean tryDiscard() {
        if (!this.hasPendingMessages()) {
            Object object = this.pendingUndecidedSync;
            synchronized (object) {
                this.discard_messages = true;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDiscardingMode(boolean discard) {
        Object object = this.pendingUndecidedSync;
        synchronized (object) {
            this.discard_messages = discard;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendCloseConnection() {
        try {
            this.getWriteLock(0L);
            this.write(CLOSE_CONNECTION_MESSAGE, 0, CLOSE_CONNECTION_MESSAGE.length);
            this.transport.flush();
            if (this.getStatisticsProviderAdapter() != null) {
                this.getStatisticsProviderAdapter().flushed();
            }
            if (this.delayClose && this.transport instanceof IIOPConnection) {
                ((IIOPConnection)this.transport).turnOnFinalTimeout();
            } else {
                this.do_close = true;
                this.transport.close();
            }
        }
        catch (COMM_FAILURE e2) {
            this.logger.error("COMM_FAILURE", e2);
        }
        finally {
            this.releaseWriteLock();
        }
        this.closeCleanup();
    }

    protected void readTimedOut() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": readTimedOut()");
        }
        if (this.closeOnReadTimeout) {
            this.close();
        } else {
            this.tryClose();
        }
    }

    protected void streamClosed() {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(this.toString() + ": streamClosed()");
        }
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        try {
            super.close();
        }
        finally {
            this.closeCleanup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeCleanup() {
        ServerGIOPConnection serverGIOPConnection = this;
        synchronized (serverGIOPConnection) {
            Object[] contents = this.indices.toArray();
            for (int i2 = 0; i2 < contents.length; ++i2) {
                this.manager.removeContextKey(this, (Integer)contents[i2]);
            }
            this.indices.clear();
        }
        this.manager.unregisterServerGIOPConnection(this);
    }

    public byte[] addContextKey(GIOPConnection gc, byte[] object_key, byte[] oid, List scopes) {
        byte[] result = this.manager.addContextKey(gc, object_key, oid, scopes);
        this.addToIndices(result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToIndices(byte[] result) {
        Integer index = ObjectUtil.newInteger(((result[3] & 0xFF) << 24) + ((result[4] & 0xFF) << 16) + ((result[5] & 0xFF) << 8) + ((result[6] & 0xFF) << 0));
        ServerGIOPConnection serverGIOPConnection = this;
        synchronized (serverGIOPConnection) {
            this.indices.add(index);
        }
    }

    public GIOPConnectionManager.ContextKey getContextKey(GIOPConnection gc, byte[] key) {
        return this.manager.getContextKey(gc, key);
    }

    public String toString() {
        if (this.profile != null) {
            return "ServerGIOPConnection to " + this.profile.toString() + " (" + Integer.toHexString(this.hashCode()) + ")";
        }
        return super.toString();
    }

    public void addOutstandingRequest(int requestId) {
        this.outstandingRequests.add(new Integer(requestId));
    }

    public int peekOutStandingRequest() {
        Object result = this.outstandingRequests.peek();
        return result == null ? -1 : (Integer)result;
    }

    public void popOutstandingRequest() {
        this.outstandingRequests.remove();
    }

    static {
        $assertionsDisabled = !ServerGIOPConnection.class.desiredAssertionStatus();
        CLOSE_CONNECTION_MESSAGE = new byte[]{71, 73, 79, 80, 1, 0, 0, 5, 0, 0, 0, 0};
    }
}

