/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.orb.miop;

import org.jacorb.orb.CDROutputStream;
import org.jacorb.orb.ORB;
import org.jacorb.orb.giop.ClientConnection;
import org.jacorb.orb.miop.MIOPProfile;
import org.omg.MIOP.UIPMC_ProfileBody;
import org.omg.MIOP.UIPMC_ProfileBodyHelper;

public final class MulticastUtil {
    static final int SO_TIMEOUT = 100;
    static final int TIME_TO_LIVE = 5;
    static final int INCOMPLETE_MESSAGES_THRESHOULD = 5;
    static final int MESSAGE_COMPLETION_TIMEOUT = 500;
    static final int PACKET_MAX_SIZE = 1500;
    static final short PACKET_DATA_MAX_SIZE = 60;
    static final int MAX_FRAGMENT_RATE = 0;
    static final boolean ACCUMULATE_DELAYS = false;
    static final int SLEEP_THRESHOLD = 750;
    static final boolean REPORT_THROTTLING = false;
    static final boolean REPORT_ACTUAL_DELAYS = false;
    static final boolean FORCE_NEW_CONNECTIONS = false;
    public static final int ID_SIZE = 12;
    public static final int BOUNDARY = 8;
    public static final char[] MAGIC = new char[]{'M', 'I', 'O', 'P'};
    public static final byte HDR_VERSION = 16;
    public static final byte BIG_ENDIAN = 0;
    public static final byte STOP_FLAG = 2;

    public static final boolean matchMIOPMagic(char[] buf) {
        return buf[0] == 'M' && buf[1] == 'I' && buf[2] == 'O' && buf[3] == 'P';
    }

    public static byte[] getEncapsulatedUIPMCProfile(ORB orb, UIPMC_ProfileBody upb) {
        return MulticastUtil.getEncapsulatedUIPMCProfile(orb, null, upb);
    }

    public static byte[] getEncapsulatedUIPMCProfile(ORB orb, ClientConnection connection) {
        return MulticastUtil.getEncapsulatedUIPMCProfile(orb, connection, null);
    }

    private static byte[] getEncapsulatedUIPMCProfile(ORB orb, ClientConnection connection, UIPMC_ProfileBody upb) {
        CDROutputStream out = new CDROutputStream(orb);
        out.beginEncapsulatedArray();
        if (connection != null) {
            UIPMC_ProfileBodyHelper.write(out, ((MIOPProfile)connection.getRegisteredProfile()).getUIPMCProfile());
        } else {
            UIPMC_ProfileBodyHelper.write(out, upb);
        }
        byte[] result = out.getBufferCopy();
        out.close();
        return result;
    }
}

