/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.poa;

import java.util.HashSet;
import java.util.LinkedList;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.Logger;
import org.jacorb.poa.Current;
import org.jacorb.poa.EventMulticaster;
import org.jacorb.poa.RPPoolManagerListener;
import org.jacorb.poa.RequestProcessor;
import org.jacorb.poa.except.POAInternalError;

public abstract class RPPoolManager {
    private RPPoolManagerListener pmListener;
    private final Current current;
    private final LinkedList pool;
    private final HashSet activeProcessors;
    private int numberOfProcessors;
    private final int max_pool_size;
    private final int min_pool_size;
    private boolean inUse = false;
    private MonitorTask monitorTask = null;
    private final Configuration configuration;
    private final Logger logger;

    protected RPPoolManager(Current _current, int min, int max, Logger _logger, Configuration _configuration) {
        this.current = _current;
        this.max_pool_size = max;
        this.min_pool_size = min;
        this.logger = _logger;
        this.configuration = _configuration;
        this.pool = new LinkedList();
        this.activeProcessors = new HashSet();
    }

    private void init() {
        if (this.inUse) {
            return;
        }
        for (int i2 = 0; i2 < this.min_pool_size; ++i2) {
            this.addProcessor();
        }
        this.inUse = true;
        this.startMonitoringTask();
    }

    private void startMonitoringTask() {
        long reportVal;
        String propName = "jacorb.poa.thread_pool_reporting";
        String reportValStr = System.getProperty(propName, null);
        if (reportValStr == null) {
            return;
        }
        try {
            reportVal = Long.parseLong(reportValStr);
        }
        catch (NumberFormatException nfe) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Cannot monitor request thread pool usage: " + propName + " was not numeric (" + reportValStr + ")");
            }
            return;
        }
        if (reportVal > 0L) {
            if (this.logger.isInfoEnabled()) {
                this.logger.info("Will report request thread pool usage every " + reportVal + "ms");
            }
            String name = "PoolMonitorThread";
            this.monitorTask = new MonitorTask(name, reportVal);
            Thread monitorThread = new Thread(this.monitorTask);
            monitorThread.setName(name);
            monitorThread.setDaemon(true);
            monitorThread.start();
        }
    }

    private void addProcessor() {
        RequestProcessor rp = new RequestProcessor(this);
        try {
            rp.configure(this.configuration);
        }
        catch (ConfigurationException ex) {
            throw new RuntimeException(ex.toString());
        }
        this.current._addContext(rp, rp);
        rp.setDaemon(true);
        this.pool.addFirst(rp);
        ++this.numberOfProcessors;
        rp.start();
    }

    protected synchronized void addRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.add(this.pmListener, listener);
    }

    abstract void destroy();

    protected synchronized void destroy(boolean waitForCompletion) {
        int i2;
        if (!this.inUse) {
            return;
        }
        if (this.monitorTask != null) {
            this.monitorTask.stopMonitoring();
        }
        RequestProcessor[] rps = this.activeProcessors.toArray(new RequestProcessor[this.activeProcessors.size()]);
        RequestProcessor requestor = null;
        for (i2 = 0; i2 < rps.length; ++i2) {
            if (rps[i2] != Thread.currentThread()) continue;
            requestor = rps[i2];
            this.activeProcessors.remove(requestor);
            this.pool.addLast(requestor);
        }
        while (waitForCompletion && !this.activeProcessors.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException ex) {}
        }
        rps = this.pool.toArray(new RequestProcessor[this.pool.size()]);
        for (i2 = 0; i2 < rps.length; ++i2) {
            if (rps[i2].isActive() && rps[i2] != requestor) {
                if (waitForCompletion) {
                    throw new POAInternalError("error: request processor is active (RequestProcessorPM.destroy)");
                }
                this.logger.warn("request processor " + rps[i2] + " is active (RequestProcessorPM.destroy) and will be terminated");
            }
            this.pool.remove(rps[i2]);
            --this.numberOfProcessors;
            this.current._removeContext(rps[i2]);
            rps[i2].end();
        }
        this.inUse = false;
    }

    protected int getPoolCount() {
        return this.pool.size();
    }

    protected synchronized int getPoolSize() {
        return this.numberOfProcessors;
    }

    protected synchronized RequestProcessor getProcessor(boolean noblock) {
        this.init();
        if (this.pool.isEmpty() && this.numberOfProcessors < this.max_pool_size || noblock) {
            this.addProcessor();
        }
        while (this.pool.isEmpty()) {
            this.warnPoolIsEmpty();
            try {
                this.wait();
            }
            catch (InterruptedException e2) {}
        }
        RequestProcessor requestProcessor = (RequestProcessor)this.pool.removeFirst();
        this.activeProcessors.add(requestProcessor);
        if (this.pmListener != null) {
            this.pmListener.processorRemovedFromPool(requestProcessor, this.pool.size(), this.numberOfProcessors);
        }
        return requestProcessor;
    }

    protected void warnPoolIsEmpty() {
        if (this.logger.isWarnEnabled()) {
            this.logger.warn("Thread pool exhausted, consider increasing jacorb.poa.thread_pool_max (currently: " + this.max_pool_size + ")");
        }
    }

    protected synchronized void releaseProcessor(RequestProcessor rp) {
        this.activeProcessors.remove(rp);
        if (this.pool.size() < this.min_pool_size) {
            this.pool.addFirst(rp);
        } else {
            --this.numberOfProcessors;
            this.current._removeContext(rp);
            rp.end();
        }
        if (this.pmListener != null) {
            this.pmListener.processorAddedToPool(rp, this.pool.size(), this.numberOfProcessors);
        }
        this.notifyAll();
    }

    protected synchronized void removeRPPoolManagerListener(RPPoolManagerListener listener) {
        this.pmListener = EventMulticaster.remove(this.pmListener, listener);
    }

    private final class MonitorTask
    implements Runnable {
        String id;
        long delay;
        boolean keepGoing;

        MonitorTask(String _id, long _delay) {
            this.id = _id;
            this.delay = _delay;
        }

        public void run() {
            this.keepGoing = true;
            while (this.keepGoing) {
                String thisMsg;
                StringBuffer sb;
                this.performDelay();
                try {
                    long currentThreads = RPPoolManager.this.getPoolCount();
                    long maxThreads = RPPoolManager.this.getPoolSize();
                    sb = new StringBuffer();
                    sb.append(this.id);
                    sb.append(" :: max threads = ");
                    sb.append(maxThreads);
                    sb.append(", current threads = ");
                    sb.append(currentThreads);
                    thisMsg = sb.toString();
                }
                catch (Exception ex) {
                    sb = new StringBuffer();
                    sb.append("id :: unable to report thread pool usage (");
                    sb.append(ex.getClass().getName());
                    sb.append(')');
                    thisMsg = sb.toString();
                }
                if (!RPPoolManager.this.logger.isInfoEnabled()) continue;
                RPPoolManager.this.logger.info(thisMsg);
            }
        }

        private void stopMonitoring() {
            this.keepGoing = false;
        }

        private void performDelay() {
            try {
                Thread.currentThread();
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

