/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.security.ssl.sun_jsse;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import javax.net.SocketFactory;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.jacorb.orb.ORB;
import org.jacorb.orb.factory.AbstractSocketFactory;
import org.jacorb.orb.listener.SSLHandshakeListener;
import org.jacorb.orb.listener.SSLSessionListener;
import org.jacorb.security.ssl.sun_jsse.KeyStoreUtil;
import org.jacorb.security.ssl.sun_jsse.SSLRandom;

public class SSLSocketFactory
extends AbstractSocketFactory {
    private SocketFactory factory = null;
    private String[] cipher_suites = null;
    private String[] enabledProtocols = null;
    private TrustManager trustManager = null;
    private boolean trusteesFromKS = false;
    private short clientSupportedOptions = 0;
    private String keystore_location = null;
    private String keystore_passphrase = null;
    private final SSLSessionListener sslListener;
    private SSLRandom sslRandom;
    private String keystore_type = null;
    private String keyManagerAlgorithm = null;
    private String trustManagerAlgorithm = null;
    private String keystore_provider = null;
    private String keystore_provider_impl = null;
    private String truststore_type = null;
    private String truststore_location = null;
    private String truststore_passphrase = null;
    private String truststore_provider = null;
    private String truststore_provider_impl = null;
    private String jsseProvider = null;
    private String jsseProviderImpl = null;

    public SSLSocketFactory(ORB orb) {
        this.sslListener = orb.getTransportManager().getSocketFactoryManager().getSSLListener();
    }

    public void configure(Configuration configuration) throws ConfigurationException {
        org.jacorb.config.Configuration config;
        block6: {
            super.configure(configuration);
            config = (org.jacorb.config.Configuration)configuration;
            this.sslRandom = new SSLRandom();
            this.sslRandom.configure(configuration);
            this.trusteesFromKS = configuration.getAttributeAsBoolean("jacorb.security.jsse.trustees_from_ks", false);
            this.keystore_location = configuration.getAttribute("jacorb.security.keystore");
            this.keystore_passphrase = configuration.getAttribute("jacorb.security.keystore_password");
            this.keystore_type = configuration.getAttribute("jacorb.security.keystore_type", "JKS");
            this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider", null);
            this.keystore_provider = configuration.getAttribute("jacorb.security.keystore_provider_impl", null);
            this.truststore_type = configuration.getAttribute("jacorb.security.truststore_type", null);
            this.truststore_location = configuration.getAttribute("jacorb.security.truststore", null);
            this.truststore_passphrase = configuration.getAttribute("jacorb.security.truststore_password", null);
            this.truststore_provider = configuration.getAttribute("jacorb.security.truststore_provider", null);
            this.truststore_provider_impl = configuration.getAttribute("jacorb.security.truststore_provider_impl", null);
            this.keyManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.key_manager_algorithm", "SunX509");
            this.trustManagerAlgorithm = configuration.getAttribute("jacorb.security.jsse.client.trust_manager_algorithm", "SunX509");
            this.jsseProvider = configuration.getAttribute("jacorb.security.jsse.provider", null);
            this.jsseProviderImpl = configuration.getAttribute("jacorb.security.jsse.provider_impl", null);
            this.clientSupportedOptions = (short)config.getAttributeAsInteger("jacorb.security.ssl.client.supported_options", 0, 16);
            try {
                this.trustManager = (TrustManager)((org.jacorb.config.Configuration)configuration).getAttributeAsObject("jacorb.security.ssl.client.trust_manager");
            }
            catch (ConfigurationException e2) {
                if (!this.logger.isErrorEnabled()) break block6;
                this.logger.error("TrustManager object creation failed. Please check value of property 'jacorb.security.ssl.client.trust_manager'. Current value: " + configuration.getAttribute("jacorb.security.ssl.client.trust_manager", ""), e2);
            }
        }
        if (configuration.getAttribute("jacorb.security.ssl.client.protocols", null) != null) {
            this.enabledProtocols = config.getAttributeAsStringsArray("jacorb.security.ssl.client.protocols");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified client enabled protocols : " + configuration.getAttribute("jacorb.security.ssl.client.protocols", ""));
            }
        }
        try {
            this.factory = this.createSocketFactory();
        }
        catch (Exception e3) {
            this.logger.error("Unable to create SSLSocketFactory!", e3);
            throw new ConfigurationException("Unable to create SSLSocketFactory!", e3);
        }
        this.cipher_suites = config.getAttributeAsStringsArray("jacorb.security.ssl.client.cipher_suites");
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket(host, port);
        this.initSSLSocket(socket);
        return socket;
    }

    protected Socket doCreateSocket(String host, int port, int timeout) throws IOException {
        SSLSocket socket = (SSLSocket)this.factory.createSocket();
        socket.connect(new InetSocketAddress(host, port), timeout);
        this.initSSLSocket(socket);
        return socket;
    }

    private void initSSLSocket(SSLSocket socket) {
        if (this.cipher_suites != null) {
            socket.setEnabledCipherSuites(this.cipher_suites);
        }
        if (this.enabledProtocols != null) {
            socket.setEnabledProtocols(this.enabledProtocols);
        }
        socket.addHandshakeCompletedListener(new SSLHandshakeListener(this.logger, this.sslListener));
    }

    public boolean isSSL(Socket socket) {
        return socket instanceof SSLSocket;
    }

    private SocketFactory createSocketFactory() throws IOException, GeneralSecurityException {
        TrustManager[] trustManagers;
        KeyManagerFactory kmf = null;
        KeyStore key_store = null;
        if (this.trusteesFromKS || (this.clientSupportedOptions & 0x40) != 0) {
            key_store = KeyStoreUtil.getKeyStore(this.keystore_location, this.keystore_passphrase.toCharArray(), this.keystore_type, this.keystore_provider, this.keystore_provider_impl);
            if ((this.clientSupportedOptions & 0x40) != 0) {
                if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
                    KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
                    kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm, this.jsseProvider);
                } else {
                    kmf = KeyManagerFactory.getInstance(this.keyManagerAlgorithm);
                }
                if ("WINDOWS-MY".equalsIgnoreCase(this.keystore_type)) {
                    kmf.init(key_store, null);
                } else {
                    kmf.init(key_store, this.keystore_passphrase.toCharArray());
                }
            }
        }
        TrustManagerFactory tmf = null;
        if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
            KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm, this.jsseProvider);
        } else {
            tmf = TrustManagerFactory.getInstance(this.trustManagerAlgorithm);
        }
        KeyStore trust_store = null;
        if (this.trusteesFromKS) {
            trust_store = key_store;
        } else if ("PKCS11".equalsIgnoreCase(this.truststore_type)) {
            trust_store = KeyStore.getInstance(this.truststore_type, this.truststore_provider);
            trust_store.load(null, this.truststore_passphrase.toCharArray());
        } else if ("WINDOWS-ROOT".equalsIgnoreCase(this.truststore_type)) {
            trust_store = KeyStore.getInstance("WINDOWS-ROOT");
            trust_store.load(null, null);
        } else if (this.truststore_location != null && this.truststore_passphrase != null) {
            trust_store = KeyStoreUtil.getKeyStore(this.truststore_location, this.truststore_passphrase.toCharArray(), this.truststore_type, this.truststore_provider, this.truststore_provider_impl);
        }
        if (trust_store != null && this.logger.isInfoEnabled()) {
            this.logger.info("Loading trusted certs from keystore " + trust_store.getType());
        }
        tmf.init(trust_store);
        if (this.trustManager == null) {
            trustManagers = tmf.getTrustManagers();
        } else {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Setting user specified TrustManager for the client: " + this.trustManager.getClass().getName());
            }
            trustManagers = new TrustManager[]{this.trustManager};
        }
        SSLContext ctx = null;
        if (this.jsseProvider != null && this.jsseProvider.length() > 0) {
            KeyStoreUtil.checkProvider(this.jsseProvider, this.jsseProviderImpl);
            ctx = SSLContext.getInstance("TLS", this.jsseProvider);
        } else {
            ctx = SSLContext.getInstance("TLS");
        }
        ctx.init(kmf == null ? null : kmf.getKeyManagers(), trustManagers, this.sslRandom.getSecureRandom());
        return ctx.getSocketFactory();
    }
}

