/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.cello.mimparser.MimParser;
import se.ericsson.cello.mimparser.MomAttribute;
import se.ericsson.cello.mimparser.MomClass;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.ExportManager;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MOMergeSort;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.MOMDataTypeConversion;

public class ExportUtil {
    public static final String XML_START_STRING = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    public static final String XML_AUTHOR_NOTES = "<!-- This XML file was generated by the Export/Delete Tool -->";
    public static final String ELEMENT = "Element";
    public static final String ATTRIBUTE = "ATTRIBUTE";
    public static final String NAME = "NAME";
    public static final String VALUE = "VALUE";
    public static final String TYPE = "TYPE";
    public static final String LDN = "LDN";
    public static final String ATTRNAME_COULD_NOT_BE_READ = "Attribute could not be read";
    public static final String VALUE_ID = "Id";
    public static final String VALUE_PROGRESS_STRING = "Exporting Managed Objects to XML-file  ";
    public static final String INDENT_INCREMENT = "  ";
    private OutputStream os;
    private PrintWriter pw = null;
    private MoHandlerCache theMoHandler;
    private BemMo rootMo;
    private MimModel myMimModel;
    private ExportManager exportManager;
    private String xmlPath;

    public ExportUtil(MoHandlerCache moHandlerCache, OutputStream outputStream, String string, String string2, ExportManager exportManager) throws MoHandlerException, IOException, Exception {
        this.theMoHandler = moHandlerCache;
        this.os = outputStream;
        this.xmlPath = string2;
        this.exportManager = exportManager;
    }

    public void exportMOProxyToXML() throws MoHandlerException, IOException, Exception {
        this.pw = new PrintWriter(this.os);
        this.rootMo = this.theMoHandler.getRoot();
        this.pw.println(XML_START_STRING);
        this.pw.println(XML_AUTHOR_NOTES);
        this.pw.println("<!-- Date: " + new Date().toString() + " -->");
        this.myMimModel = MimParser.parse((String)this.xmlPath);
        this.exportMOElementsToXML(this.rootMo, "");
        this.pw.flush();
        this.pw.close();
    }

    private void exportMOElementsToXML(BemMo bemMo, String string) throws MoHandlerException, Exception {
        this.pw.println(string + "<" + ELEMENT + " " + LDN + "=\"" + ExportUtil.xmlEncodeTextForAttribute(bemMo.getDN()) + "\">");
        this.exportMOAttributesToXML(bemMo, string + INDENT_INCREMENT);
        BemMo[] bemMoArray = this.theMoHandler.getChildren(bemMo, 1, "", "");
        this.sortChildrenInAscendingOrder(bemMoArray);
        for (int i = 1; i < bemMoArray.length; ++i) {
            this.exportMOElementsToXML(bemMoArray[i], string + INDENT_INCREMENT);
        }
        this.pw.println(string + "</" + ELEMENT + ">");
        this.pw.flush();
        if (this.exportManager != null) {
            this.exportManager.updateProgress();
            this.exportManager.checkIfCancelled();
        }
    }

    private void exportMOAttributesToXML(BemMo bemMo, String string) {
        NalNameValue[] nalNameValueArray = this.getAllAttributes(bemMo);
        this.addAttributes(nalNameValueArray, string);
    }

    private NalNameValue[] getAllAttributes(BemMo bemMo) {
        String[] stringArray;
        ArrayList<NalNameValue> arrayList = new ArrayList<NalNameValue>();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        String string = bemMo.getDN();
        MomClass momClass = this.myMimModel.getClass(bemMo.getType());
        if (momClass == null) {
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("", "<! --- Unknown Motype " + bemMo + " ---!>")};
            return nalNameValueArray;
        }
        Iterator iterator = momClass.getAttributes();
        MomAttribute momAttribute = null;
        while (iterator.hasNext()) {
            momAttribute = (MomAttribute)iterator.next();
            stringArray = momAttribute.getName();
            arrayList2.add(stringArray);
        }
        stringArray = arrayList2.toArray(new String[0]);
        if (arrayList2.isEmpty()) {
            String string2 = "ExportManager: Can't find any attributes for the ldn: " + string;
            BemLog.log(7, string2);
            return new NalNameValue[0];
        }
        try {
            int n;
            Object[] objectArray = bemMo.getAttributes(stringArray);
            NalNameValue[] nalNameValueArray = new NalNameValue[objectArray.length];
            for (n = 0; n < objectArray.length; ++n) {
                nalNameValueArray[n] = Nal.getFactory().getNameValue(stringArray[n], objectArray[n]);
            }
            for (n = 0; n < objectArray.length; ++n) {
                if (objectArray[n] != null) {
                    arrayList.add(Nal.getFactory().getNameValue(stringArray[n], objectArray[n]));
                    continue;
                }
                arrayList.add(Nal.getFactory().getNameValue(stringArray[n], "Attribute could not be read, value is null, i.e. the value is not defined."));
                String string3 = "ExportManager: Can't find Attribute: " + stringArray[n] + " for ldn = " + string;
                BemLog.log(7, string3);
            }
        }
        catch (NalCmException nalCmException) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string4;
                try {
                    Object object = bemMo.getAttribute(stringArray[i]);
                    if (object != null) {
                        arrayList.add(Nal.getFactory().getNameValue(stringArray[i], object));
                        continue;
                    }
                    arrayList.add(Nal.getFactory().getNameValue(stringArray[i], "Attribute could not be read, value is null, i.e. the value is not defined."));
                    string4 = "ExportManager: Can't find Attribute: " + stringArray[i] + " for ldn = " + string;
                    BemLog.log(7, string4);
                    continue;
                }
                catch (NalCmException nalCmException2) {
                    arrayList.add(Nal.getFactory().getNameValue(stringArray[i], "Attribute could not be read, NalCmException! Causetag: " + nalCmException.getCauseTag()));
                    string4 = "ExportManager: Can't find Attribute: " + stringArray[i] + " for ldn = " + string;
                    BemLog.log(7, string4);
                }
            }
        }
        return arrayList.toArray(new NalNameValue[arrayList.size()]);
    }

    private void addAttributes(NalNameValue[] nalNameValueArray, String string) {
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            Object object;
            String string2;
            Object object2 = nalNameValueArray[i].getValue();
            String string3 = nalNameValueArray[i].getName();
            if (object2.getClass().isArray()) {
                this.addArrayAttribute(nalNameValueArray[i], string);
                continue;
            }
            if (object2 instanceof NalStruct) {
                string2 = object2.getClass().toString();
                string2 = string2.substring(string2.lastIndexOf(".") + 1);
                string2 = MOMDataTypeConversion.convert(object2);
                this.printOneAttributeInAnArray(string, string3, "", string2);
                object = (NalStruct)object2;
                NalNameValue[] nalNameValueArray2 = object.getNameValueArray();
                if (nalNameValueArray2 != null) {
                    for (int j = 0; j < nalNameValueArray2.length; ++j) {
                        if (nalNameValueArray2[j] == null) continue;
                        Object object3 = nalNameValueArray2[j].getValue();
                        String string4 = nalNameValueArray2[j].getName();
                        string2 = MOMDataTypeConversion.convert(object3);
                        String string5 = object3.toString();
                        this.printOneAttribute(string + INDENT_INCREMENT, string4, ExportUtil.xmlEncodeTextForAttribute(string5), string2);
                    }
                }
                this.pw.println(string + "</" + ATTRIBUTE + ">");
                this.pw.flush();
                continue;
            }
            string2 = object2.getClass().toString();
            string2 = string2.substring(string2.lastIndexOf(".") + 1);
            string2 = MOMDataTypeConversion.convert(object2);
            object = object2.toString();
            this.printOneAttribute(string, string3, ExportUtil.xmlEncodeTextForAttribute((String)object), string2);
        }
    }

    private void addArrayAttribute(NalNameValue nalNameValue, String string) {
        Object object = nalNameValue.getValue();
        String string2 = nalNameValue.getName();
        String string3 = null;
        String string4 = null;
        string3 = MOMDataTypeConversion.convert(object);
        string4 = string3.substring(string3.lastIndexOf(" ") + 1);
        this.printOneAttributeInAnArray(string, string2, "", string3);
        if (object instanceof NalStruct[]) {
            NalStruct[] nalStructArray = (NalStruct[])object;
            for (int i = 0; i < nalStructArray.length; ++i) {
                this.printOneAttributeInAnArray(string + INDENT_INCREMENT, string2, "", string4);
                NalNameValue[] nalNameValueArray = nalStructArray[i].getNameValueArray();
                this.addAttributes(nalNameValueArray, string + INDENT_INCREMENT + INDENT_INCREMENT);
                this.pw.println(string + INDENT_INCREMENT + "</" + ATTRIBUTE + ">");
                this.pw.flush();
            }
        } else if (object instanceof BemMo[]) {
            BemMo[] bemMoArray = (BemMo[])object;
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string5 = null;
                if (bemMoArray[i] != null) {
                    string5 = bemMoArray[i].getDN();
                }
                this.printOneAttribute(string + INDENT_INCREMENT, string2, ExportUtil.xmlEncodeTextForAttribute(string5), string4);
            }
        } else if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            for (int i = 0; i < stringArray.length; ++i) {
                String string6 = stringArray[i];
                this.printOneAttribute(string + INDENT_INCREMENT, string2, ExportUtil.xmlEncodeTextForAttribute(string6), string4);
            }
        } else if (object instanceof int[]) {
            int[] nArray = (int[])object;
            for (int i = 0; i < nArray.length; ++i) {
                this.printOneAttribute(string + INDENT_INCREMENT, string2, String.valueOf(nArray[i]), string4);
            }
        } else if (object instanceof long[]) {
            long[] lArray = (long[])object;
            for (int i = 0; i < lArray.length; ++i) {
                this.printOneAttribute(string + INDENT_INCREMENT, string2, String.valueOf(lArray[i]), string4);
            }
        } else {
            String string7 = "ExportManager: Unknown array format " + string4 + "[]";
            BemLog.log(7, string7);
        }
        this.pw.println(string + "</" + ATTRIBUTE + ">");
        this.pw.flush();
    }

    private void printOneAttribute(String string, String string2, String string3, String string4) {
        if (string3 != null && string3.indexOf(ATTRNAME_COULD_NOT_BE_READ) >= 0) {
            this.pw.println(string + "<!--" + ATTRIBUTE + " " + NAME + "=\"" + string2 + "\" " + VALUE + "=\"" + string3 + "\" " + TYPE + "=\"" + string4 + "\"/-->");
        } else {
            this.pw.println(string + "<" + ATTRIBUTE + " " + NAME + "=\"" + string2 + "\" " + VALUE + "=\"" + string3 + "\" " + TYPE + "=\"" + string4 + "\"/>");
        }
    }

    private void printOneAttributeInAnArray(String string, String string2, String string3, String string4) {
        if (string3 != null && string3.indexOf(ATTRNAME_COULD_NOT_BE_READ) >= 0) {
            this.pw.println(string + "<!--" + ATTRIBUTE + " " + NAME + "=\"" + string2 + "\" " + VALUE + "=\"" + string3 + "\" " + TYPE + "=\"" + string4 + "\"-->");
        } else {
            this.pw.println(string + "<" + ATTRIBUTE + " " + NAME + "=\"" + string2 + "\" " + VALUE + "=\"" + string3 + "\" " + TYPE + "=\"" + string4 + "\">");
        }
    }

    private void sortChildrenInAscendingOrder(BemMo[] bemMoArray) {
        int n = bemMoArray.length;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = bemMoArray[i].getLastRDN();
        }
        MOMergeSort.mergeSortAscending(bemMoArray, stringArray, 1, n - 1);
    }

    public static final String xmlEncodeTextForAttribute(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() * 2);
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            Character c2 = new Character(c);
            if (c2.hashCode() == 10 || c2.hashCode() == 13) {
                stringBuffer.append(c);
                continue;
            }
            if (c2.hashCode() >= 160) {
                stringBuffer.append("&#" + c2.hashCode() + ";");
                continue;
            }
            if (c == '&') {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (Character.isISOControl(c)) {
                stringBuffer.append("_");
                continue;
            }
            stringBuffer.append(String.valueOf(c));
        }
        return stringBuffer.toString();
    }

    public MimModel getMimModel() {
        return this.myMimModel;
    }
}

