/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.AbstractSiteComplete;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteCompleteAtm;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteCompleteCommonOam;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteCompleteDualStack;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteCompleteIp;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.SiteCompleteTuning;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIub;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SiteComplete {
    private List<AbstractSiteComplete> siteComplete = new ArrayList<AbstractSiteComplete>();

    public SiteComplete(Rbs rbs, MimModel mimModel, PrintWriter printWriter, PrintWriter printWriter2) throws BemException {
        SiteCompleteCommonOam siteCompleteCommonOam = new SiteCompleteCommonOam(rbs, mimModel, printWriter, printWriter2);
        SiteCompleteIp siteCompleteIp = null;
        SiteCompleteAtm siteCompleteAtm = null;
        SiteCompleteDualStack siteCompleteDualStack = null;
        SiteCompleteTuning siteCompleteTuning = new SiteCompleteTuning(rbs, mimModel, printWriter, printWriter2);
        this.siteComplete.add(siteCompleteTuning);
        String string = this.getTransportOption(rbs);
        if (this.isDualStackNode(rbs)) {
            siteCompleteDualStack = new SiteCompleteDualStack(rbs, mimModel, printWriter, printWriter2);
            this.siteComplete.add(siteCompleteDualStack);
        } else if (string != null) {
            if (string.equals("atm")) {
                siteCompleteAtm = new SiteCompleteAtm(rbs, mimModel, printWriter, printWriter2);
                this.siteComplete.add(siteCompleteAtm);
            } else if (string.equals("ipV4")) {
                siteCompleteIp = new SiteCompleteIp(rbs, mimModel, printWriter, printWriter2);
                this.siteComplete.add(siteCompleteIp);
            }
        }
        this.siteComplete.add(siteCompleteCommonOam);
    }

    private String getTransportOption(Rbs rbs) throws BemException {
        CustomerParameter customerParameter = null;
        customerParameter = rbs.getCustomerParameterObject("IPoverGigabitEthernet_transportOption");
        if (customerParameter != null) {
            String string = customerParameter.getValue();
            return string;
        }
        return null;
    }

    public void generateMoScript() throws BemException {
        for (AbstractSiteComplete abstractSiteComplete : this.siteComplete) {
            abstractSiteComplete.generateMoScript();
        }
    }

    private boolean isDualStackNode(Rbs rbs) throws BemException {
        MoHandler moHandler = rbs.getMoHandler();
        MoInstance moInstance = rbs.getNodeBFunctionMoi();
        try {
            BemMo bemMo = moHandler.getMo(moInstance.getLdn());
            BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimIub.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length > 0) {
                BemMo bemMo2 = bemMoArray[0];
                NalStruct nalStruct = (NalStruct)bemMo2.getAttribute("userPlaneTransportOption");
                Boolean bl = (Boolean)nalStruct.getMemberValue("atm");
                Boolean bl2 = (Boolean)nalStruct.getMemberValue("ipV4");
                if (bl.booleanValue() && bl2.booleanValue()) {
                    return true;
                }
            }
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (MoHandlerException moHandlerException) {
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "isDualStackNode()", null, "\tCould not find field inuserPlaneTransportOption", noSuchFieldException);
        }
        return false;
    }
}

