/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.table.TableColumn;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.model.ReplaceEtmModel;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.view.ReplaceEtmView;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.view.ReplaceEtmViewer;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.support.gui.EmasProgressMonitor;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplication;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class ReplaceEtmController
extends AbstractApplicationController
implements ProgressReporter,
Observer {
    private static final String TITLE_STRING_REPL_ETM = "Manage Transmission Link";
    private static final String TITLE_STRING_REPL_ETM_PROGRESS = "Manage Transmission Link Progress";
    private static final String VALUE_STRING_GET_EXIST_ETM_EXC = "Get existing ETM types exception                              ";
    private static final String VALUE_STRING_PRINT_STACK = "Stack: ";
    private static final String VALUE_STRING_WARNING = "Warning";
    private static final String VALUE_STRING_CONFIRM = "Confirm";
    private static final String VALUE_STRING_ERROR = "Error";
    private ReplaceEtmViewer myView = null;
    private int totalExpectedProgressReports = 0;
    private int progressReportsReceived = 0;
    private EmasProgressMonitor progressBar;
    private ReplaceEtmModel replaceEtmModel;
    private JTable etmTable;
    private JComboBox etmBoardComboBox;
    private String exchangeTerminalLdn;
    private String slot1;
    private String existingType1;
    private int numberOfBoards;
    private boolean lockable = true;

    protected void init() {
        this.myView = (ReplaceEtmViewer)((Object)this.getView());
        try {
            this.replaceEtmModel = ReplaceEtmModel.instance(this, this);
            this.replaceEtmModel.addObserver(this);
            this.etmTable = this.myView.getEtmTable();
        }
        catch (BemException bemException) {
            this.reportError(bemException);
            BemLog.exceptionRaised(VALUE_STRING_GET_EXIST_ETM_EXC, bemException);
            BemLog.log(7, VALUE_STRING_PRINT_STACK + bemException.toString());
            this.endTheApplication();
        }
    }

    public void update(Observable observable, Object object) {
        NalNameValue nalNameValue = (NalNameValue)object;
        Integer n = (Integer)nalNameValue.getValue();
        this.progressReportsReceived += n.intValue();
        this.reportProgress(TITLE_STRING_REPL_ETM_PROGRESS, nalNameValue.getName());
        BemLog.log(7, "Progress: " + this.progressReportsReceived + " (" + this.totalExpectedProgressReports + ")");
    }

    public void setTotalExpectedProgressReports(int n) {
        this.totalExpectedProgressReports = n;
    }

    protected boolean canStop() {
        return true;
    }

    protected void beforeVisible() {
        this.exchangeTerminalLdn = (String)this.getParameter("DNs");
        if (this.exchangeTerminalLdn != null) {
            BemLog.log(4, "Selected ExchangeTerminal: " + this.exchangeTerminalLdn);
        }
        try {
            HashMap<String, String> hashMap = this.replaceEtmModel.getExistingEtmNv(this.exchangeTerminalLdn);
            this.slot1 = hashMap.get("slot1");
            this.existingType1 = hashMap.get("type1");
            this.numberOfBoards = 1;
            if (hashMap.get("slot2") != null) {
                this.numberOfBoards = 2;
            }
            this.etmTable.setValueAt(this.slot1, 0, 0);
            this.etmTable.setValueAt(this.existingType1, 0, 1);
            boolean bl = hashMap.get("replacable1").equals("yes");
            if (!bl) {
                this.lockable = false;
                this.myView.setTableHeader();
                this.etmTable.setValueAt(false, 0, 2);
                boolean[] blArray = new boolean[]{false, false, false};
                Object[] objectArray = new Object[this.myView.getNumColumnsInEtmTable()];
                if (this.numberOfBoards > 1) {
                    objectArray[0] = hashMap.get("slot2");
                    objectArray[1] = hashMap.get("type2");
                    objectArray[2] = false;
                    this.myView.addRowToEtmTable(objectArray, blArray);
                    this.setInfoTextInArea(false, true);
                } else {
                    this.setInfoTextInArea(false, false);
                }
                this.myView.setEtmTableCellEditor();
            } else if (bl) {
                this.etmBoardComboBox = this.myView.getEtmComboBox();
                Vector vector = this.replaceEtmModel.getAvailableEtmDisplayTypes();
                vector.remove("Cbu");
                vector.add("NONE");
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement().toString();
                    this.etmBoardComboBox.addItem(string);
                }
                this.etmTable.setValueAt("NONE", 0, 2);
                TableColumn tableColumn = this.etmTable.getColumnModel().getColumn(2);
                tableColumn.setCellRenderer(this.myView.getComboBoxRenderer(vector));
                this.setInfoTextInArea(true, false);
            }
        }
        catch (BemException bemException) {
            this.reportError(bemException);
            this.endTheApplication();
        }
        catch (Exception exception) {
            this.displayError(VALUE_STRING_GET_EXIST_ETM_EXC);
            BemLog.exceptionRaised(VALUE_STRING_GET_EXIST_ETM_EXC, exception);
            BemLog.log(7, VALUE_STRING_PRINT_STACK + exception.toString());
            this.endTheApplication();
        }
    }

    private void setInfoTextInArea(boolean bl, boolean bl2) {
        JTextArea jTextArea = this.myView.getInfoTextArea();
        String string = "                   I N F O R M A T I O N                   \n";
        String string2 = " Change/Delete ETM Board is used for a board with only     \n";
        String string3 = " ETM functionality. The configuration of the selected ETM  \n";
        String string4 = " board will be removed together with the transport network \n";
        String string5 = " configuration related to that board.                      \n";
        String string6 = "                   I N F O R M A T I O N                   \n";
        String string7 = " All transport network configuration related to the selected\n";
        String string8 = " Exchange Terminals will be removed.\t                    \n";
        String string9 = " Exchange Terminal will be removed.\t                    \n";
        String string10 = " If removing IP over ATM, it is required to remove both    \n";
        String string11 = " primary and redunant link at the same time.               \n";
        String string12 = "\n Run O&M Access Wizard to re-configure Mub         \n";
        String string13 = string;
        if (bl) {
            string13 = string13 + string2 + string3 + string4 + string5;
        } else {
            string13 = string6;
            string13 = string13 + string7;
            string13 = bl2 ? string13 + string8 + string10 + string11 : string13 + string9;
        }
        string13 = string13 + string12;
        jTextArea.setText(string13);
        jTextArea.doLayout();
    }

    protected void afterVisible() {
        try {
            this.myView.getOkButton().addActionListener(new OkButtonListener());
            this.myView.getCancelButton().addActionListener(new CancelButtonListener());
        }
        catch (Exception exception) {
            this.displayError(exception.toString());
        }
    }

    protected void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_WARNING, 2);
    }

    protected boolean displayConfirmDialog(String string) {
        boolean bl = true;
        int n = JOptionPane.showConfirmDialog(null, string, VALUE_STRING_CONFIRM, 0);
        if (n == 1) {
            bl = false;
        }
        return bl;
    }

    protected void displayError(String string) {
        JOptionPane.showMessageDialog(null, string, VALUE_STRING_ERROR, 0);
    }

    public void reportComplete(StringBuffer stringBuffer) {
    }

    public void reportError(BemException bemException) {
        this.getEasyPopUp().displayError(bemException);
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        if (this.progressBar != null) {
            this.progressBar.setNote(string2);
            this.progressBar.setProgress(this.progressReportsReceived);
        }
    }

    public String getReportedProgress() {
        return this.progressBar.getNote();
    }

    public void cleanUpProgress() {
        if (this.progressReportsReceived != this.totalExpectedProgressReports) {
            BemLog.log(7, "Prog: " + this.progressReportsReceived + " Total: " + this.totalExpectedProgressReports);
            NalFactory nalFactory = Nal.getFactory();
            for (int i = this.progressReportsReceived; i < this.totalExpectedProgressReports; ++i) {
                this.update(null, nalFactory.getNameValue("", 1));
            }
            this.progressBar.close();
        }
        this.progressBar = null;
    }

    private void endTheApplication() {
        this.cleanUpProgress();
        this.totalExpectedProgressReports = 0;
        this.progressReportsReceived = 0;
        if (this.replaceEtmModel != null) {
            this.replaceEtmModel.deleteObserver(this);
            ReplaceEtmModel.reset();
            this.replaceEtmModel = null;
        }
        AbstractApplication abstractApplication = null;
        try {
            abstractApplication = this.getApplication();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (abstractApplication != null) {
            abstractApplication.stopApplication();
        }
    }

    public void setUpProgressMonitor() {
        this.progressReportsReceived = 0;
        this.progressBar = new EmasProgressMonitor((ReplaceEtmView)this.myView, TITLE_STRING_REPL_ETM_PROGRESS, "", "                                                                ", this.progressReportsReceived, this.totalExpectedProgressReports);
        this.progressBar.setMillisToDecideToPopup(0);
        this.progressBar.setMillisToPopup(0);
    }

    public void notifyConfigurationSuccessful() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n Change/Deletion of transport network was successfully completed!");
        JOptionPane.showMessageDialog((ReplaceEtmView)this.myView, stringBuffer.toString(), TITLE_STRING_REPL_ETM, 1);
    }

    protected void viewClosing() {
        this.endTheApplication();
    }

    public int notifyToChangeHardware(boolean bl, String string) {
        String string2 = this.getNotifyToChangeHardwareMsg(bl, string);
        int n = JOptionPane.showConfirmDialog((ReplaceEtmView)this.myView, string2, TITLE_STRING_REPL_ETM, 2, 1);
        return n;
    }

    public boolean notifyShouldRollback() {
        String string = "\n The node is in an un-defined state. It is needed to perform a rollback.\n The rollback requires that the node is restarted.\n\n Do you want to perform the rollback?";
        return this.displayConfirmDialog(string);
    }

    private String getNotifyToChangeHardwareMsg(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.lockable) {
            stringBuffer.append("\n The board" + (this.numberOfBoards <= 1 ? " " : "s "));
            stringBuffer.append(" could not be locked!");
            stringBuffer.append("\n\n Press OK to continue!\n\n");
        } else {
            stringBuffer.append("\n The ETM board" + (this.numberOfBoards <= 1 ? " is" : "s are"));
            if (bl) {
                stringBuffer.append(" already locked!");
            } else {
                stringBuffer.append(" now locked!");
            }
            if (string != null) {
                if (string.equals("NONE")) {
                    stringBuffer.append("\n\n Please remove board " + this.slot1 + " : " + this.existingType1 + " from subrack.");
                } else {
                    stringBuffer.append("\n\n Please replace board " + this.slot1 + " : " + this.existingType1 + " with new board " + this.slot1 + " : " + string + " in subrack.");
                }
            }
            stringBuffer.append("\n\n Press OK when ready!\n\n");
        }
        return stringBuffer.toString();
    }

    class CancelButtonListener
    implements ActionListener {
        CancelButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReplaceEtmController.this.endTheApplication();
        }
    }

    class OkButtonListener
    implements ActionListener {
        OkButtonListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ReplaceEtmController.this.myView.setButtonsToEnabled(false);
            Runnable runnable = new Runnable(){

                public void run() {
                    try {
                        String string = ReplaceEtmController.this.etmTable.getValueAt(0, 2).toString();
                        if (string.equals("true")) {
                            ReplaceEtmController.this.replaceEtmModel.performReplaceEtm(ReplaceEtmController.this.exchangeTerminalLdn, null);
                        } else {
                            ReplaceEtmController.this.replaceEtmModel.performReplaceEtm(ReplaceEtmController.this.exchangeTerminalLdn, string);
                        }
                        ReplaceEtmController.this.endTheApplication();
                    }
                    catch (BemException bemException) {
                        ReplaceEtmController.this.reportError(bemException);
                    }
                    catch (Exception exception) {
                        String string = "Unexpected exception " + exception.toString();
                        ReplaceEtmController.this.displayError(string);
                        exception.printStackTrace();
                        ReplaceEtmController.this.endTheApplication();
                    }
                }
            };
            Thread thread = new Thread(runnable);
            thread.start();
        }
    }
}

