/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.model;

import java.util.HashMap;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCache;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.util.MoHandlerCacheImpl;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.control.ReplaceEtmController;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.util.CreateEtm;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.util.DeleteEtm;
import se.ericsson.wcdma.rbs.bem.application.applications.replaceetm.util.DeleteEtmUtil;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EtmBoardProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.ConfigurationVersionRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.RollbackConfigurationVersionRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminal;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExchangeTerminalIp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplaceEtmModel
extends Observable {
    private static final String VALUE_STRING_PREP_DEL_ET_EXC = "Prepare Delete ET exception";
    private static final String VALUE_STRING_COMMIT_AND_ROLLBACK_FAIL = "Delete: Commit and Rollback failed. The node will be restarted on the Cancel CV created by this application.";
    private static final String VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC = "Delete failed! A rollback has been performed. \nThe configuration has been reverted to the same level as before running this application.";
    private static final String VALUE_STRING_ET_BOARD_STILL_IN_USE_INFO = "\n\nThe ET board is still in use. \nIf \"Migration of RBS between ATM and IP\" is initiated, \nthen please check that correct OPI is used. ";
    private static final String VALUE_STRING_ROLLBACK_CREATE_FAIL_EXC = "Rollback CV creation failed";
    private static final String VALUE_STRING_USE_ROLLBACK_CV_FAILED_EXC = "Trying to use Rollback CV failed";
    private static final String VALUE_STRING_CREATE_ET_EXC = "Create Etm exception                                           ";
    private static final String RESTART_INFORMATION = "ReplaceEtm configuration failed rollback to previous configuration";
    private static final String VALUE_STRING_PRINT_STACK = "Stack: ";
    public static final String VALUE_STRING_COMBO_BOX_NONE = "NONE";
    private final DeleteEtm deleteEtm;
    private Rbs rbs;
    private final ReplaceEtmController replaceEtmController;
    private static ReplaceEtmModel theInstance;
    private RollbackConfigurationVersionRI rollbackCV;

    private ReplaceEtmModel(ProgressReporter progressReporter, ReplaceEtmController replaceEtmController) throws BemException {
        this.replaceEtmController = replaceEtmController;
        MoHandlerCacheImpl moHandlerCacheImpl = new MoHandlerCacheImpl();
        this.rbs = RbsFactory.getRbs(moHandlerCacheImpl, "STEP_OAM");
        moHandlerCacheImpl.clearOrderMoOperations();
        this.deleteEtm = new DeleteEtm(this.rbs);
        try {
            moHandlerCacheImpl.initiateCache();
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
    }

    public static ReplaceEtmModel instance(ProgressReporter progressReporter, ReplaceEtmController replaceEtmController) throws BemException {
        if (theInstance != null) {
            throw new BemException("Manage Transmission Link Already Open");
        }
        theInstance = new ReplaceEtmModel(progressReporter, replaceEtmController);
        return theInstance;
    }

    public static void reset() {
        theInstance = null;
    }

    private boolean commitOrderredMoOperations(boolean bl) throws BemException {
        try {
            MoHandlerCache moHandlerCache = (MoHandlerCache)this.rbs.getMoHandler();
            moHandlerCache.commitOrderredMoOperations(false);
            if (bl) {
                moHandlerCache.clearCache();
            }
            moHandlerCache.clearOrderMoOperations();
        }
        catch (MoHandlerException moHandlerException) {
            if (moHandlerException.getAction().equals("ROLLBACK_TRANSACTION")) {
                BemLog.log(4, VALUE_STRING_COMMIT_AND_ROLLBACK_FAIL);
                BemLog.log(4, VALUE_STRING_PRINT_STACK + moHandlerException.toString());
                if (this.replaceEtmController.notifyShouldRollback()) {
                    this.rollbackToCancelCv();
                }
            }
            throw new BemException(VALUE_STRING_ROLLBACK_TO_PREV_CONFIG_EXC, (Throwable)moHandlerException);
        }
        return true;
    }

    private void clearOrderedMoOperations() {
        if (this.rbs != null) {
            MoHandlerCache moHandlerCache = (MoHandlerCache)this.rbs.getMoHandler();
            moHandlerCache.clearOrderMoOperations();
        }
    }

    @Override
    public synchronized void addObserver(Observer observer) {
        super.addObserver(observer);
        this.deleteEtm.addObserver(observer);
        MoHandler moHandler = this.rbs.getMoHandler();
        moHandler.addObserver(observer);
    }

    @Override
    public synchronized void deleteObserver(Observer observer) {
        super.deleteObserver(observer);
        this.deleteEtm.deleteObserver(observer);
        MoHandler moHandler = this.rbs.getMoHandler();
        moHandler.deleteObserver(observer);
    }

    @Override
    public synchronized void deleteObservers() {
        super.deleteObservers();
        this.deleteEtm.deleteObservers();
        MoHandler moHandler = this.rbs.getMoHandler();
        moHandler.deleteObservers();
    }

    public Rbs getRbs() {
        return this.rbs;
    }

    public void performReplaceEtm(String string, String string2) throws BemException {
        boolean bl = false;
        BemMo bemMo = this.rbs.getMoHandler().getMo(string);
        BemMo bemMo2 = DeleteEtmUtil.getParentMoOfType(bemMo, MimPlugInUnit.MOTYPENAME);
        if (this.replaceEtmController != null) {
            DeleteEtmUtil.orderLockOfMO(bemMo2);
            int n = this.rbs.getMoHandler().getTotalNoOfOrerredMoOperations();
            this.replaceEtmController.setTotalExpectedProgressReports(n);
            this.replaceEtmController.setUpProgressMonitor();
            this.commitOrderredMoOperations(false);
            this.replaceEtmController.cleanUpProgress();
            bl = DeleteEtmUtil.isListOfLockedMOEmpty();
            int n2 = this.replaceEtmController.notifyToChangeHardware(bl, string2);
            if (n2 == 2) {
                if (!bl) {
                    DeleteEtmUtil.orderUnLockOfMO(bemMo2);
                    this.commitOrderredMoOperations(true);
                }
                return;
            }
        }
        try {
            this.deleteEtm.prepareDelete(bemMo, 1);
            this.deleteEtm.prepareDeleteIpRoutingTable();
            this.deleteEtm.prepareDeleteAtmTrafficDescriptor();
            if (string2 != null) {
                BemMo bemMo3 = DeleteEtmUtil.getParentMoOfType(bemMo, MimSlot.MOTYPENAME);
                this.deleteEtm.prepareDelete(bemMo3, 0);
            }
        }
        catch (Exception exception) {
            this.clearOrderedMoOperations();
            if (!bl) {
                DeleteEtmUtil.orderUnLockOfMO(bemMo2);
                this.commitOrderredMoOperations(true);
            }
            throw new BemException(VALUE_STRING_PREP_DEL_ET_EXC, (Throwable)exception);
        }
        try {
            if (this.replaceEtmController != null) {
                int n = this.rbs.getMoHandler().getTotalNoOfOrerredMoOperations();
                this.replaceEtmController.setTotalExpectedProgressReports(n += 3);
                this.replaceEtmController.setUpProgressMonitor();
            }
            this.createCancelCV();
            this.commitOrderredMoOperations(true);
        }
        catch (BemException bemException) {
            throw new BemException(VALUE_STRING_ET_BOARD_STILL_IN_USE_INFO, (Throwable)bemException);
        }
        if (string2 != null && !string2.equals(VALUE_STRING_COMBO_BOX_NONE)) {
            try {
                BemMo bemMo4 = DeleteEtmUtil.getParentMoOfType(bemMo, MimSlot.MOTYPENAME);
                String string3 = "Creating new Etm Board";
                this.setChanged();
                this.notifyObservers(Nal.getFactory().getNameValue(string3, 1));
                CreateEtm.createEtmBoard(BemUtil.getRdn(bemMo4.getDN()), string2);
            }
            catch (BemException bemException) {
                throw new BemException(VALUE_STRING_CREATE_ET_EXC, (Throwable)bemException);
            }
        } else {
            this.createModifyCV();
        }
        if (this.replaceEtmController != null) {
            this.replaceEtmController.cleanUpProgress();
        }
        if (this.replaceEtmController != null) {
            this.replaceEtmController.notifyConfigurationSuccessful();
        }
    }

    private void createCancelCV() throws BemException {
        String string = "Creating Rollback CV";
        this.setChanged();
        this.notifyObservers(Nal.getFactory().getNameValue(string, 1));
        this.rollbackCV = new RollbackConfigurationVersionRI(this.rbs);
        try {
            this.rollbackCV.install("RollbackCVCreationPhase");
        }
        catch (BemException bemException) {
            throw new BemException(VALUE_STRING_ROLLBACK_CREATE_FAIL_EXC, (Throwable)bemException);
        }
    }

    private void createModifyCV() throws BemException {
        String string = "Creating Modified CV";
        this.setChanged();
        this.notifyObservers(Nal.getFactory().getNameValue(string, 1));
        ConfigurationVersionRI configurationVersionRI = new ConfigurationVersionRI(this.rbs, "Modify", "", "RBS EM", "Generated by Manage Transmission Link.");
        configurationVersionRI.install("ConfigurationVersionCreationPhase");
        this.rollbackCV = new RollbackConfigurationVersionRI(this.rbs);
        this.rollbackCV.install("RollbackCVDeletionPhase");
    }

    private void rollbackToCancelCv() throws BemException {
        try {
            MoHandler moHandler = this.rbs.getMoHandler();
            String string = this.rollbackCV.getCvName();
            if (string != null) {
                this.rollbackCV.install("RollbackCVSettingPhase");
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("restartRank", 1), Nal.getFactory().getNameValue("restartReason", 3), Nal.getFactory().getNameValue("restartInfo", RESTART_INFORMATION)};
                moHandler.action(moHandler.getRoot(), "manualRestart", nalNameValueArray);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(VALUE_STRING_USE_ROLLBACK_CV_FAILED_EXC, (Throwable)moHandlerException);
        }
    }

    public MoInstance getExchangeTerminalFromSlot(String string) throws BemException {
        this.rbs.openConfigurationItem("EtmBoardCI");
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        MoInstance moInstance = etmBoardProvider.getExchangeTerminalMoi(string);
        return moInstance;
    }

    public void discoverAtmLinks(String string) throws BemException {
        String string2;
        if (DuwUtil.hasDuw() && (string2 = BemUtil.extractRdnId(string, MimSlot.MOTYPENAME)).equals(DuwUtil.getSlotNumberForSecondaryDuw())) {
            throw new BemException("Manage transmission Link not supported for this slot");
        }
        this.deleteEtm.getSlotFor2ndAtmLink(string);
    }

    public Vector getAvailableEtmDisplayTypes() {
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        String[] stringArray = etmBoardProvider.getAllPossibleEtmBoards();
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            String string = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(stringArray[i]);
            vector.add(string);
        }
        return vector;
    }

    public HashMap<String, String> getExistingEtmNv(String string) throws BemException {
        String string2 = BemUtil.extractRdnId(string, MimSlot.MOTYPENAME);
        if (DuwUtil.hasDuw() && string2.equals(DuwUtil.getSlotNumberForSecondaryDuw())) {
            throw new BemException("Manage transmission Link not supported for this slot");
        }
        this.rbs.openConfigurationItem("EtmBoardCI");
        EtmBoardProvider etmBoardProvider = (EtmBoardProvider)this.rbs.getProvider(EtmBoardProvider.class);
        String string3 = etmBoardProvider.getTypeForExistingBoard(string2);
        string3 = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(string3);
        String string4 = this.deleteEtm.getSlotFor2ndAtmLink(string);
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (string4 != null) {
            String string5 = etmBoardProvider.getTypeForExistingBoard(string4);
            string5 = EtmBoardProvider.ETM_TYPE_MAPING.pseudo2display(string5);
            hashMap.put("slot1", string2);
            hashMap.put("type1", string3);
            hashMap.put("replacable1", "no");
            hashMap.put("slot2", string4);
            hashMap.put("type2", string5);
            hashMap.put("replacable2", "no");
        } else if (DuwUtil.hasDuw() || string3.equals("CBU")) {
            BemMo bemMo = this.rbs.getMoHandler().getMo(string);
            if (bemMo.getType().equals(MimExchangeTerminal.MOTYPENAME)) {
                hashMap.put("type1", string3 + "-" + "atm");
            } else if (bemMo.getType().equals(MimExchangeTerminalIp.MOTYPENAME)) {
                hashMap.put("type1", string3 + "-" + "ipV4");
            }
            hashMap.put("slot1", string2);
            hashMap.put("replacable1", "no");
        } else {
            hashMap.put("slot1", string2);
            hashMap.put("type1", string3);
            hashMap.put("replacable1", "yes");
        }
        return hashMap;
    }
}

