/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model;

import java.util.ResourceBundle;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.SwitchTuException;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.Tu;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.TuData;
import se.ericsson.wcdma.rbs.bem.application.applications.switchtu.model.TuModeller;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCbu;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSynchronization;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTuDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;
import se.ericsson.wcdma.rbs.bem.common.trace.BEMTrace;

public class TuModel
implements TuModeller {
    private static final int NO_ACTIVE_TU = 0;
    private BemMo myRbsSynchMo;
    private TuData[] myTus;
    private int myNoOfTus = 0;
    private BemMo[] tuDeviceGrpMos = new BemMoImpl[2];

    public TuModel() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuModel.class, "TuModel()");
        }
        this.collectTus();
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuModel.class, "TuModel()");
        }
    }

    private void collectTus() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuModel.class, "collectTus()");
        }
        this.tuDeviceGrpMos[0] = null;
        this.tuDeviceGrpMos[1] = null;
        try {
            BemMo bemMo = BemMoImpl.getRoot();
            BemMo[] bemMoArray = this.getChildren(bemMo, MimRbsSynchronization.MOTYPENAME, "");
            this.myRbsSynchMo = bemMoArray[0];
            BemMo bemMo2 = (BemMo)this.getAttribute(this.myRbsSynchMo, "plugInUnitRef1");
            BemMo bemMo3 = (BemMo)this.getAttribute(this.myRbsSynchMo, "plugInUnitRef2");
            this.tuDeviceGrpMos[0] = this.getDeviceGroup(bemMo2);
            this.tuDeviceGrpMos[1] = this.getDeviceGroup(bemMo3);
            this.storeNumberOfTus();
        }
        catch (Exception exception) {
            if (BEMTrace.ENABLED) {
                BEMTrace.exception(TuModel.class, "collectTus", exception);
            }
            BemLog.exceptionRaised("Switch TU failed ", exception);
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuModel.class, "collectTus");
        }
    }

    private void storeNumberOfTus() throws NalCmException {
        int n = this.getDistributedStatus();
        if (n > 0) {
            if (this.tuDeviceGrpMos[0] != null) {
                ++this.myNoOfTus;
            }
            if (this.tuDeviceGrpMos[1] != null) {
                ++this.myNoOfTus;
            }
        }
        this.myTus = new TuData[this.myNoOfTus];
        for (int i = 0; i < this.myNoOfTus; ++i) {
            if (this.tuDeviceGrpMos[i] == null) continue;
            String string = this.tuDeviceGrpMos[i].getId();
            int n2 = i + 1;
            String string2 = this.getSlotForTuDeviceGroup(this.tuDeviceGrpMos[i]);
            String string3 = this.tuDeviceGrpMos[i].getDN();
            this.myTus[i] = string3.indexOf("Cbu") > 0 ? new TuData(n2, string, string2, ":CBU") : new TuData(n2, string, string2, ":TUB");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.msg(TuModel.class, "colletTus()", "Number of Timing Units = " + this.myNoOfTus);
        }
        BemLog.logNotify("Number of Timing Units = " + this.myNoOfTus);
    }

    public void setLanguageBundle(ResourceBundle resourceBundle) {
    }

    public boolean switchTu() throws SwitchTuException {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuModel.class, "switchTu()");
        }
        boolean bl = false;
        NalTransaction nalTransaction = Nal.getFactory().createTransaction();
        try {
            this.myRbsSynchMo.action("switchMasterTu", new NalNameValue[0], nalTransaction);
            bl = true;
            nalTransaction.commit();
        }
        catch (Exception exception) {
            if (BEMTrace.ENABLED) {
                BEMTrace.exception(TuModel.class, "switchTu()", exception);
            }
            BemLog.exceptionRaised("Action switchDistributingTu failed", exception);
            try {
                nalTransaction.rollback("Failed switiching Tu:s!", exception);
            }
            catch (Exception exception2) {
                BemLog.exceptionRaised("Rollback failed", exception2);
            }
            throw new SwitchTuException(exception.toString(), exception);
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuModel.class, "switchTu()", bl);
        }
        return bl;
    }

    public Tu[] getTus() {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuModel.class, "getTus()");
        }
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuModel.class, "getTus()", this.myTus);
        }
        return this.myTus;
    }

    public int getDistributedStatus() throws NalCmException {
        if (BEMTrace.ENABLED) {
            BEMTrace.enter(TuModel.class, "getDistributedStatus()");
        }
        int n = 0;
        Integer n2 = (Integer)this.getAttribute(this.myRbsSynchMo, "masterTu");
        n = n2;
        if (BEMTrace.ENABLED) {
            BEMTrace.exit(TuModel.class, "getDistributedStatus()", n);
        }
        return n;
    }

    private BemMo getDeviceGroup(BemMo bemMo) throws NalCmException {
        String string;
        BemMo bemMo2 = null;
        if (bemMo != null && (string = bemMo.getDN()) != null) {
            boolean bl = bemMo.isExisting();
            if (bl) {
                BemLog.logNotify("TU PlugInUnitRef exists, piuMo = " + bemMo);
                BemMo[] bemMoArray = this.getChildren(bemMo, MimTuDeviceGroup.MOTYPENAME, "");
                if (bemMoArray.length == 0) {
                    bemMoArray = this.getChildren(bemMo, MimCbu.MOTYPENAME, "");
                }
                if (bemMoArray.length != 0) {
                    bemMo2 = bemMoArray[0];
                }
            } else if (BEMTrace.ENABLED) {
                BEMTrace.msg(TuModel.class, "collectTus()", "TU PlugInUnitRef exists, piuMo = " + bemMo);
            }
        }
        return bemMo2;
    }

    private BemMo[] getChildren(BemMo bemMo, String string, String string2) throws NalCmException {
        BemMo[] bemMoArray;
        NalTransaction nalTransaction = Nal.getFactory().createNullTransaction();
        try {
            bemMoArray = bemMo.getChildren(20, string, string2, nalTransaction);
            nalTransaction.commit();
        }
        catch (NalCmException nalCmException) {
            if (BEMTrace.ENABLED) {
                BEMTrace.exception(TuModel.class, "getChildren", nalCmException);
            }
            String string3 = "Failed to get children of MO:  " + bemMo.getDN() + " MO type: " + string;
            BemLog.exceptionRaised(string3, nalCmException);
            this.rollbackTransaction(nalTransaction, string3, nalCmException);
            throw nalCmException;
        }
        return bemMoArray;
    }

    private Object getAttribute(BemMo bemMo, String string) throws NalCmException {
        Object object;
        try {
            object = bemMo.getAttribute(string);
        }
        catch (NalCmException nalCmException) {
            if (BEMTrace.ENABLED) {
                BEMTrace.exception(TuModel.class, "getAttribute", nalCmException);
            }
            String string2 = "Failed to read attribute " + string;
            BemLog.exceptionRaised(string2, nalCmException);
            throw nalCmException;
        }
        return object;
    }

    public void rollbackTransaction(NalTransaction nalTransaction, String string, Throwable throwable) throws NalCmException {
        try {
            nalTransaction.rollback(string, throwable);
        }
        catch (NalCmException nalCmException) {
            BemLog.exceptionRaised("Rollback failed", nalCmException);
            throw nalCmException;
        }
    }

    private String getSlotForTuDeviceGroup(BemMo bemMo) {
        BemMo bemMo2 = bemMo.getParent();
        BemMo bemMo3 = bemMo2.getParent();
        String string = bemMo3.getId();
        return string;
    }
}

