/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.common.util;

import java.lang.reflect.Constructor;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.support.gui.EmasProgressMonitor;

public class InstallController
extends Thread
implements Installer {
    private boolean interrupted = false;
    private final ProgressReporter theProgressReporter;
    private int totalExpectedProgressReports = 0;
    private int progressReportsReceived = 0;
    private EmasProgressMonitor progressBar;
    private StringBuffer theInstallReport = null;
    private SubInstaller[] subControllers = null;
    private Class[] constructorParamTypes = new Class[]{Installer.class};
    private Object[] initArgs = new Object[]{this};
    private final Class[] subControllerClasses;

    public InstallController(ProgressReporter progressReporter, Class[] classArray) throws BemException {
        this.theProgressReporter = progressReporter;
        this.subControllerClasses = classArray;
    }

    public void start() {
        super.setName("BemApplInstallController");
        super.start();
    }

    public void run() {
        try {
            this.run_subcontrollers();
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised("An error has occured", bemException);
            this.theProgressReporter.reportError(bemException);
            return;
        }
    }

    public void run_subcontrollers() throws BemException {
        int n;
        int n2 = this.subControllers.length;
        this.totalExpectedProgressReports = 0;
        for (n = 0; n < n2; ++n) {
            this.totalExpectedProgressReports += this.subControllers[n].getTotalNoOfProgressReports();
        }
        this.progressReportsReceived = 0;
        this.progressBar = new EmasProgressMonitor(null, "Progress", "", "                                           ", this.progressReportsReceived, this.totalExpectedProgressReports);
        n = 0;
        try {
            for (n = 0; n < n2; ++n) {
                if (this.isInterrupted()) {
                    return;
                }
                String string = this.extractClassName(this.subControllers[n].getTheName());
                BemLogAndScriptUtil.getInstance().logStartConfigurationStep(string);
                boolean bl = this.subControllers[n].install();
                if (!bl) {
                    break;
                }
                BemLogAndScriptUtil.getInstance().logEndConfigurationStep();
            }
        }
        catch (BemException bemException) {
            String string = this.extractClassName(this.subControllers[n].getTheName());
            String string2 = string + ", " + this.subControllers[n].getTheDescription();
            bemException.setTheFunction(string2);
            throw bemException;
        }
        catch (Exception exception) {
            String string = this.subControllers[n].getTheName();
            String string3 = this.subControllers[n].getTheDescription();
            throw new BemException("InstallController-executing subcontroller", string3, null, string, exception);
        }
        finally {
            this.progressBar.close();
            BemLogAndScriptUtil.getInstance().logEndConfigurationProcedure();
            this.theProgressReporter.reportComplete(this.theInstallReport);
        }
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void reportProgress(String string, String string2) {
        this.reportProgress(string, string2, 1);
    }

    public void reportProgress(String string, String string2, int n) {
        this.theProgressReporter.reportProgress(string, string2);
        this.progressReportsReceived += n;
        this.progressBar.setNote(string2);
        this.progressBar.setProgress(this.progressReportsReceived);
    }

    public String getReportedProgress() {
        return this.progressBar.getNote();
    }

    public synchronized void stopExecution() {
        this.interrupted = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int initiate() throws BemException {
        int n = this.subControllerClasses.length;
        this.subControllers = new SubInstaller[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                Constructor constructor = this.subControllerClasses[i].getConstructor(this.constructorParamTypes);
                this.subControllers[i] = (SubInstaller)constructor.newInstance(this.initArgs);
                n3 = this.subControllers[i].getTotalNoOfProgressReports();
                n2 += n3;
                continue;
            }
            catch (Exception exception) {
                throw new BemException("InstallController", "Create/Run a subcontroller", null, null, exception);
            }
        }
        return n2;
    }

    public void extendInstallReport(StringBuffer stringBuffer) {
        if (this.theInstallReport == null) {
            this.theInstallReport = new StringBuffer();
        }
        this.theInstallReport.append("\n");
        this.theInstallReport.append(stringBuffer);
    }

    public void reportComplete() {
        this.theProgressReporter.reportComplete(this.theInstallReport);
        this.theInstallReport = new StringBuffer();
        this.theInstallReport.append("The line above will not be shown in target env.");
    }

    private String extractClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }
}

