/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.AccessLevel;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.nonautogenerated.MimAntennaBranchDef;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;

public class AntennaBranchRI
extends AbstractResourceItem {
    private static final String name = "AntennaBranch";
    private final String branch;
    private final String ldn;
    private final String prefix;
    private final int sectorNo;

    public AntennaBranchRI(Rbs rbs, String string, String string2, RadioEquipmentProvider radioEquipmentProvider, int n, String string3) {
        super(name, rbs, new String[]{"AntennaBranchCreationPhase"});
        this.ldn = string3;
        this.branch = string2;
        this.prefix = string;
        this.sectorNo = n;
    }

    public void install(String string) throws BemException {
        if (!string.equals("AntennaBranchCreationPhase")) {
            return;
        }
        this.updateAntennaBranch();
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AntennaBranchDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    private void updateAntennaBranch() throws BemException {
        AccessLevel accessLevel;
        Object object;
        boolean bl = false;
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        BemMo bemMo = this.getMo(this.ldn);
        if (bemMo.isExisting()) {
            bl = true;
        }
        if (!bl) {
            vector.add(Nal.getFactory().getNameValue("branchName", this.branch));
        }
        int n = this.getAntennaNumber();
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "mechanicalTilt" + (n > 1 ? String.valueOf(n) : ""));
        Integer n2 = Integer.valueOf((String)customerParameterServer.getValueMom());
        if ((n == 1 || n > 1 && SectorUtil.isRrus32WithRbb441d(this.rbs, this.sectorNo)) && this.rbs.isParameterSupported((String)(object = this.prefix + MessageFormat.format("SEQ{0}_", new Integer(1)) + "mechanicalTilt" + (n > 1 ? String.valueOf(n) : "")))) {
            accessLevel = this.rbs.getCustomerParameterObject((String)object);
            if (!bl && accessLevel.hasValueChanged() && !accessLevel.isDefault() && accessLevel.isValidValue()) {
                n2 = Integer.valueOf(accessLevel.getValue());
            }
        }
        if (!bl || customerParameterServer.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("mechanicalAntennaTilt", n2));
        }
        customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("antennaSupervisionBranch"));
        object = Integer.valueOf((String)customerParameterServer.getValueMom());
        if (!bl || customerParameterServer.hasValueChanged()) {
            vector.add(Nal.getFactory().getNameValue("antennaSupervisionThreshold", object));
        }
        accessLevel = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("currentLowSupervision_"));
        Integer n3 = (Integer)accessLevel.getValueMom();
        boolean bl2 = false;
        if (((CustomerParameter)accessLevel).getAccessLevel() == 1) {
            bl2 = true;
        }
        if (!(bl && !accessLevel.hasValueChanged() || bl2)) {
            vector.add(Nal.getFactory().getNameValue("lowCurrentSupervision", n3));
        }
        CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("fqBandHighEdgeBranch"));
        Integer n4 = Integer.valueOf((String)customerParameterServer2.getValueMom());
        if (!bl) {
            vector.add(Nal.getFactory().getNameValue("fqBandHighEdge", n4));
        }
        CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("fqBandLowEdgeBranch"));
        Integer n5 = Integer.valueOf((String)customerParameterServer3.getValueMom());
        if (!bl) {
            vector.add(Nal.getFactory().getNameValue("fqBandLowEdge", n5));
        }
        if (bl) {
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
            if (customerParameterServer3.hasValueChanged() || customerParameterServer2.hasValueChanged()) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("fqBandLowEdge", n5), Nal.getFactory().getNameValue("fqBandHighEdge", n4)};
                BemMo bemMo2 = this.getMo(this.ldn);
                this.action(bemMo2, "setFrequencyBand", nalNameValueArray);
            }
        } else {
            this.createMoIfNotExisting(this.ldn, vector);
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        if (bemMo.isExisting()) {
            int n = this.getAntennaNumber();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "mechanicalTilt" + (n > 1 ? String.valueOf(n) : ""));
            Object object = this.getAttribute(bemMo, "mechanicalAntennaTilt");
            customerParameterServer.setLoadedValue(object);
            String string = this.prefix + MessageFormat.format("SEQ{0}_", new Integer(1)) + "mechanicalTilt" + (n > 1 ? String.valueOf(n) : "");
            if (this.rbs.isParameterSupported(string)) {
                customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
                object = this.getAttribute(bemMo, "mechanicalAntennaTilt");
                customerParameterServer.setLoadedValue(object);
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("antennaSupervisionBranch"));
            object = this.getAttribute(bemMo, "antennaSupervisionThreshold");
            customerParameterServer.setLoadedValue(object);
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("fqBandHighEdgeBranch"));
            object = this.getAttribute(bemMo, "fqBandHighEdge");
            customerParameterServer.setLoadedValue(object);
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("fqBandLowEdgeBranch"));
            object = this.getAttribute(bemMo, "fqBandLowEdge");
            customerParameterServer.setLoadedValue(object);
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + this.getPseudoNameForBranch("currentLowSupervision_"));
            Object object2 = this.getAttribute(bemMo, "lowCurrentSupervision");
            customerParameterServer.setLoadedValue(object2);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "AntennaBranch: " + this.getLdn();
    }

    private String getPseudoNameForBranch(String string) throws BemException {
        int n = ServiceCommon.BRANCH_NAMES.length;
        String string2 = null;
        for (int i = 0; i < n; ++i) {
            if (this.branch.equals(ServiceCommon.BRANCH_NAMES[i])) {
                string2 = string + this.branch;
                break;
            }
            if (i != n - 1) continue;
            throw new BemException("branch is not initialized for " + this.ldn);
        }
        return string2;
    }

    private int getAntennaNumber() {
        int n = 1;
        if (this.branch.equals(MimAntennaBranchDef.BRANCH_C) || this.branch.equals(MimAntennaBranchDef.BRANCH_D)) {
            n = 2;
        } else if (this.branch.equals(MimAntennaBranchDef.BRANCH_E) || this.branch.equals(MimAntennaBranchDef.BRANCH_F)) {
            n = 3;
        }
        return n;
    }
}

