/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.check.ChecksumGenerator;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.java14.Java14String;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetProfile;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.rbs.bem.common.util.GitHelper;
import se.ericsson.wcdma.rbs.bem.common.util.WebServerUtil;

public class RetProfilesRI
extends AbstractResourceItem {
    public static final String name = "RET profiles";
    private static final String[] myInstallationPhases = new String[]{"RetProfileCreationPhase"};
    private Hashtable retProfilesTable;
    private Hashtable filePaths;
    private Properties xmlRetProfiles = new Properties();
    private Map xmlRetProfilesTable = new TreeMap();
    private Vector retProfilePseudoNames = new Vector();
    private Hashtable antennaTypeAndRetTypeTable = new Hashtable();
    private URL documentBaseUrl = null;
    private static final String ANTENNA_TYPE = "ANTENNA_TYPE";
    private static final String RET_TYPE = "RET_TYPE";
    private static final String MIN_TILT = "MIN_TILT";
    private static final String MAX_TILT = "MAX_TILT";
    private static final String RET_PARAM1 = "RET_PARAM1";
    private static final String RET_PARAM2 = "RET_PARAM2";
    private static final String RET_PARAM3 = "RET_PARAM3";
    private static final String RET_PARAM4 = "RET_PARAM4";
    private static final String RET_PARAM5 = "RET_PARAM5";
    private static final String RET_PARAM6 = "RET_PARAM6";
    private static final String RET_PARAM7 = "RET_PARAM7";
    private static final String RET_PARAM8 = "RET_PARAM8";
    private static final String CHECKSUM_VALUES = "CHECKSUM_VALUES";
    private HashMap loadedRetProfiles = null;
    private List loadedCustomerParameters = null;
    private StringBuffer installReport = new StringBuffer();
    private static final String ERROR_FILE_NOT_FOUND = "The properties file with RetProfiles could not be found";
    private static final String VALID_RETPROFILE_TAG = "RET_PROFILE_";
    private static final String DESIGN_ENV_FILE_PATH = GitHelper.getGitPath() + "rbs/sw/bsmss_1/bem/bemtest/bemtbcommon/env/retprofiles/";
    private static final String TARGET_ENV_FILE_PATH = "rbs/RET/";
    private static final String RET_PROFILES_FILE_NAME = "RetProfile.properties";
    private static final String RET_PROFILES_JAR_NAME = "bemretprofiles.jar";
    private static int currentRetProfileId = 1000;

    public RetProfilesRI(Rbs rbs) {
        super(name, rbs, myInstallationPhases);
    }

    public boolean isInstalled() throws BemException {
        BemMo bemMo = this.getMo(this.rbs.getEquipmentMoi().getLdn());
        BemMo[] bemMoArray = null;
        bemMoArray = this.getChildren(bemMo, 1, MimRetProfile.MOTYPENAME, "");
        return bemMoArray != null && bemMoArray.length != 0;
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            if (!BemLanguageHelp.getIsExecutedByDemoBem()) {
                if (this.rbs.getRbsStep().equals("STEP_SITE")) {
                    this.createRetProfilesFromPropertyFile();
                }
                this.createRetProfileFromXml();
            }
            this.createAretProfileAutomatically();
        }
    }

    private void createRetProfileFromXml() {
        Set set = this.xmlRetProfilesTable.keySet();
        for (Integer n : set) {
            Hashtable hashtable = (Hashtable)this.xmlRetProfilesTable.get(n);
            this.createRetProfile(n.toString(), hashtable, "", false);
        }
    }

    private void createRetProfilesFromPropertyFile() {
        if (this.retProfilesTable != null) {
            TreeSet treeSet = new TreeSet(new ProfileNumberComparator());
            treeSet.addAll(this.retProfilesTable.keySet());
            for (String string : treeSet) {
                String string2 = this.getProfileNumber(string);
                if (!string2.equals("-1")) {
                    Hashtable hashtable = (Hashtable)this.retProfilesTable.get(string);
                    String string3 = (String)this.filePaths.get(string);
                    this.createRetProfile(string2, hashtable, string3, true);
                    continue;
                }
                Nal.getLog().nalTrace(4, this.getClass(), "Warning -> Illegal RetProfile Number:" + string2 + "; Key:" + string);
            }
        }
    }

    public String getLdn() {
        return null;
    }

    public String getDisplayName() {
        return "RET profiles: ";
    }

    private void createRetProfile(String string, Hashtable hashtable, String string2, boolean bl) {
        try {
            String string3 = MessageFormat.format(this.rbs.getEquipmentMoi().getLdn() + "," + MimRetProfile.MOTYPENAME + "={0}", string);
            String string4 = this.extractConfiguredValue(ANTENNA_TYPE, hashtable);
            String string5 = this.extractConfiguredValue(RET_TYPE, hashtable);
            boolean bl2 = this.isRetprofileExistingOnNode(string4, string5);
            if (!bl2) {
                this.createRetProfileMO(hashtable, string4, string5, this.getMo(string3));
            } else if (bl) {
                String string6 = (String)this.loadedRetProfiles.get(this.getTypeKeyString(string4, string5));
                BemMo bemMo = this.getMo(string6);
                if (!this.doesMODataMatchInputFile(bemMo, hashtable)) {
                    this.delete(bemMo);
                    this.createRetProfileMO(hashtable, string4, string5, bemMo);
                }
            } else {
                String string7 = "Reason: Non-unique combination of the antenna type: " + string4 + " and the ret type: " + string5 + " among the available RetProfiles.";
                Nal.getLog().nalTrace(2, this.getClass(), "RetProfile " + string2 + " was not created due to: " + string7);
                this.appendInstallMessage("\n\nRetProfile  " + string2 + " was not created.");
                this.appendInstallMessage(string7);
            }
        }
        catch (BemException bemException) {
            Nal.getLog().nalTrace(4, this.getClass(), "Warning " + bemException.toString());
            String string8 = bemException.toString();
            this.appendInstallMessage("\n\nRetProfile  " + string2 + " was not created.");
            this.appendInstallMessage("Reason: " + string8);
        }
    }

    public void createAretProfileAutomatically() throws BemException {
        try {
            int[] nArray = this.rbs.getRadioEquipmentProvider().getEquippedSectors();
            for (int i = 0; i < nArray.length; ++i) {
                int n = this.rbs.getAntennaSystemProvider().getNumOfSectorAntennas(nArray[i]);
                String string = MessageFormat.format("S{0}_", new Integer(nArray[i]));
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                for (int j = 0; j < n; ++j) {
                    String string2 = BemUtil.getCustomerParameterName(string, "maxTilt", j + 1);
                    String string3 = BemUtil.getCustomerParameterName(string, "minTilt", j + 1);
                    String string4 = BemUtil.getCustomerParameterName(string, "typeOfRet", j + 1);
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                    CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(string3);
                    CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(string4);
                    if (!customerParameterServer.hasValueChanged() && !customerParameterServer2.hasValueChanged() || !((String)customerParameterServer3.getValueMom()).equals("ARETU") || Integer.valueOf((String)customerParameterServer.getValueMom()) == -1 || Integer.valueOf((String)customerParameterServer2.getValueMom()) == -1 || ((CustomerParameter)((Object)customerParameterServer2)).getAccessLevel() == 1 || ((CustomerParameter)((Object)customerParameterServer)).getAccessLevel() == 1 || this.alreadyHaveSameTiltsInOneSector(Integer.valueOf((String)customerParameterServer.getValueMom()), Integer.valueOf((String)customerParameterServer2.getValueMom()), arrayList, arrayList2)) continue;
                    String string5 = this.rbs.getEquipmentMoi().getLdn() + "," + MimRetProfile.MOTYPENAME + "=" + currentRetProfileId++;
                    String string6 = BemUtil.getCustomerParameterName(string, "antennaType", j + 1);
                    CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(string6);
                    Integer n2 = Integer.valueOf((String)customerParameterServer4.getValueMom());
                    Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
                    Integer[] integerArray = new Integer[]{new Integer(1), n2, Integer.valueOf((String)customerParameterServer.getValueMom()), Integer.valueOf((String)customerParameterServer2.getValueMom()), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0), new Integer(0)};
                    NalNameValue nalNameValue = Nal.getFactory().getNameValue("retType", integerArray[0]);
                    vector.add(nalNameValue);
                    NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("antennaType", integerArray[1]);
                    vector.add(nalNameValue2);
                    NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("maxTilt", integerArray[2]);
                    vector.add(nalNameValue3);
                    NalNameValue nalNameValue4 = Nal.getFactory().getNameValue("minTilt", integerArray[3]);
                    vector.add(nalNameValue4);
                    NalNameValue nalNameValue5 = Nal.getFactory().getNameValue("retParam1", integerArray[4]);
                    vector.add(nalNameValue5);
                    NalNameValue nalNameValue6 = Nal.getFactory().getNameValue("retParam2", integerArray[5]);
                    vector.add(nalNameValue6);
                    NalNameValue nalNameValue7 = Nal.getFactory().getNameValue("retParam3", integerArray[6]);
                    vector.add(nalNameValue7);
                    NalNameValue nalNameValue8 = Nal.getFactory().getNameValue("retParam4", integerArray[7]);
                    vector.add(nalNameValue8);
                    NalNameValue nalNameValue9 = Nal.getFactory().getNameValue("retParam5", integerArray[8]);
                    vector.add(nalNameValue9);
                    NalNameValue nalNameValue10 = Nal.getFactory().getNameValue("retParam6", integerArray[9]);
                    vector.add(nalNameValue10);
                    NalNameValue nalNameValue11 = Nal.getFactory().getNameValue("retParam7", integerArray[10]);
                    vector.add(nalNameValue11);
                    NalNameValue nalNameValue12 = Nal.getFactory().getNameValue("retParam8", integerArray[11]);
                    vector.add(nalNameValue12);
                    int[] nArray2 = new int[]{Integer.valueOf((String)customerParameterServer2.getValueMom()), Integer.valueOf((String)customerParameterServer.getValueMom()), 0, 0, 0, 0, 0, 0, 0, 0};
                    NalNameValue nalNameValue13 = Nal.getFactory().getNameValue("checkSum", new Integer(this.getRetProfileCheckSum(nArray2)));
                    vector.add(nalNameValue13);
                    this.rbs.getMoHandler().createMoIfNotExisting(string5, vector);
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            Nal.getLog().nalTrace(4, this.getClass(), "Warning " + moHandlerException.toString());
            this.appendInstallMessage("MoHandlerException - Error in createAretProfileAutomaticaly: " + moHandlerException.toString());
        }
    }

    private boolean alreadyHaveSameTiltsInOneSector(Integer n, Integer n2, ArrayList arrayList, ArrayList arrayList2) {
        for (int i = 0; i < arrayList.size(); ++i) {
            if (!n.equals(arrayList.get(i)) || !n2.equals(arrayList2.get(i))) continue;
            return true;
        }
        arrayList.add(n);
        arrayList2.add(n2);
        return false;
    }

    private int getRetProfileCheckSum(int[] nArray) {
        ChecksumGenerator checksumGenerator = new ChecksumGenerator(nArray);
        return checksumGenerator.generateCheckSum();
    }

    private void createRetProfileMO(Hashtable hashtable, String string, String string2, BemMo bemMo) throws BemException {
        BemMo bemMo2;
        String string3 = this.extractConfiguredValue(MIN_TILT, hashtable);
        String string4 = this.extractConfiguredValue(MAX_TILT, hashtable);
        String string5 = this.extractConfiguredValue(RET_PARAM1, hashtable);
        String string6 = this.extractConfiguredValue(RET_PARAM2, hashtable);
        String string7 = this.extractConfiguredValue(RET_PARAM3, hashtable);
        String string8 = this.extractConfiguredValue(RET_PARAM4, hashtable);
        String string9 = this.extractConfiguredValue(RET_PARAM5, hashtable);
        String string10 = this.extractConfiguredValue(RET_PARAM6, hashtable);
        String string11 = this.extractConfiguredValue(RET_PARAM7, hashtable);
        String string12 = this.extractConfiguredValue(RET_PARAM8, hashtable);
        String string13 = this.extractConfiguredValue(CHECKSUM_VALUES, hashtable);
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("antennaType", new Integer(string));
        vector.add(nalNameValue);
        NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("retType", new Integer(string2));
        vector.add(nalNameValue2);
        NalNameValue nalNameValue3 = Nal.getFactory().getNameValue("minTilt", new Integer(string3));
        vector.add(nalNameValue3);
        NalNameValue nalNameValue4 = Nal.getFactory().getNameValue("maxTilt", new Integer(string4));
        vector.add(nalNameValue4);
        NalNameValue nalNameValue5 = Nal.getFactory().getNameValue("retParam1", new Integer(string5));
        vector.add(nalNameValue5);
        NalNameValue nalNameValue6 = Nal.getFactory().getNameValue("retParam2", new Integer(string6));
        vector.add(nalNameValue6);
        NalNameValue nalNameValue7 = Nal.getFactory().getNameValue("retParam3", new Integer(string7));
        vector.add(nalNameValue7);
        NalNameValue nalNameValue8 = Nal.getFactory().getNameValue("retParam4", new Integer(string8));
        vector.add(nalNameValue8);
        NalNameValue nalNameValue9 = Nal.getFactory().getNameValue("retParam5", new Integer(string9));
        vector.add(nalNameValue9);
        NalNameValue nalNameValue10 = Nal.getFactory().getNameValue("retParam6", new Integer(string10));
        vector.add(nalNameValue10);
        NalNameValue nalNameValue11 = Nal.getFactory().getNameValue("retParam7", new Integer(string11));
        vector.add(nalNameValue11);
        NalNameValue nalNameValue12 = Nal.getFactory().getNameValue("retParam8", new Integer(string12));
        vector.add(nalNameValue12);
        NalNameValue nalNameValue13 = Nal.getFactory().getNameValue("checkSum", new Integer(string13));
        vector.add(nalNameValue13);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            BemMo bemMo3 = this.getParent(bemMo);
            String string14 = this.genLDN(bemMo3.getDN(), MimRetProfile.MOTYPENAME);
            bemMo2 = this.getMo(string14);
        } else {
            bemMo2 = bemMo;
        }
        this.create(bemMo2, vector);
        if (!this.loadedRetProfiles.containsKey(this.getTypeKeyString(string, string2))) {
            this.loadedRetProfiles.put(this.getTypeKeyString(string, string2), bemMo2.getDN());
        }
    }

    private boolean doesMODataMatchInputFile(BemMo bemMo, Hashtable hashtable) throws BemException {
        if (bemMo == null || hashtable == null) {
            return false;
        }
        String[] stringArray = new String[]{"antennaType", "retType", "minTilt", "maxTilt", "retParam1", "retParam2", "retParam3", "retParam4", "retParam5", "retParam6", "retParam7", "retParam8", "checkSum"};
        Object[] objectArray = this.getAttributes(bemMo, stringArray);
        return this.extractConfiguredValue(ANTENNA_TYPE, hashtable).equals(objectArray[0].toString()) && this.extractConfiguredValue(RET_TYPE, hashtable).equals(objectArray[1].toString()) && this.extractConfiguredValue(MIN_TILT, hashtable).equals(objectArray[2].toString()) && this.extractConfiguredValue(MAX_TILT, hashtable).equals(objectArray[3].toString()) && this.extractConfiguredValue(RET_PARAM1, hashtable).equals(objectArray[4].toString()) && this.extractConfiguredValue(RET_PARAM2, hashtable).equals(objectArray[5].toString()) && this.extractConfiguredValue(RET_PARAM3, hashtable).equals(objectArray[6].toString()) && this.extractConfiguredValue(RET_PARAM4, hashtable).equals(objectArray[7].toString()) && this.extractConfiguredValue(RET_PARAM5, hashtable).equals(objectArray[8].toString()) && this.extractConfiguredValue(RET_PARAM6, hashtable).equals(objectArray[9].toString()) && this.extractConfiguredValue(RET_PARAM7, hashtable).equals(objectArray[10].toString()) && this.extractConfiguredValue(RET_PARAM8, hashtable).equals(objectArray[11].toString()) && this.extractConfiguredValue(CHECKSUM_VALUES, hashtable).equals(objectArray[12].toString());
    }

    private String extractConfiguredValue(String string, Hashtable hashtable) throws BemException {
        String string2;
        String string3 = (String)hashtable.get(string);
        if (string3 == null) {
            throw new BemException("Attribute: " + string + " doesn't have a value! RetProfile can't be created!" + "\n Probable cause: A RetProfile that are referred in " + TARGET_ENV_FILE_PATH + RET_PROFILES_FILE_NAME + " is faulty or not found." + "\n Please check the RetProfiles.properties files");
        }
        string3 = string2 = string3.trim();
        return string3;
    }

    private String getProfileNumber(String string) {
        String string2 = "";
        StringTokenizer stringTokenizer = new StringTokenizer(string, "_");
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        try {
            Integer.parseInt(string2);
        }
        catch (NumberFormatException numberFormatException) {
            string2 = "-1";
        }
        return string2;
    }

    public Properties loadMainRetProperties() throws BemException {
        Properties properties = new Properties();
        String string = null;
        int n = BemLanguageHelp.getEnvironment();
        try {
            Object object;
            if (n == 1) {
                string = DESIGN_ENV_FILE_PATH + RET_PROFILES_FILE_NAME;
                this.documentBaseUrl = new URL("http:/127.0.0.1/" + DESIGN_ENV_FILE_PATH);
                object = new FileInputStream(new File(string));
                properties.load((InputStream)object);
                ((FileInputStream)object).close();
            } else {
                object = Nal.getFactory().getHost();
                if (object == null) {
                    throw new BemException("RetProfilesRI: Can not retrieve document base URL");
                }
                this.documentBaseUrl = new URL(WebServerUtil.getUrlPref() + (String)object + "/em/");
                string = this.documentBaseUrl.toString() + TARGET_ENV_FILE_PATH + RET_PROFILES_FILE_NAME;
                URL uRL = new URL(string);
                InputStream inputStream = uRL.openStream();
                properties.load(inputStream);
                inputStream.close();
            }
            boolean bl = this.checkPropertiesForTag(properties, VALID_RETPROFILE_TAG);
            if (!bl) {
                throw new FileNotFoundException("File not found or file faulty. Please check file: " + string);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println(ERROR_FILE_NOT_FOUND + ". " + fileNotFoundException.getMessage());
            return null;
        }
        catch (Exception exception) {
            System.out.println(ERROR_FILE_NOT_FOUND + exception.getMessage());
            exception.printStackTrace();
            throw new BemException("Unknown Error! " + exception);
        }
        return properties;
    }

    private Hashtable loadRetPropertiesFiles(Properties properties) {
        String string = "";
        Hashtable<String, Properties> hashtable = new Hashtable<String, Properties>();
        this.filePaths = new Hashtable();
        String string2 = null;
        Enumeration<Object> enumeration = properties.keys();
        while (enumeration.hasMoreElements()) {
            Serializable serializable;
            boolean bl;
            Properties properties2 = new Properties();
            String string3 = (String)enumeration.nextElement();
            string2 = (String)properties.get(string3);
            if (string2 == null) continue;
            int n = BemLanguageHelp.getEnvironment();
            if (n == 1) {
                string = "jar:file://" + DESIGN_ENV_FILE_PATH + RET_PROFILES_JAR_NAME + "!/" + string2;
                bl = this.loadRetPropertiesFile(string, properties2);
            } else {
                string = "jar:" + this.documentBaseUrl.toString() + TARGET_ENV_FILE_PATH + RET_PROFILES_JAR_NAME + "!/" + string2;
                bl = this.loadRetPropertiesFile(string, properties2);
                if (!bl) {
                    string = this.documentBaseUrl.toString() + TARGET_ENV_FILE_PATH + string2;
                    bl = this.loadRetPropertiesFile(string, properties2);
                }
            }
            if (bl) {
                serializable = properties2;
                hashtable.put(string3, (Properties)serializable);
                this.filePaths.put(string3, string);
                continue;
            }
            Nal.getLog().nalTrace(2, this.getClass(), "File not found or file faulty. Please check file: " + string);
            serializable = new StringBuffer("The file: " + string2 + " refered in\n" + this.documentBaseUrl.toString() + TARGET_ENV_FILE_PATH + RET_PROFILES_FILE_NAME + "\nis missing or faulty\n");
            this.appendInstallMessage("RetProfile  " + string2 + " was not created.");
            this.appendInstallMessage("Reason: " + ((StringBuffer)serializable).toString());
        }
        return hashtable;
    }

    private boolean loadRetPropertiesFile(String string, Properties properties) {
        boolean bl;
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            properties.load(inputStream);
            inputStream.close();
            bl = this.checkPropertiesForTag(properties, ANTENNA_TYPE);
        }
        catch (Exception exception) {
            Nal.getLog().nalTrace(2, this.getClass(), "Failed loading  " + string, exception);
            bl = false;
        }
        return bl;
    }

    private boolean checkPropertiesForTag(Properties properties, String string) {
        boolean bl;
        block1: {
            String string2;
            bl = false;
            if (properties == null) break block1;
            Enumeration<Object> enumeration = properties.keys();
            while (enumeration.hasMoreElements() && !(bl = (string2 = (String)enumeration.nextElement()).startsWith(string))) {
            }
        }
        return bl;
    }

    private boolean isRetprofileExistingOnNode(String string, String string2) throws BemException {
        if (this.loadedRetProfiles == null) {
            this.loadExistingRetProfiles();
        }
        String string3 = this.getTypeKeyString(string, string2);
        boolean bl = this.loadedRetProfiles.containsKey(string3);
        return bl;
    }

    public void loadExistingRetProfiles() throws BemException {
        this.loadedRetProfiles = new HashMap();
        BemMo bemMo = this.getMo(this.rbs.getEquipmentMoi().getLdn());
        BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimRetProfile.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                Integer n = (Integer)this.getAttribute(bemMo2, "antennaType");
                Integer n2 = (Integer)this.getAttribute(bemMo2, "retType");
                String string = this.getTypeKeyString(n.toString(), n2.toString());
                this.loadedRetProfiles.put(string, bemMo2.getDN());
            }
        }
    }

    private String getTypeKeyString(String string, String string2) {
        return string + "_" + string2;
    }

    public List getLoadedCustomerParameters() {
        return this.loadedCustomerParameters;
    }

    public void updateLoadedValues() throws BemException {
        this.loadExistingRetProfiles();
        this.loadRetProperties();
        this.createLoadedCustomerParameters();
    }

    private void createLoadedCustomerParameters() throws BemException {
        this.loadedCustomerParameters = new Vector();
        IntegerRange integerRange = new IntegerRange(Integer.MIN_VALUE, Integer.MAX_VALUE);
        Set set = this.loadedRetProfiles.keySet();
        for (String string : set) {
            Integer n;
            Integer n2;
            String string2 = (String)this.loadedRetProfiles.get(string);
            BemMo bemMo = this.getMo(string2);
            if (bemMo == null || this.isProfileInRetProperties(n2 = (Integer)this.getAttribute(bemMo, "antennaType"), n = (Integer)this.getAttribute(bemMo, "retType"))) continue;
            String string3 = VALID_RETPROFILE_TAG + bemMo.getId() + "_";
            String[] stringArray = new String[]{"antennaType", "retType", "minTilt", "maxTilt", "retParam1", "retParam2", "retParam3", "retParam4", "retParam5", "retParam6", "retParam7", "retParam8", "checkSum"};
            String[] stringArray2 = new String[]{"antennaType", "retType", "minTilt", "maxTilt", "retParam1", "retParam2", "retParam3", "retParam4", "retParam5", "retParam6", "retParam7", "retParam8", "checkSum"};
            if (stringArray.length != stringArray2.length) {
                throw new BemException("Variables should be of the same length");
            }
            for (int i = 0; i < stringArray.length; ++i) {
                Object object = this.getAttribute(bemMo, stringArray[i]);
                IntegerParameter integerParameter = new IntegerParameter(string3 + stringArray2[i], integerRange);
                integerParameter.setLoadedValue(object);
                this.loadedCustomerParameters.add(integerParameter);
            }
        }
    }

    private boolean isProfileInRetProperties(Integer n, Integer n2) throws BemException {
        boolean bl = false;
        if (this.retProfilesTable != null && n != null && n2 != null) {
            Set set = this.retProfilesTable.keySet();
            for (String string : set) {
                String string2 = this.getProfileNumber(string);
                if (string2.equals("-1")) continue;
                Hashtable hashtable = (Hashtable)this.retProfilesTable.get(string);
                String string3 = this.extractConfiguredValue(ANTENNA_TYPE, hashtable);
                String string4 = this.extractConfiguredValue(RET_TYPE, hashtable);
                if (!n.toString().equals(string3) || !n2.toString().equals(string4)) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    private void loadRetProperties() throws BemException {
        Properties properties = null;
        try {
            properties = this.loadMainRetProperties();
        }
        catch (BemException bemException) {
            Nal.getLog().nalTrace(4, this.getClass(), "Warning install() -> " + bemException.toString());
        }
        if (properties != null) {
            this.retProfilesTable = this.loadRetPropertiesFiles(properties);
        }
    }

    public void importRetProfiles(ServiceValue serviceValue) {
        Object object;
        Object object2;
        Object object3;
        String[] stringArray = serviceValue.getPseudoNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith(VALID_RETPROFILE_TAG)) continue;
            this.retProfilePseudoNames.add(stringArray[i]);
        }
        Iterator iterator = this.retProfilePseudoNames.iterator();
        TreeMap<Integer, Object> treeMap = new TreeMap<Integer, Object>();
        while (iterator.hasNext()) {
            object3 = (String)iterator.next();
            if (!((String)object3).startsWith(VALID_RETPROFILE_TAG)) continue;
            object2 = Java14String.split((String)object3, "_");
            object = VALID_RETPROFILE_TAG + (String)object2[2];
            if (treeMap.containsValue(object)) continue;
            System.out.println("fileNo = " + (String)object);
            treeMap.put(new Integer(this.getProfileNumber((String)object)), object);
        }
        object3 = treeMap.entrySet();
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            object2 = (Map.Entry)iterator.next();
            object = (Integer)object2.getKey();
            String string = (String)object2.getValue();
            String string2 = null;
            String string3 = null;
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            String string4 = serviceValue.getValue(string + "_" + "antennaType");
            hashtable.put(ANTENNA_TYPE, string4);
            string2 = string4;
            string4 = serviceValue.getValue(string + "_" + "retType");
            hashtable.put(RET_TYPE, string4);
            string3 = string4;
            string4 = serviceValue.getValue(string + "_" + "minTilt");
            hashtable.put(MIN_TILT, string4);
            string4 = serviceValue.getValue(string + "_" + "maxTilt");
            hashtable.put(MAX_TILT, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam1");
            hashtable.put(RET_PARAM1, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam2");
            hashtable.put(RET_PARAM2, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam3");
            hashtable.put(RET_PARAM3, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam4");
            hashtable.put(RET_PARAM4, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam5");
            hashtable.put(RET_PARAM5, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam6");
            hashtable.put(RET_PARAM6, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam7");
            hashtable.put(RET_PARAM7, string4);
            string4 = serviceValue.getValue(string + "_" + "retParam8");
            hashtable.put(RET_PARAM8, string4);
            string4 = serviceValue.getValue(string + "_" + "checkSum");
            hashtable.put(CHECKSUM_VALUES, string4);
            this.xmlRetProfilesTable.put(object, hashtable);
            String string5 = string2 + string3;
            this.antennaTypeAndRetTypeTable.put(string, string5);
            this.xmlRetProfiles.setProperty(string, DESIGN_ENV_FILE_PATH + "RetProfile" + string);
        }
    }

    private void appendInstallMessage(String string) {
        if (string != null && !string.equals("")) {
            if (this.installReport.toString().length() > 0) {
                this.installReport.append("\n");
            }
            this.installReport.append(string);
        }
    }

    public StringBuffer getInstallReport() {
        return this.installReport;
    }

    private class ProfileNumberComparator
    implements Comparator {
        private ProfileNumberComparator() {
        }

        public int compare(Object object, Object object2) {
            String string = RetProfilesRI.this.getProfileNumber((String)object);
            String string2 = RetProfilesRI.this.getProfileNumber((String)object2);
            Integer n = new Integer(string);
            Integer n2 = new Integer(string2);
            return n.compareTo(n2);
        }
    }
}

