/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.AIRUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRetDeviceSet;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class RetRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "RetuDeviceGroup";
    public static final String piuTypeProductName = "RETU";
    public static final int auType = 7;
    protected boolean isExternal = false;
    protected final int antNo;
    protected final String ldn;
    protected final String retLdn;
    protected final int sectorNumber;
    protected String prefix;
    private final String retTypeName;

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, String string4, int n2, String string5, String string6, int n3) {
        super(string4, rbs, n2, string5, string3);
        this.ldn = string;
        this.retLdn = string2;
        this.sectorNumber = n;
        this.prefix = SectorUtil.getSectorPrefix(this.sectorNumber);
        this.retTypeName = string6;
        this.antNo = n3;
    }

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, String string4, int n2, String string5, int n3) {
        this(rbs, n, string, string2, string3, string4, n2, string5, string5, n3);
    }

    public RetRI(Rbs rbs, int n, String string, String string2, String string3, int n2) {
        this(rbs, n, string, string2, string3, name, 7, piuTypeProductName, piuTypeProductName, n2);
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(this.getInstallationPhases(), string)) {
            Object object;
            CustomerParameter customerParameter;
            String string2 = SectorUtil.getSectorPrefix(this.sectorNumber);
            String string3 = BemUtil.getCustomerParameterName(string2, "typeOfRet", this.antNo);
            String string4 = this.rbs.getCustomerParameterObject(string3).getValue();
            boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
            String string5 = string2 + "uniqueHwId";
            if (this.antNo > 1) {
                string5 = string5 + this.antNo;
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string5)) != null && customerParameter.getAccessLevel() != 1 && customerParameter.hasValueChanged()) {
                object = customerParameter.getValue();
                super.setUniqueHwId((String)object);
            }
            if (!bl || bl && "ARETU_CASCADE".equals(string4) && this.isExternal) {
                super.install(string);
            }
            object = this.getParent(this.getMo(this.ldn));
            if (this.rbs.isModifyWiz() && bl && object.isExisting() && this.isAddRet4AIR()) {
                this.createRet(this.getUniqueHwId());
            }
        } else if (string.equals("ElectricalTiltSettingsAndVBWSettingsPhase")) {
            CustomerParameter customerParameter;
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "electricalTilt" + (this.antNo > 1 ? "" + this.antNo : ""));
            Integer n = Integer.valueOf((String)customerParameterServer.getValueMom());
            boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
            BemMo bemMo = this.getMo(this.retLdn);
            Object object = this.getAttribute(bemMo, "electricalAntennaTilt");
            if (Integer.parseInt(customerParameterServer.getValueMom().toString()) != Integer.parseInt(object.toString())) {
                this.setAttribute(bemMo, "electricalAntennaTilt", (Object)n);
            }
            String string6 = this.prefix;
            if (!this.isExternal && this.retTypeName.equalsIgnoreCase("ARETU_CASCADE")) {
                string6 = string6 + MessageFormat.format("SEQ{0}_", new Integer(1));
            }
            if ((customerParameter = this.rbs.getCustomerParameterObject(string6 = string6 + "electricalTilt" + (this.antNo > 1 ? "" + this.antNo : ""))) != null && customerParameter.getAccessLevel() != 1 && customerParameter.hasValueChanged()) {
                n = Integer.valueOf(customerParameter.getValue());
                this.setAttribute(bemMo, "electricalAntennaTilt", (Object)n);
            }
            if (this.retTypeName.equalsIgnoreCase("ARETU") && !bl) {
                CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "verticalBeamWidthMode", this.antNo));
                Integer n2 = Integer.valueOf(customerParameterServer2.getValueMom().toString());
                if (customerParameterServer2.hasValueChanged()) {
                    this.setAttribute(bemMo, "verticalBeamWidthMode", (Object)n2);
                }
            }
        } else if (string.equals("LockAIRPhase")) {
            if (this.rbs.isModifyWiz()) {
                BemMo bemMo = this.getParent(this.getMo(this.ldn));
                boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
                if (bl && bemMo.isExisting() && this.isAddRet4AIR()) {
                    this.lockMO(bemMo, "administrativeState");
                }
            }
        } else if (string.equals("UnlockAIRPhase") && this.rbs.isModifyWiz()) {
            BemMo bemMo = this.getParent(this.getMo(this.ldn));
            boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
            if (bl && bemMo.isExisting() && this.isAddRet4AIR()) {
                this.unlockMO(bemMo, "administrativeState");
            }
        }
    }

    private boolean isAddRet4AIR() throws BemException {
        String string = SectorUtil.getSectorPrefix(this.sectorNumber);
        String string2 = BemUtil.getCustomerParameterName(string, "typeOfRet", this.antNo);
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string2);
        return customerParameterImpl != null && customerParameterImpl.hasValueChanged() && !this.isExternal && "NONE".equals(customerParameterImpl.getLoadedValue()) && ("ARETU".equals(customerParameterImpl.getValue()) || "ARETU_CASCADE".equals(customerParameterImpl.getValue()));
    }

    private boolean isDelRet4AIR() throws BemException {
        String string = SectorUtil.getSectorPrefix(this.sectorNumber);
        String string2 = BemUtil.getCustomerParameterName(string, "typeOfRet", this.antNo);
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject(string2);
        return customerParameterImpl != null && customerParameterImpl.hasValueChanged() && !this.isExternal && ("ARETU".equals(customerParameterImpl.getLoadedValue()) || "ARETU_CASCADE".equals(customerParameterImpl.getLoadedValue())) && "NONE".equals(customerParameterImpl.getValue());
    }

    protected void createRet(String string) throws BemException {
        BemMo bemMo = this.getMo(this.ldn + "," + MimRetDeviceSet.MOTYPENAME + "=1");
        if (!bemMo.isExisting()) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>(0);
            vector.addElement(Nal.getFactory().getNameValue("RetDeviceSetId", bemMo.getId()));
            this.createMoIfNotExisting(bemMo.getDN(), vector);
            BemMo bemMo2 = this.getParent(this.getMo(this.ldn));
            if (string != null) {
                this.setAttribute(bemMo2, "uniqueHwId", (Object)string);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AuxUnitDbControlledDeletionPhase") || string.equals("AuxUnitAuxControlledDeletionPhase")) {
            BemMo bemMo = this.getMo(this.ldn);
            BemMo bemMo2 = this.getParent(bemMo);
            String string2 = this.ldn + "," + MimRetDeviceSet.MOTYPENAME + "=1";
            if (this.rbs.isModifyWiz() && this.isExisting(bemMo2) && (Integer)bemMo2.getAttribute("auType") == 26) {
                this.deleteMoIfExisting(string2);
            } else {
                super.uninstall(string);
            }
        } else if (string.equals("UnlockAIRPhase")) {
            boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
            BemMo bemMo = this.getParent(this.getMo(this.ldn));
            if (this.rbs.isModifyWiz() && bl && bemMo.isExisting() && this.isDelRet4AIR()) {
                this.unlockMO(bemMo, "administrativeState");
            }
        } else {
            super.uninstall(string);
        }
    }

    public void setLoadedValues() throws BemException {
        CustomerParameterServer customerParameterServer;
        Object object;
        BemMo bemMo = this.getMo(this.retLdn);
        BemMo bemMo2 = this.getMo(this.ldn).getParent();
        String string = this.antNo > 1 ? "" + this.antNo : "";
        String string2 = SectorUtil.getSectorPrefix(this.sectorNumber);
        CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(string2 + "configureRet");
        CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(string2 + "typeOfRet" + string);
        boolean bl = AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber);
        if (bemMo2.isExisting() && bemMo.isExisting()) {
            object = "NONE";
            object = !this.isExternal ? (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(this.sectorNumber) ? "ARETU" : (String)bemMo2.getAttribute("unitType")) : this.retTypeName;
            customerParameterServer3.setLoadedValue(object);
            if (!this.isExternal) {
                if (AIRUtil.getInstance(this.rbs).isNodeConfiguredWithAir(this.sectorNumber)) {
                    customerParameterServer2.setLoadedValue("YES");
                } else {
                    customerParameterServer2.setLoadedValue("NO");
                }
                if (AIRUtil.getInstance(this.rbs).isAirConfigured(this.sectorNumber)) {
                    ((CustomerParameterImpl)customerParameterServer2).setValue("NO");
                }
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "electricalTilt" + string);
            Object object2 = this.getAttribute(bemMo, "electricalAntennaTilt");
            customerParameterServer.setLoadedValue(object2);
            if (object.equals("ARETU") && !bl) {
                CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(this.prefix + "verticalBeamWidthMode" + string);
                Object object3 = this.getAttribute(bemMo, "verticalBeamWidthMode");
                customerParameterServer4.setLoadedValue(object3);
            }
        } else if (!this.isExternal) {
            customerParameterServer2.setLoadedValue("NO");
            ((CustomerParameterImpl)customerParameterServer3).setLoadedValue("NONE");
        }
        if (bemMo2.isExisting()) {
            customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "uniqueHwId" + string);
            object = this.getAttribute(bemMo2, "uniqueHwId");
            customerParameterServer.setLoadedValue(object);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "RetuDeviceGroup: " + this.getLdn();
    }
}

