/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimProgram;
import se.ericsson.wcdma.rbs.bem.common.mim.MimReliableProgramUniter;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwManagement;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchFabric;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchModule;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.HubSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.ReferringMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.RfSubrackMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class Rbs3CommonBasicCvRI
extends AbstractSwHandlingRI {
    public static final String NAME = "COMMON_BASIC_CV";
    private static final String[] myInstallationPhases = new String[]{"CommonBasicCvPhase"};
    private static final String MP_BB_SLOT = "20";
    private static final String MP_BBRF_SLOT = "4";
    private static final String SCB_SLOT = "1";
    private String mpBbPiuLdn;
    private String mpBbRfPiuLdn;
    private String scbBbPiuLdn;
    private String scbRfPiuLdn;
    private final boolean isBbRfSubrack;

    public Rbs3CommonBasicCvRI(Rbs rbs, boolean bl) throws BemException {
        super(NAME, rbs, myInstallationPhases);
        this.isBbRfSubrack = bl;
        this.setupMois();
    }

    private void setupMois() throws BemException {
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(new HubSubrackMoi(this.rbs.getEquipmentMoi()), MimSlot.MOTYPENAME, MP_BB_SLOT);
        SingleChildMoi singleChildMoi = new SingleChildMoi(fixedRdnMoi, MimPlugInUnit.MOTYPENAME, SCB_SLOT);
        this.mpBbPiuLdn = singleChildMoi.getLdn();
        FixedRdnMoi fixedRdnMoi2 = new FixedRdnMoi(new HubSubrackMoi(this.rbs.getEquipmentMoi()), MimSlot.MOTYPENAME, MP_BBRF_SLOT);
        SingleChildMoi singleChildMoi2 = new SingleChildMoi(fixedRdnMoi2, MimPlugInUnit.MOTYPENAME, SCB_SLOT);
        this.mpBbRfPiuLdn = singleChildMoi2.getLdn();
        FixedRdnMoi fixedRdnMoi3 = new FixedRdnMoi(new HubSubrackMoi(this.rbs.getEquipmentMoi()), MimSlot.MOTYPENAME, SCB_SLOT);
        SingleChildMoi singleChildMoi3 = new SingleChildMoi(fixedRdnMoi3, MimPlugInUnit.MOTYPENAME, SCB_SLOT);
        this.scbBbPiuLdn = singleChildMoi3.getLdn();
        FixedRdnMoi fixedRdnMoi4 = new FixedRdnMoi(new RfSubrackMoi(), MimSlot.MOTYPENAME, SCB_SLOT);
        SingleChildMoi singleChildMoi4 = new SingleChildMoi(fixedRdnMoi4, MimPlugInUnit.MOTYPENAME, SCB_SLOT);
        this.scbRfPiuLdn = singleChildMoi4.getLdn();
    }

    public void install(String string) throws BemException {
        if (string.equals("CommonBasicCvPhase")) {
            if (this.isBbRfSubrack) {
                this.configureForBbRfRbs();
            } else {
                this.configureForMacroRbs();
            }
        }
    }

    private void configureForMacroRbs() throws BemException {
        String string = this.mpBbPiuLdn;
        String string2 = this.mpBbRfPiuLdn;
        this.removeExtraMpIfExisting(string2);
        this.configureRpus(string, "admPassiveSlot");
    }

    private void configureForBbRfRbs() throws BemException {
        String string = this.mpBbRfPiuLdn;
        String string2 = this.scbBbPiuLdn;
        BemMo bemMo = this.getMo(string2);
        this.configureRpus(string, "admActiveSlot");
        String string3 = this.mpBbPiuLdn;
        this.removeExtraMpIfExisting(string3);
        this.removeScbAndRfSubrack();
        try {
            this.unlockMoIfNotUnlocked(bemMo);
        }
        catch (BemException bemException) {
            String string4 = bemException.getAction();
            String string5 = bemException.getAdditionalInfo();
            throw new BemException(string4, "configureForBbRfRbs()", string2, string5, bemException);
        }
    }

    private void removeExtraMpIfExisting(String string) throws BemException {
        String string2;
        boolean bl;
        BemMo bemMo = this.getMo(string);
        boolean bl2 = false;
        bl2 = this.isExisting(bemMo);
        if (bl2 && (bl = this.isPiuTypeConfigured(bemMo, string2 = "GPB"))) {
            this.removeSlotFromMpSwAllocation(bemMo);
            this.deletePiuAndProgramsIfExisting(bemMo);
        }
    }

    protected boolean isPiuTypeConfigured(BemMo bemMo, String string) throws BemException {
        boolean bl = false;
        BemMo bemMo2 = (BemMo)this.getAttribute(bemMo, "piuType");
        NalStruct nalStruct = (NalStruct)bemMo2.getAttribute("productData");
        String string2 = "";
        try {
            string2 = (String)nalStruct.getMemberValue("productName");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(this.getClass().getName(), "findPiuType()", null, "\tCould not find field: productName", noSuchFieldException);
        }
        if (string2 != null && string2.equals(string)) {
            bl = true;
        }
        return bl;
    }

    private void removeSlotFromMpSwAllocation(BemMo bemMo) throws BemException {
        String string = "RBS_GPB_Main";
        super.setRoleForSwAllocation(string);
        BemMo bemMo2 = super.getSwAllocationMOForRole(string);
        BemMo bemMo3 = bemMo.getParent();
        this.deleteSlotIfConnected(bemMo2, bemMo3);
    }

    protected void deletePiuAndProgramsIfExisting(BemMo bemMo) throws BemException {
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            this.lockMoIfNotLocked(bemMo);
            this.deleteChildrenOfAType(bemMo, MimProgram.MOTYPENAME);
            this.delete(bemMo);
        }
    }

    protected void lockMoIfNotLocked(BemMo bemMo) throws BemException {
        Integer n;
        boolean bl = this.isExisting(bemMo);
        if (bl && 1 == (n = (Integer)this.getAttribute(bemMo, "administrativeState"))) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
        }
    }

    protected void unlockMoIfNotUnlocked(BemMo bemMo) throws BemException {
        Integer n;
        boolean bl = this.isExisting(bemMo);
        if (bl && 0 == (n = (Integer)this.getAttribute(bemMo, "administrativeState"))) {
            this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
        }
    }

    private void deleteChildrenOfAType(BemMo bemMo, String string) throws BemException {
        BemMo[] bemMoArray;
        if (bemMo != null && (bemMoArray = this.getChildren(bemMo, 1, string, "")) != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo2 = bemMoArray[i];
                this.delete(bemMo2);
            }
        }
    }

    private void configureRpus(String string, String string2) throws BemException {
        BemMo bemMo = this.getMo(string);
        BemMo bemMo2 = bemMo.getParent();
        MoInstance moInstance = this.rbs.getRootMoi();
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimSwManagement.MOTYPENAME, SCB_SLOT);
        String string3 = singleChildMoi.getLdn();
        BemMo bemMo3 = this.getMo(string3);
        BemMo[] bemMoArray = this.getChildren(bemMo3, 1, MimReliableProgramUniter.MOTYPENAME, "");
        if (bemMoArray != null) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                BemMo bemMo4 = bemMoArray[i];
                boolean bl = this.isSlotConfiguredForRpu(bemMo4, bemMo2, string2);
                if (bl) continue;
                this.setAttribute(bemMo4, string2, (Object)bemMo2);
            }
        }
    }

    protected boolean isSlotConfiguredForRpu(BemMo bemMo, BemMo bemMo2, String string) throws BemException {
        boolean bl = false;
        BemMo bemMo3 = (BemMo)this.getAttribute(bemMo, string);
        if (bemMo3 != null && ((Object)bemMo3).equals(bemMo2)) {
            bl = true;
        }
        return bl;
    }

    private void removeScbAndRfSubrack() throws BemException {
        String string = new RfSubrackMoi().getLdn();
        BemMo bemMo = this.getMo(string);
        String string2 = this.scbRfPiuLdn;
        BemMo bemMo2 = this.getMo(string2);
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.getRbs().getRootMoi(), MimSwitchFabric.MOTYPENAME, SCB_SLOT);
        ReferringMoi referringMoi = new ReferringMoi(fixedRdnMoi, MimSwitchModule.MOTYPENAME, new RfSubrackMoi(), "switchModule", "2");
        String string3 = referringMoi.getLdn();
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            String string4 = "RBS_SCB";
            super.setRoleForSwAllocation(string4);
            BemMo bemMo3 = super.getSwAllocationMOForRole(string4);
            BemMo bemMo4 = bemMo2.getParent();
            this.deleteSlotIfConnected(bemMo3, bemMo4);
            boolean bl2 = this.isExisting(bemMo2);
            if (bl2) {
                this.deleteChildrenOfAType(bemMo2, MimSwitchCoreUnit.MOTYPENAME);
                this.deletePiuAndProgramsIfExisting(bemMo2);
            }
            this.deleteMoIfNotExisting(string);
            this.lockMoIfNotLocked(this.getMo(string3));
            this.deleteMoIfNotExisting(string3);
        }
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getLdn() {
        return "";
    }
}

