/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.duw;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimInterPiuLink;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMoImpl;

public class InterPiuLinkCableRI
extends AbstractResourceItem {
    private static final String[] myInstallationPhases = new String[]{"InterPiuLinkCreationPhase", "InterPiuLinkCreationPhase", "UnlockPhase", "LockPhase", "BasicCVCleanupPhase"};
    public static final String name = "InterPiuLinkCable";
    private final String ldn;

    public InterPiuLinkCableRI(Rbs rbs, MoInstance moInstance) throws BemException {
        super(name, rbs, myInstallationPhases);
        String string = "1";
        SingleChildMoi singleChildMoi = new SingleChildMoi(moInstance, MimInterPiuLink.MOTYPENAME, string);
        this.ldn = singleChildMoi.getLdn();
    }

    public void install(String string) throws BemException {
        if (DuwUtil.isMicroRbsDuw()) {
            return;
        }
        BemLog.log(7, "InterPiuLinkCable install()");
        if (string.equals("UnlockPhase")) {
            this.unlockInterPiuLinkCable();
        }
        if (string.equals("InterPiuLinkCreationPhase")) {
            this.createInterPiuLinkCable();
            this.unlockInterPiuLinkCable();
        }
        if (string.equals("BasicCVCleanupPhase") && !DuwUtil.hasDualDuws()) {
            this.lockInterPiuLinkCable();
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public void uninstall(String string) throws BemException {
        BemLog.log(7, "InterPiuLinkCable uninstall()");
        if (string.equals("LockPhase")) {
            BemLog.log(7, "InterPiuLinkCable lock()");
            if (!DuwUtil.hasDualDuws() && this.checkIfOperStateDisabled()) {
                this.lockInterPiuLinkCable();
            }
        }
        if (string.equals("InterPiuLinkCreationPhase")) {
            BemLog.log(7, "InterPiuLinkCable lock()");
            if (!DuwUtil.hasDualDuws() && this.checkIfOperStateDisabled()) {
                this.lockInterPiuLinkCable();
                this.deleteMoIfNotExisting(this.ldn);
            }
        }
    }

    private void unlockInterPiuLinkCable() throws BemException {
        BemMo bemMo = super.getMo(this.ldn);
        boolean bl = super.isExisting(bemMo);
        if (!bl) {
            return;
        }
        Integer n = (Integer)super.getAttribute(bemMo, "administrativeState");
        if (n != null && n == 0) {
            super.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
        }
    }

    private void lockInterPiuLinkCable() throws BemException {
        BemMo bemMo = super.getMo(this.ldn);
        boolean bl = super.isExisting(bemMo);
        if (!bl) {
            return;
        }
        Integer n = (Integer)super.getAttribute(bemMo, "administrativeState");
        if (n != null && n == 1) {
            super.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
        }
    }

    public boolean checkIfOperStateDisabled() throws BemException {
        BemMo bemMo = super.getMo(this.ldn);
        boolean bl = super.isExisting(bemMo);
        if (!bl) {
            return true;
        }
        Integer n = (Integer)super.getAttribute(bemMo, "operationalState");
        return n != null && n == 0;
    }

    private void createInterPiuLinkCable() throws BemException {
        Vector<NalNameValue> vector = new Vector<NalNameValue>();
        NalNameValue nalNameValue = null;
        String string = DuwUtil.getPrimaryDuwSlotLdn();
        BemMoImpl bemMoImpl = new BemMoImpl(string);
        nalNameValue = Nal.getFactory().getNameValue("primaryPiuSlot", bemMoImpl);
        vector.add(nalNameValue);
        String string2 = DuwUtil.getSecondaryDuwSlotLdn();
        BemMoImpl bemMoImpl2 = new BemMoImpl(string2);
        nalNameValue = Nal.getFactory().getNameValue("secondaryPiuSlot", bemMoImpl2);
        vector.add(nalNameValue);
        super.createMoIfNotExisting(this.ldn, vector);
    }

    public String getName() {
        return name;
    }

    public String getDisplayName() {
        return "InterPiuLinkCable: " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }
}

