/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.CustomParaName;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cellandcarrier.custparam.HsCodeResourceIdParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class RbsLocalCellRI
extends AbstractResourceItem {
    public static final String name = "RbsLocalCell";
    private static final String[] myInstallationPhases = new String[]{"RbsLocalCellCreationPhase", "CellHspaSettingPhase"};
    private boolean used = false;
    private BemMo rbsLocalCellMo;
    private String Ldn;
    private MoHandler theMoHandler = null;
    private int sectorNumber;
    private int carrierNumber;
    private BemMo[] carriersRefLoaded;
    private BemMo[] carriersRef;
    private String cellIdentity;
    private String operatingBand;
    private CustomParaName customerParameterNames;
    private static final int BITPOSITION_DEPENDENCY_FAILED = 10;
    private static final int BITPOSITION_DEPENDENCY_LOCKED = 9;
    private static final int BITPOSITION_NOT_INSTALLED = 7;
    private static final int BITPOSITION_DEPENDENCY = 5;
    private static final int BITPOSITION_CELLOFFLINE = 3;
    private static final int BITPOSITION_POWER_OFF = 2;
    private static final int BITPOSITION_FAILED = 1;
    private static final int BITPOSITION_IN_TEST = 0;

    public RbsLocalCellRI(Rbs rbs, int n, int n2, CustomParaName customParaName) {
        super(name, rbs, myInstallationPhases);
        this.theMoHandler = rbs.getMoHandler();
        this.sectorNumber = n;
        this.carrierNumber = n2;
        this.Ldn = BemLdn.LDN_NODEBFUNCTION + "," + MimRbsLocalCell.MOTYPENAME + "=" + "S" + n + "C" + n2;
        this.rbsLocalCellMo = this.theMoHandler.getMo(this.Ldn);
        this.customerParameterNames = customParaName;
    }

    public void install(String string) throws BemException {
        try {
            if (super.containsPhase(this.getInstallationPhases(), string)) {
                if (!this.used) {
                    return;
                }
                boolean bl = false;
                boolean bl2 = false;
                bl = this.rbsLocalCellMo.isExisting();
                if (string.equals("RbsLocalCellCreationPhase")) {
                    Vector<NalNameValue> vector = new Vector<NalNameValue>();
                    String string2 = this.customerParameterNames.getCellIdentityName(this.sectorNumber, this.carrierNumber);
                    String string3 = this.customerParameterNames.getCellRangePseudoName(this.sectorNumber, this.carrierNumber);
                    String string4 = this.customerParameterNames.getOperatingBandPseudoName(this.sectorNumber, this.carrierNumber);
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string2);
                    this.cellIdentity = (String)customerParameterServer.getValueMom();
                    if (!bl || customerParameterServer.hasValueChanged()) {
                        bl2 = true;
                        vector.add(Nal.getFactory().getNameValue("localCellId", Integer.valueOf(this.cellIdentity)));
                    }
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                    if (!bl || customerParameterServer.hasValueChanged()) {
                        bl2 = true;
                        vector.add(Nal.getFactory().getNameValue("cellRange", Integer.valueOf((String)customerParameterServer.getValueMom())));
                    }
                    if (!bl || this.checkIfCarriersRefChanged()) {
                        bl2 = true;
                        vector.add(Nal.getFactory().getNameValue("carriersRef", this.carriersRef));
                    }
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                    if (!bl || customerParameterServer.hasValueChanged()) {
                        bl2 = true;
                        vector.add(Nal.getFactory().getNameValue("operatingBand", Integer.valueOf((String)customerParameterServer.getValueMom())));
                    }
                    if (!bl) {
                        this.theMoHandler.createMoIfNotExisting(this.Ldn, vector);
                    } else if (bl2) {
                        this.theMoHandler.setAttributes(this.rbsLocalCellMo, vector);
                    }
                } else if (string.equals("CellHspaSettingPhase")) {
                    this.installHsCodeSourceId();
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("Failed setHsCodeResourceId for sectorNumber=" + this.sectorNumber + "  cellNumber=" + this.carrierNumber, (Throwable)moHandlerException);
        }
    }

    public void installHsCodeSourceId() throws BemException {
        String string = this.customerParameterNames.getHsCodeResourceIdPseudoName(this.sectorNumber, this.carrierNumber);
        HsCodeResourceIdParameter hsCodeResourceIdParameter = (HsCodeResourceIdParameter)this.rbs.getCustomerParameterObject(string);
        String string2 = this.rbs.getCustomerParameter("steeredHsAllocation");
        if (hsCodeResourceIdParameter.hasValueChanged() && hsCodeResourceIdParameter.getAccessLevel() != 1 && string2.equals("TRUE")) {
            try {
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                vector.add(Nal.getFactory().getNameValue("hsCodeResourceId", new Integer(this.rbs.getCustomerParameter(string))));
                this.theMoHandler.setAttributes(this.rbsLocalCellMo, vector);
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("Failed setHsCodeResourceId for sectorNumber=" + this.sectorNumber + "  cellNumber=" + this.carrierNumber, (Throwable)moHandlerException);
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("RbsLocalCellDeletionPhase")) {
            try {
                if (this.rbsLocalCellMo.isExisting()) {
                    this.theMoHandler.delete(this.rbsLocalCellMo);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.toString());
            }
            catch (NalCmException nalCmException) {
                throw new BemException(nalCmException.toString());
            }
        }
    }

    public String getDisplayName() {
        return "RbsLocalCell:";
    }

    public String getLdn() {
        return this.Ldn;
    }

    public boolean checkMoBitValue(BemMo bemMo, String string, int n) throws BemException {
        boolean bl;
        block6: {
            int n2 = 1;
            bl = false;
            MoHandler moHandler = this.rbs.getMoHandler();
            try {
                if (bemMo != null && bemMo.isExisting()) {
                    Object object = moHandler.getAttribute(bemMo, string);
                    if (object != null) {
                        int n3 = (Integer)object;
                        if (((n3 >>= n) & n2) == 1) {
                            bl = true;
                        }
                        break block6;
                    }
                    throw new BemException("Can not find the attribute" + string);
                }
                throw new BemException("The Mo = null or not existing!!!");
            }
            catch (NalCmException nalCmException) {
                throw new BemException("The Mo is not existing: " + nalCmException);
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("" + moHandlerException);
            }
        }
        return bl;
    }

    public boolean isCellOffline() throws BemException {
        boolean bl = false;
        int n = 3;
        int[] nArray = new int[]{7, 2, 0, 9, 5, 10, 1, n};
        if (this.isInstalled()) {
            for (int i = 0; i < nArray.length && !(bl = this.checkMoBitValue(this.rbsLocalCellMo, "availabilityStatus", nArray[i])); ++i) {
            }
        } else {
            bl = true;
        }
        return bl;
    }

    public void getLoadedValue() throws BemException {
        String string = null;
        if (this.rbsLocalCellMo.isExisting()) {
            try {
                this.used = true;
                this.cellIdentity = ((Integer)this.theMoHandler.getAttribute(this.rbsLocalCellMo, "localCellId")).toString();
                this.carriersRefLoaded = (BemMo[])this.theMoHandler.getAttribute(this.rbsLocalCellMo, "carriersRef");
                Integer n = (Integer)this.theMoHandler.getAttribute(this.rbsLocalCellMo, "hsCodeResourceId");
                this.operatingBand = ((Integer)this.theMoHandler.getAttribute(this.rbsLocalCellMo, "operatingBand")).toString();
                string = n != null ? n.toString() : MimRbsLocalCell.DEFAULT_HSCODERESOURCEID.toString();
                for (int i = 0; i < this.carriersRefLoaded.length; ++i) {
                    int n2 = SectorUtil.getSectorNumFromLdn(((Object)this.carriersRefLoaded[i]).toString());
                    int n3 = SectorUtil.getCarrierNumFromLdn(((Object)this.carriersRefLoaded[i]).toString());
                    if (n2 == -1 || n3 == -1) {
                        throw new BemException("Sector Number = " + n2 + " or Carrier Number" + n3 + " must be valid.");
                    }
                    String string2 = MessageFormat.format("S{0}_", new Integer(n2)) + MessageFormat.format("C{0}_", new Integer(n3));
                    String string3 = string2 + "cellIdentity";
                    CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                    customerParameterServer.setLoadedValue(this.cellIdentity);
                    String string4 = string2 + "operatingBand";
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                    customerParameterServer.setLoadedValue(this.operatingBand);
                    String string5 = string2 + "hsCodeResourceId";
                    customerParameterServer = this.rbs.getCustomerParameterServerObject(string5);
                    customerParameterServer.setLoadedValue(string);
                }
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException(moHandlerException.toString());
            }
            catch (NalCmException nalCmException) {
                throw new BemException(nalCmException.toString());
            }
        } else {
            this.used = false;
        }
    }

    public boolean checkIfCarriersRefChanged() {
        if (this.carriersRefLoaded == null && this.carriersRef != null || this.carriersRefLoaded != null && this.carriersRef != null && this.carriersRef.length != this.carriersRefLoaded.length) {
            return true;
        }
        for (int i = 0; i < this.carriersRef.length; ++i) {
            boolean bl = false;
            for (int j = 0; j < this.carriersRefLoaded.length; ++j) {
                if (!((Object)this.carriersRef[i]).equals(this.carriersRefLoaded[j])) continue;
                bl = true;
                break;
            }
            if (bl) continue;
            return true;
        }
        return false;
    }

    public void setCarriersRef(ArrayList arrayList) {
        this.carriersRef = arrayList.toArray(new BemMo[0]);
    }

    public void setUsed(boolean bl) {
        this.used = bl;
    }

    public boolean ifUsed() {
        return this.used;
    }

    public BemMo getRbsLocalCellMo() {
        return this.rbsLocalCellMo;
    }
}

