/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.AbstractAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.AlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.SauAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.ScuAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonalarm.SupAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSystemUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SauRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AlarmConfigurationProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.xalm.GenericAlarmManager;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimCabinet;
import se.ericsson.wcdma.rbs.bem.common.mim.MimHwUnit;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class CommonAlarmCI
extends AbstractConfigurationItem
implements AlarmConfigurationProvider,
CustomerParameterListener {
    public static final String name = "AlarmCI";
    public static final String SCU = "Scu";
    public static final String SAU = "Sau";
    public static final String SUP = "Sup";
    public static final String RRUW = "Rruw";
    public static final String IRU = "Iru";
    private static final int RRUW_MAX_NO_ALMDEVICES = 6;
    private static final int RRUW_MAX_NO_OUTDEVICES = 0;
    private static final int MAX_NO_OF_RRUW_PER_SECTOR = 2;
    private static final int IRU_MAX_NO_ALMDEVICES = 6;
    private static final int IRU_MAX_NO_OUTDEVICES = 0;
    private static final String ALREADY_OPEN = "CommonAlarmCI.open(): Already open";
    private static final String ALARMS_ONLY_AT_SITE = "Alarms must be configured at site for this RBS type";
    private static final String ALARMS_DELETE_NOT_SUPPOTED = "Alarms are already installed, and to delete Alarms is not supported";
    private static final String OPEN_EXCEPTION = "CommonAlarmCI.open() got exception=";
    private HashMap sauRI = new HashMap();
    private HashMap sauHwUnitMoi = new HashMap();
    private HashMap scuHwUnitMoi = new HashMap();
    private HashMap supHwUnitMoi = new HashMap();
    private MoInstance[] rruwDeviceGroupMoi;
    private MoInstance[] iruDeviceGroupMoi;
    private ArrayList cplist;
    private boolean isOpen = false;
    private HashMap configureSauParamMap = new HashMap();
    private HashMap configureScuParamMap = new HashMap();
    private HashMap configureSupParamMap = new HashMap();
    private HashMap configureScuMap = new HashMap();
    private HashMap configureSupMap = new HashMap();
    private final boolean siteOnly;
    private boolean rbsSupportsSau = false;
    private HashMap scuAlarmManagerMap = new HashMap();
    private HashMap sauAlarmManagerMap = new HashMap();
    private HashMap supAlarmManagerMap = new HashMap();
    private GenericAlarmManager[] rruwAlarmManager = new GenericAlarmManager[0];
    private GenericAlarmManager[] iruAlarmManager = new GenericAlarmManager[0];
    private String[] allowedValueNo = new String[]{"NO"};
    private EnumeratedRange allowedRangeNo = new EnumeratedRange(this.allowedValueNo);
    private ParameterRestriction restSauNoSupport = new ParameterRestriction("Configuration of SAU is not supported, when Support System Control = FALSE", this.allowedRangeNo, true);

    public CommonAlarmCI(Rbs rbs, boolean bl, boolean bl2) {
        super(rbs);
        this.siteOnly = bl;
        this.rbsSupportsSau = bl2;
    }

    public void setAlarmParent(MoInstance moInstance, String string) throws BemException {
        if (SAU.equalsIgnoreCase(string)) {
            this.sauHwUnitMoi.put(BemUtil.cabinetWithPDuw, moInstance);
        } else if (SCU.equalsIgnoreCase(string)) {
            this.scuHwUnitMoi.put(BemUtil.cabinetWithPDuw, moInstance);
        } else if (SUP.equalsIgnoreCase(string)) {
            this.supHwUnitMoi.put(BemUtil.cabinetWithPDuw, moInstance);
        }
    }

    public void setAlarmParent(MoInstance moInstance, String string, int n) throws BemException {
        String string2 = BemUtil.generateCabinetKey(n);
        if (SAU.equalsIgnoreCase(string)) {
            this.sauHwUnitMoi.put(string2, moInstance);
        } else if (SCU.equalsIgnoreCase(string)) {
            this.scuHwUnitMoi.put(string2, moInstance);
        } else if (SUP.equalsIgnoreCase(string)) {
            this.supHwUnitMoi.put(string2, moInstance);
        }
    }

    public void configureScu(int n, boolean bl) {
        String string = BemUtil.generateCabinetKey(n);
        this.configureScuMap.put(string, bl ? "YES" : "NO");
    }

    public void configureSup(int n, boolean bl) {
        String string = BemUtil.generateCabinetKey(n);
        this.configureSupMap.put(string, bl ? "YES" : "NO");
    }

    public boolean open() throws BemException {
        boolean bl = true;
        try {
            String string;
            int n;
            if (this.isOpen) {
                throw new BemException(ALREADY_OPEN);
            }
            this.createCustomerParameters();
            Iterator iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                n = Integer.parseInt(iterator.next().toString());
                string = BemUtil.generateCabinetKey(n);
                this.sauRI.put(string, new SauRI(this.rbs, String.valueOf(n)));
                this.setAlarmParent(this.createSauMoi(String.valueOf(n)), "SAU", n);
            }
            this.createSauManager();
            this.createScuManager();
            this.createSupManager();
            this.setRestrictions();
            this.updateLoadedValues();
            this.setListeners();
            iterator = this.rbs.getCabinetNumberList().iterator();
            while (iterator.hasNext()) {
                n = Integer.parseInt(iterator.next().toString());
                string = BemUtil.generateCabinetKey(n);
                this.addParameter((YesNoCustomerParameter)this.configureSauParamMap.get(string));
                this.addParameter((YesNoCustomerParameter)this.configureScuParamMap.get(string));
                this.addParameter((YesNoCustomerParameter)this.configureSupParamMap.get(string));
            }
            n = this.rbs.getMaxNumberOfSectors();
            this.rruwAlarmManager = new GenericAlarmManager[2 * n];
            this.rruwDeviceGroupMoi = new MoInstance[2 * n];
            this.iruAlarmManager = new GenericAlarmManager[n];
            this.iruDeviceGroupMoi = new MoInstance[n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                int n3 = i + 1;
                for (int j = 0; j < 2; ++j) {
                    int n4 = j + 1;
                    this.rruwAlarmManager[n2] = new GenericAlarmManager(this.rbs, this.rruwDeviceGroupMoi[n2], RRUW, 6, 0, n3, n4);
                    this.rruwDeviceGroupMoi[n2] = this.rruwAlarmManager[n2].getDeviceGroupMoi();
                    this.cplist = this.rruwAlarmManager[n2].getCustomerParametersForRruw();
                    this.addParametersFromCPList(this.cplist);
                    this.rruwAlarmManager[n2].createAlmdeviceRIs();
                    ++n2;
                }
                this.iruAlarmManager[i] = new GenericAlarmManager(this.rbs, this.iruDeviceGroupMoi[i], IRU, 6, 0, n3, 1);
                this.iruDeviceGroupMoi[i] = this.iruAlarmManager[i].getDeviceGroupMoi();
                this.cplist = this.iruAlarmManager[i].getCustomerParametersForIru();
                this.addParametersFromCPList(this.cplist);
                this.iruAlarmManager[i].createAlmdeviceRIs();
            }
            this.isOpen = true;
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException(OPEN_EXCEPTION + exception.toString());
        }
        return bl;
    }

    private void createSauManager() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            MoInstance moInstance = (MoInstance)this.sauHwUnitMoi.get(string);
            SauAlarmManager sauAlarmManager = new SauAlarmManager(this.rbs, moInstance, n);
            this.sauAlarmManagerMap.put(string, sauAlarmManager);
            this.cplist = sauAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            sauAlarmManager.createAlarmPortRIs();
            sauAlarmManager.createControlPortRIs();
        }
    }

    private MoInstance createSauMoi(String string) {
        String string2 = "SAU-" + string;
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimHwUnit.MOTYPENAME, string2);
        return fixedRdnMoi;
    }

    private void updateLoadedValues() throws BemException {
        Comparable comparable;
        Object object;
        for (Map.Entry object22 : this.sauRI.entrySet()) {
            Object n = object22.getKey();
            object = object22.getValue();
            boolean fixedRdnMoi = ((SauRI)object).isInstalled();
            comparable = (YesNoCustomerParameter)this.configureSauParamMap.get(n);
            if (fixedRdnMoi) {
                ((YesNoCustomerParameter)comparable).setLoadedValue("YES");
                continue;
            }
            ((YesNoCustomerParameter)comparable).setLoadedValue("NO");
        }
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            object = BemUtil.generateCabinetKey(n);
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.rbs.getEquipmentMoi(), MimCabinet.MOTYPENAME, String.valueOf(n));
            comparable = this.rbs.getMoHandler().getMo(fixedRdnMoi.getLdn());
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.configureScuParamMap.get(object);
            YesNoCustomerParameter yesNoCustomerParameter2 = (YesNoCustomerParameter)this.configureSupParamMap.get(object);
            String string = "NO";
            String string2 = "NO";
            if (comparable.isExisting()) {
                String string3;
                String string4 = (String)this.configureScuMap.get(object);
                if (null != string4) {
                    string = string4;
                }
                if (null != (string3 = (String)this.configureSupMap.get(object))) {
                    string2 = string3;
                }
            }
            yesNoCustomerParameter.setLoadedValue(string);
            yesNoCustomerParameter2.setLoadedValue(string2);
        }
    }

    private void setRestrictions() throws BemException {
        for (Map.Entry entry : this.sauRI.entrySet()) {
            ParameterRestriction parameterRestriction;
            Object k = entry.getKey();
            Object v = entry.getValue();
            boolean bl = ((SauRI)v).isInstalled();
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)this.configureSauParamMap.get(k);
            if (bl) {
                parameterRestriction = new ParameterRestriction(ALARMS_DELETE_NOT_SUPPOTED, new EnumeratedRange("YES"), true);
                yesNoCustomerParameter.addRestriction(parameterRestriction);
            } else if (this.siteOnly && this.rbs.isCabinetWiz()) {
                parameterRestriction = new ParameterRestriction(ALARMS_ONLY_AT_SITE, new EnumeratedRange("YES"), false);
                yesNoCustomerParameter.addRestriction(parameterRestriction);
            }
            yesNoCustomerParameter.addRestriction(this.restSauNoSupport);
        }
        this.restSauNoSupport.setActive(!this.isSauAvailable());
    }

    private boolean isSauAvailable() throws BemException {
        return this.rbsSupportsSau && this.rbs.getCustomerParameter("supportSystemControl").equals("TRUE");
    }

    private void createCustomerParameters() throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            YesNoCustomerParameter yesNoCustomerParameter = new YesNoCustomerParameter(string2 + "configureSau");
            this.configureSauParamMap.put(string, yesNoCustomerParameter);
            yesNoCustomerParameter.setDefaultValue("NO");
            YesNoCustomerParameter yesNoCustomerParameter2 = new YesNoCustomerParameter(string2 + "configureScu");
            this.configureScuParamMap.put(string, yesNoCustomerParameter2);
            yesNoCustomerParameter2.setDefaultValue("NO");
            YesNoCustomerParameter yesNoCustomerParameter3 = new YesNoCustomerParameter(string2 + "configureSup");
            this.configureSupParamMap.put(string, yesNoCustomerParameter3);
            yesNoCustomerParameter3.setDefaultValue("NO");
        }
    }

    private void addParametersFromCPList(ArrayList arrayList) {
        for (Object e : arrayList) {
            CustomerParameter customerParameter = (CustomerParameter)e;
            this.addParameter(customerParameter);
        }
    }

    public String getName() {
        return name;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, BemException, CustomerParameterException {
        String[] stringArray;
        Object object;
        Object object2;
        Object object3;
        Object object42;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        Object object11;
        Object object12;
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            object12 = (String)this.configureScuMap.get(string);
            if (null != object12) {
                object11 = (YesNoCustomerParameter)this.configureScuParamMap.get(string);
                ((YesNoCustomerParameter)object11).setValue((String)object12);
            }
            if (null == (object11 = (String)this.configureSupMap.get(string))) continue;
            object10 = (YesNoCustomerParameter)this.configureSupParamMap.get(string);
            ((YesNoCustomerParameter)object10).setValue((String)object11);
        }
        this.findInvalidPortIdCustomerParams(serviceValue);
        Iterator iterator2 = this.rbs.getCabinetNumberList().iterator();
        while (iterator2.hasNext()) {
            int n = Integer.parseInt(iterator2.next().toString());
            object12 = BemUtil.generateCabinetKey(n);
            object9 = (ScuAlarmManager)this.scuAlarmManagerMap.get(object12);
            if (object9 == null) continue;
            ((AbstractAlarmManager)object9).createAlarmPortRIs(serviceValue);
            ((AbstractAlarmManager)object9).createControlPortRIs(serviceValue);
            object11 = ((AbstractAlarmManager)object9).getAlarmPortCustomerParameters(serviceValue);
            object8 = ((ArrayList)object11).iterator();
            while (object8.hasNext()) {
                object7 = object8.next();
                object6 = (String[])object7;
                super.setCustomerParametersFromSV((String[])object6, serviceValue);
            }
            object10 = ((AbstractAlarmManager)object9).getControlPortCustomerParameters(serviceValue);
            object7 = ((ArrayList)object10).iterator();
            while (object7.hasNext()) {
                object6 = object7.next();
                object5 = (String[])object6;
                super.setCustomerParametersFromSV((String[])object5, serviceValue);
            }
        }
        Iterator iterator3 = this.rbs.getCabinetNumberList().iterator();
        while (iterator3.hasNext()) {
            int n = Integer.parseInt(iterator3.next().toString());
            object9 = BemUtil.generateCabinetKey(n);
            object8 = (SupAlarmManager)this.supAlarmManagerMap.get(object9);
            if (object8 == null) continue;
            ((AbstractAlarmManager)object8).createAlarmPortRIs();
            ((AbstractAlarmManager)object8).createControlPortRIs();
            object12 = ((AbstractAlarmManager)object8).getAlarmPortCustomerParameters(serviceValue);
            object7 = ((ArrayList)object12).iterator();
            while (object7.hasNext()) {
                object5 = object6 = object7.next();
                super.setCustomerParametersFromSV((String[])object5, serviceValue);
            }
            object11 = ((AbstractAlarmManager)object8).getControlPortCustomerParameters(serviceValue);
            object6 = ((ArrayList)object11).iterator();
            while (object6.hasNext()) {
                object42 = object5 = object6.next();
                super.setCustomerParametersFromSV((String[])object42, serviceValue);
            }
        }
        object12 = this.rbs.getCabinetNumberList().iterator();
        while (object12.hasNext()) {
            int n = Integer.parseInt(object12.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            object9 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            object8 = serviceValue.getValue((String)object9 + "configureSau");
            object7 = (YesNoCustomerParameter)this.configureSauParamMap.get(string);
            if (object8 != null && ((String)object8).length() > 0) {
                ((YesNoCustomerParameter)object7).setValue((String)object8);
            }
            if (object7 == null || ((CustomerParameterImpl)object7).getValue() == null || !((CustomerParameterImpl)object7).getValue().equals("YES") || (object42 = (SauAlarmManager)this.sauAlarmManagerMap.get(string)) == null) continue;
            ((AbstractAlarmManager)object42).createAlarmPortRIs(serviceValue);
            ((AbstractAlarmManager)object42).createControlPortRIs(serviceValue);
            object6 = ((AbstractAlarmManager)object42).getAlarmPortCustomerParameters(serviceValue);
            object3 = ((ArrayList)object6).iterator();
            while (object3.hasNext()) {
                object2 = object3.next();
                object = (String[])object2;
                super.setCustomerParametersFromSV((String[])object, serviceValue);
            }
            object5 = ((AbstractAlarmManager)object42).getControlPortCustomerParameters(serviceValue);
            object2 = ((ArrayList)object5).iterator();
            while (object2.hasNext()) {
                stringArray = object = object2.next();
                super.setCustomerParametersFromSV(stringArray, serviceValue);
            }
        }
        RadioEquipmentProvider radioEquipmentProvider = this.rbs.getRadioEquipmentProvider();
        object9 = radioEquipmentProvider.getRruwMois();
        object8 = new ArrayList();
        if (object9 != null && this.rruwDeviceGroupMoi != null) {
            int n;
            for (n = 0; n < object9.size(); ++n) {
                object6 = (MoInstance[])object9.get(n);
                if (object6 == null) continue;
                for (int i = 0; i < ((Object)object6).length; ++i) {
                    object8.add(object6[i]);
                }
            }
            for (n = 0; n < this.rruwDeviceGroupMoi.length; ++n) {
                object6 = this.rruwDeviceGroupMoi[n].getLdn();
                for (int i = 0; i < object8.size(); ++i) {
                    object42 = (MoInstance)object8.get(i);
                    object3 = ((MoInstance)object42).getLdn();
                    if (!((String)object6).equals(object3) || this.getRbs().getRbsStep().equals("STEP_CABINET")) continue;
                    ArrayList arrayList = this.rruwAlarmManager[n].getAlmDeviceCustomerParameters(serviceValue);
                    object2 = arrayList.iterator();
                    while (object2.hasNext()) {
                        stringArray = object = object2.next();
                        super.setCustomerParametersFromSV(stringArray, serviceValue);
                    }
                }
            }
        }
        if (null != this.iruDeviceGroupMoi && null != this.iruAlarmManager) {
            for (int i = 0; i < this.iruAlarmManager.length; ++i) {
                if (null == this.iruAlarmManager[i]) continue;
                ArrayList arrayList = this.iruAlarmManager[i].getAlmDeviceCustomerParameters(serviceValue);
                for (Object object42 : arrayList) {
                    this.setCustomerParametersFromSV((String[])object42, serviceValue);
                }
            }
        }
    }

    private void findInvalidPortIdCustomerParams(ServiceValue serviceValue) throws BemException {
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n = Integer.parseInt(iterator.next().toString());
            String string = BemUtil.generateCabinetKey(n);
            String string2 = PrefixUtil.getCabinetPrefix(String.valueOf(n));
            Vector vector = serviceValue.getAttributesStartingWith(string2 + SAU + "ExternalAlarm");
            Vector vector2 = serviceValue.getAttributesStartingWith(string2 + SAU + "ControlPort");
            SauAlarmManager sauAlarmManager = (SauAlarmManager)this.sauAlarmManagerMap.get(string);
            this.findInvalidPortIdCustomerParams(sauAlarmManager, vector, vector2, n, "SAU");
            Vector vector3 = serviceValue.getAttributesStartingWith(string2 + SCU + "ExternalAlarm");
            Vector vector4 = serviceValue.getAttributesStartingWith(string2 + SCU + "ControlPort");
            ScuAlarmManager scuAlarmManager = (ScuAlarmManager)this.scuAlarmManagerMap.get(string);
            this.findInvalidPortIdCustomerParams(scuAlarmManager, vector3, vector4, n, "SCU");
            Vector vector5 = serviceValue.getAttributesStartingWith(string2 + SUP + "ExternalAlarm");
            Vector vector6 = serviceValue.getAttributesStartingWith(string2 + SUP + "ControlPort");
            SupAlarmManager supAlarmManager = (SupAlarmManager)this.supAlarmManagerMap.get(string);
            this.findInvalidPortIdCustomerParams(supAlarmManager, vector5, vector6, n, "SUP");
        }
    }

    private void findInvalidPortIdCustomerParams(AbstractAlarmManager abstractAlarmManager, Vector vector, Vector vector2, int n, String string) throws BemException {
        if (vector.size() > 0 || vector2.size() > 0) {
            if (null != abstractAlarmManager) {
                if (abstractAlarmManager.getMaxNoOfAlarmPorts() <= 0 && vector.size() > 0) {
                    throw new BemException(string + " of Cabinet " + n + " doesn't support any alarm port.");
                }
                if (abstractAlarmManager.getMaxNoOfControlPorts() <= 0 && vector2.size() > 0) {
                    throw new BemException(string + " of Cabinet " + n + " doesn't support any control port.");
                }
                IntegerRange integerRange = new IntegerRange(1, abstractAlarmManager.getMaxNoOfAlarmPorts());
                ParameterRestriction parameterRestriction = new ParameterRestriction("Port Id out of range", integerRange, true);
                this.addRestrictionsOnPortIds(vector, this.rbs, integerRange, parameterRestriction);
                IntegerRange integerRange2 = new IntegerRange(1, abstractAlarmManager.getMaxNoOfControlPorts());
                ParameterRestriction parameterRestriction2 = new ParameterRestriction("Port Id out of range", integerRange2, true);
                this.addRestrictionsOnPortIds(vector2, this.rbs, integerRange2, parameterRestriction2);
            } else {
                throw new BemException("Cabinet " + n + " doesn't support " + string + "!");
            }
        }
    }

    private void addRestrictionsOnPortIds(Vector vector, Rbs rbs, IntegerRange integerRange, ParameterRestriction parameterRestriction) {
        for (int i = 0; i < vector.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            boolean bl = rbs.isParameterSupported(serviceNameValue.getPseudoName());
            if (bl || !serviceNameValue.getPseudoName().endsWith("portId")) continue;
            IntegerParameter integerParameter = new IntegerParameter(serviceNameValue.getPseudoName(), integerRange);
            integerParameter.setValue(serviceNameValue.getValueAsString());
            integerParameter.addRestriction(parameterRestriction);
            this.addParameter(integerParameter);
        }
    }

    public ArrayList getNeededRIs() throws BemException {
        int n;
        SauRI sauRI;
        Map.Entry entry3;
        ArrayList<SauRI> arrayList = new ArrayList<SauRI>();
        Iterator iterator = this.rbs.getCabinetNumberList().iterator();
        while (iterator.hasNext()) {
            int n2 = Integer.parseInt(iterator.next().toString());
            String object = BemUtil.generateCabinetKey(n2);
            entry3 = ((YesNoCustomerParameter)this.configureSauParamMap.get(object)).getValue();
            sauRI = (SauRI)this.sauRI.get(object);
            SauAlarmManager sauAlarmManager = (SauAlarmManager)this.sauAlarmManagerMap.get(object);
            if (!this.isSauAvailable() || !((String)((Object)entry3)).equals("YES") || PowerSystemUtil.isContainDelCabinetCp(this.rbs, n2)) continue;
            String string = PrefixUtil.getCabinetPrefix(String.valueOf(n2));
            if (this.rbs.isParameterSupported(string + "cabinetNumber") && this.rbs.isParameterSupported(string + "ecBusNumber")) {
                IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "cabinetNumber");
                IntegerParameter integerParameter2 = (IntegerParameter)this.rbs.getCustomerParameterObject(string + "ecBusNumber");
                if (!integerParameter.getValue().equals("##UNDEFINED")) {
                    if (integerParameter.getValue().equals(String.valueOf(1)) && integerParameter2.getValue().equals("##UNDEFINED")) {
                        sauRI.setEcBusNo4MulCab(String.valueOf(1));
                    } else {
                        sauRI.setEcBusNo4MulCab(integerParameter2.getValue());
                    }
                    sauRI.setReferredCabinetNumber(integerParameter.getValue());
                }
            }
            arrayList.add(sauRI);
            if (sauAlarmManager == null) continue;
            arrayList.addAll(sauAlarmManager.getNeededRIs());
        }
        if (this.rbs.getCustomerParameter("supportSystemControl").equals("TRUE")) {
            for (Map.Entry entry2 : this.scuAlarmManagerMap.entrySet()) {
                entry3 = entry2.getValue();
                if (entry3 == null) continue;
                arrayList.addAll(((ScuAlarmManager)((Object)entry3)).getNeededRIs());
            }
            for (Map.Entry entry3 : this.supAlarmManagerMap.entrySet()) {
                sauRI = entry3.getValue();
                if (sauRI == null) continue;
                arrayList.addAll(((SupAlarmManager)((Object)sauRI)).getNeededRIs());
            }
        }
        for (n = 0; n < this.rruwAlarmManager.length; ++n) {
            if (!this.rruwAlarmManager[n].configureAlarmForRruw()) continue;
            arrayList.addAll(this.rruwAlarmManager[n].getNeededRIs());
        }
        for (n = 0; n < this.iruAlarmManager.length; ++n) {
            if (!this.iruAlarmManager[n].configureAlarmForIru()) continue;
            arrayList.addAll(this.iruAlarmManager[n].getNeededRIs());
        }
        return arrayList;
    }

    public AlarmManager getAlarmManager(String string, int n) {
        String string2 = BemUtil.generateCabinetKey(n);
        if (string.endsWith(SAU)) {
            return (SauAlarmManager)this.sauAlarmManagerMap.get(string2);
        }
        if (string.endsWith(SCU)) {
            return (ScuAlarmManager)this.scuAlarmManagerMap.get(string2);
        }
        if (string.endsWith(SUP)) {
            return (SupAlarmManager)this.supAlarmManagerMap.get(string2);
        }
        return null;
    }

    public SauRI getSauRI(int n) {
        String string = BemUtil.generateCabinetKey(n);
        return (SauRI)this.sauRI.get(string);
    }

    public void updateSupManager() {
        for (Map.Entry entry : this.supAlarmManagerMap.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            ((SupAlarmManager)v).setHwUnitMoi((MoInstance)this.supHwUnitMoi.get(k));
        }
    }

    public void configureScu() {
    }

    public void configureSup() {
    }

    private void createScuManager() throws BemException {
        for (Map.Entry entry : this.scuHwUnitMoi.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            String string = BemUtil.generateCabinetNumberFromKey(k.toString());
            ScuAlarmManager scuAlarmManager = new ScuAlarmManager(this.rbs, (MoInstance)v, Integer.parseInt(string));
            this.scuAlarmManagerMap.put(k, scuAlarmManager);
            this.cplist = scuAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            scuAlarmManager.createAlarmPortRIs();
            scuAlarmManager.createControlPortRIs();
        }
    }

    private void createSupManager() throws BemException {
        for (Map.Entry entry : this.supHwUnitMoi.entrySet()) {
            Object k = entry.getKey();
            Object v = entry.getValue();
            if (v == null) continue;
            int n = Integer.parseInt(BemUtil.generateCabinetNumberFromKey(k.toString()));
            SupAlarmManager supAlarmManager = new SupAlarmManager(this.rbs, (MoInstance)v, n);
            this.supAlarmManagerMap.put(k, supAlarmManager);
            this.cplist = supAlarmManager.getCustomerParameters();
            this.addParametersFromCPList(this.cplist);
            supAlarmManager.createAlarmPortRIs();
            supAlarmManager.createControlPortRIs();
        }
    }

    void createParameters() throws Exception {
        this.createCustomerParameters();
    }

    boolean isConfigureScu(int n) {
        String string = BemUtil.generateCabinetKey(n);
        String string2 = (String)this.configureScuMap.get(string);
        return "YES".equals(string2);
    }

    boolean isConfigureSup(int n) {
        String string = BemUtil.generateCabinetKey(n);
        String string2 = (String)this.configureSupMap.get(string);
        return "YES".equals(string2);
    }

    void setManager(Object object) {
        if (object instanceof SauAlarmManager) {
            this.sauAlarmManagerMap.put(BemUtil.cabinetWithPDuw, (SauAlarmManager)object);
        } else if (object instanceof ScuAlarmManager) {
            this.scuAlarmManagerMap.put(BemUtil.cabinetWithPDuw, (ScuAlarmManager)object);
        } else if (object instanceof SupAlarmManager) {
            this.supAlarmManagerMap.put(BemUtil.cabinetWithPDuw, (SupAlarmManager)object);
        }
    }

    void setConfigureSauParameter(boolean bl) {
        ((YesNoCustomerParameter)this.configureSauParamMap.get(BemUtil.cabinetWithPDuw)).setValue(bl);
    }

    void setSauRi(SauRI sauRI) {
        this.sauRI.put(BemUtil.cabinetWithPDuw, sauRI);
    }

    MoInstance getSauMoi() {
        return (MoInstance)this.sauHwUnitMoi.get(BemUtil.cabinetWithPDuw);
    }

    MoInstance getScuMoi() {
        return (MoInstance)this.scuHwUnitMoi.get(BemUtil.cabinetWithPDuw);
    }

    MoInstance getSupMoi() {
        return (MoInstance)this.supHwUnitMoi.get(BemUtil.cabinetWithPDuw);
    }

    public void setConfigureAlarmForRruw(int n, boolean bl) throws BemException {
        for (int i = 0; i < this.rruwAlarmManager.length; ++i) {
            String string = this.rruwAlarmManager[i].getSectorNumber();
            if (!String.valueOf(n).equals(string)) continue;
            this.rruwAlarmManager[i].setConfiguredAlarm(bl);
        }
    }

    public void requestUnInitAlarms(int n, List list, Object object) throws BemException {
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)list.get(i);
            for (int j = 0; j < this.rruwAlarmManager.length; ++j) {
                String string2 = this.rruwAlarmManager[j].getDeviceGroupLdn();
                if (!string.equals(string2)) continue;
                this.rruwAlarmManager[j].saveAttributes();
            }
        }
    }

    private void setListeners() throws BemException {
        CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl");
        customerParameter.addCustomerParameterListener(this);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isValueChanged()) {
            String string = customerParameter.getName();
            String string2 = customerParameter.getValue();
            if (string.equals("supportSystemControl")) {
                this.restSauNoSupport.setActive(!this.rbsSupportsSau || !string2.equals("TRUE"));
            }
        }
    }
}

