/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipoveratm.custparam;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVplTp;

public class VpiParameter
extends IntegerParameter
implements CustomerParameterListener {
    private static final String RESTRICTION_REASON = "Not allowed VPI value";
    private static final String DEFAULT_VALUE = "1";
    private ParameterRestriction aRestriction = null;

    public VpiParameter(String string) throws BemException {
        this(string, new IntegerRange(MimVplTp.MIN_EXTERNALVPI, MimVplTp.MAX_EXTERNALVPI));
    }

    public VpiParameter(String string, IntegerRange integerRange) throws BemException {
        super(string, integerRange);
        this.setDefaultValue(DEFAULT_VALUE);
        this.createDefaultRestriction();
    }

    private void createDefaultRestriction() {
        this.aRestriction = new ParameterRestriction(RESTRICTION_REASON, super.getSupportedValueRange(), true);
        super.addRestriction(this.aRestriction);
        this.aRestriction.setActive(true);
    }

    public ParameterRestriction getRestriction() {
        return this.aRestriction;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if ((parameterEvent.isValueChanged() || parameterEvent.isRangeChanged()) && customerParameter instanceof VpiParameter) {
            ParameterRange parameterRange = customerParameter.getEnabledValueRange();
            String string = customerParameter.getValue();
            this.aRestriction.setRange(parameterRange, true);
            this.setValue(string);
        }
    }
}

