/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.provider.IpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSyncRef;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class IpSyncRefRI
extends AbstractResourceItem
implements IpSyncRef {
    public static final String name = "IpSyncRefRI";
    private static String[] phases = new String[]{"IpSyncRefCreationPhase"};
    private MoInstance ipAccesHostEtMoi;
    private MoInstance ipSyncRefMoi = null;
    private int rdnId = -1;
    private final List pseudoList = new ArrayList();

    public IpSyncRefRI(Rbs rbs, MoInstance moInstance, int n) throws BemException {
        super(name, rbs, phases);
        this.rdnId = n;
        List list = this.getCustomerParameters();
        for (CustomerParameter customerParameter : list) {
            this.pseudoList.add(customerParameter.getName());
        }
        if (moInstance != null) {
            this.ipAccesHostEtMoi = moInstance;
            this.initializeMois();
            this.initiateCPWithNodeValues();
        }
    }

    private void initializeMois() {
        this.ipSyncRefMoi = new FixedRdnMoi(this.ipAccesHostEtMoi, MimIpSyncRef.MOTYPENAME, String.valueOf(this.rdnId));
    }

    public void setIpAccessHostEtMoi(MoInstance moInstance) {
        this.ipAccesHostEtMoi = moInstance;
        this.initializeMois();
    }

    private void initiateCPWithNodeValues() throws BemException {
        String string = "";
        String string2 = this.ipSyncRefMoi.getLdn();
        boolean bl = this.isInstalled();
        if (bl) {
            BemMo bemMo = this.getMo(string2);
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string = customerParameterServer.getAttributeName();
                Object object = this.getAttribute(bemMo, string);
                customerParameterServer.setLoadedValue(object);
            }
        }
    }

    public boolean isInstalled() throws BemException {
        boolean bl = false;
        if (this.ipSyncRefMoi != null) {
            String string = this.ipSyncRefMoi.getLdn();
            BemMo bemMo = this.getMo(string);
            bl = this.isExisting(bemMo);
        }
        return bl;
    }

    private boolean isConfigured() throws BemException {
        boolean bl = false;
        for (String string : this.pseudoList) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            String string2 = customerParameter.getValue();
            if ("##UNDEFINED".equals(string2) || "".equals(string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public boolean shouldRiBeInstalled() throws BemException {
        boolean bl = false;
        if (this.isInstalled()) {
            for (String string : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                bl = bl2;
                break;
            }
        } else {
            bl = this.isConfigured();
        }
        return bl;
    }

    public void install(String string) throws BemException {
        if (string.equals("IpSyncRefCreationPhase")) {
            this.lockIpSyncRef();
            this.installIpSyncRef();
            this.unlockIpSyncRef();
        }
    }

    private void lockIpSyncRef() throws BemException {
        String string = this.ipSyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            for (String string2 : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                this.setAttribute(bemMo, "administrativeState", (Object)new Integer(0));
                break;
            }
        }
    }

    private void unlockIpSyncRef() throws BemException {
        String string = this.ipSyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isExisting(bemMo);
        if (bl) {
            for (String string2 : this.pseudoList) {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                boolean bl2 = customerParameter.hasValueChanged();
                if (!bl2) continue;
                this.setAttribute(bemMo, "administrativeState", (Object)new Integer(1));
                break;
            }
        }
    }

    private void installIpSyncRef() throws BemException {
        String string = this.ipSyncRefMoi.getLdn();
        BemMo bemMo = this.getMo(string);
        boolean bl = this.isInstalled();
        if (!bl) {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            String string2 = "administrativeState";
            Object object = new Integer(1);
            vector.add(Nal.getFactory().getNameValue(string2, object));
            for (String string3 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3);
                string2 = customerParameterServer.getAttributeName();
                object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string2, object));
            }
            this.create(bemMo, vector);
        } else {
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            for (String string4 : this.pseudoList) {
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string4);
                boolean bl2 = customerParameterServer.hasValueChanged();
                if (!bl2) continue;
                String string5 = customerParameterServer.getAttributeName();
                Object object = customerParameterServer.getValueMom();
                vector.add(Nal.getFactory().getNameValue(string5, object));
            }
            if (vector.size() > 0) {
                this.setAttributes(bemMo, vector);
            }
        }
    }

    public String getLdn() {
        return "";
    }

    public String getDisplayName() {
        return name;
    }

    public String getIpSyncRefId() {
        return String.valueOf(this.rdnId);
    }

    public String getIpSyncRefLdn() throws BemException {
        String string = "";
        if (this.ipSyncRefMoi != null) {
            string = this.ipSyncRefMoi.getLdn();
        }
        return string;
    }

    public MoInstance getMoi() {
        return this.ipSyncRefMoi;
    }

    private List getCustomerParameters() throws BemException {
        ArrayList<CustomerParameter> arrayList = new ArrayList<CustomerParameter>();
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_ntpServerIpAddress", new Integer(this.rdnId));
        arrayList.add(this.rbs.getCustomerParameterObject(string));
        return arrayList;
    }
}

