/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.BatteryRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.BatteryFuseSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs3.BfuNpuRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class BatteryManager {
    private Rbs rbs;
    private String cabinetPosition;
    private String subrackPosition;
    private int bfuSlot;
    private ArrayList listOfRIs;
    private boolean isBatterySupported;
    private boolean isBfSubrackMandatory;
    private BfuNpuRI bfuNpuRI;
    private BatteryRI batteryRI;
    private BatteryFuseSubrackRI batteryFuseSubrackRI;

    public BatteryManager(Rbs rbs, boolean bl, String string, String string2, int n) throws BemException {
        this.cabinetPosition = string;
        this.subrackPosition = string2;
        this.rbs = rbs;
        this.bfuSlot = n;
        this.isBatterySupported = bl;
        this.createRIs();
    }

    public BatteryManager(Rbs rbs, boolean bl, String string, String string2, int n, boolean bl2) throws BemException {
        this(rbs, bl, string, string2, n);
        this.isBfSubrackMandatory = bl2;
    }

    private void createRIs() throws BemException {
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        this.batteryFuseSubrackRI = new BatteryFuseSubrackRI(this.rbs, this.cabinetPosition, this.subrackPosition, moInstance);
        MoInstance moInstance2 = this.batteryFuseSubrackRI.getMoi();
        this.bfuNpuRI = new BfuNpuRI(this.rbs, moInstance2);
        this.batteryRI = new BatteryRI(this.rbs, moInstance);
        this.listOfRIs = new ArrayList(3);
        this.listOfRIs.add(this.batteryFuseSubrackRI);
        this.listOfRIs.add(this.bfuNpuRI);
        this.listOfRIs.add(this.batteryRI);
    }

    public ArrayList getRIsToBeInstalled(boolean bl, String string) throws BemException {
        ArrayList arrayList = new ArrayList(0);
        if (bl && this.isBatterySupported) {
            arrayList = this.listOfRIs;
        } else if (this.isBfSubrackMandatory) {
            arrayList.add(this.batteryFuseSubrackRI);
            arrayList.add(this.bfuNpuRI);
        }
        return arrayList;
    }

    public boolean isBatteryInstalled() throws BemException {
        boolean bl = this.batteryRI.isInstalled();
        return bl;
    }

    public String getBatteryCapacity() throws BemException {
        String string = this.batteryRI.getBatteryCapacity();
        return string;
    }

    public boolean isBatterySupported() {
        return this.isBatterySupported;
    }

    public int getBfuSlot() {
        return this.bfuSlot;
    }
}

