/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.IruRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RbsSubrackMoi;

public class RuwSubrackRI
extends AbstractRbsSubrackRI {
    private static final String name = "RuwSubrack";
    private AbstractDbControlledAuxillaryUnitRI[] boards;
    private MoInstance moi;
    private String ldn;
    private int firstPositionSlot;
    private boolean shouldCreateRuwRis = false;

    public RuwSubrackRI(Rbs rbs, int n, String string, String string2, int n2) throws BemException {
        this(rbs, n, string, string2, n2, true);
    }

    public RuwSubrackRI(Rbs rbs, int n, String string, String string2, int n2, boolean bl) throws BemException {
        super(name, rbs, n, string, string2);
        this.boards = new RuwRI[n];
        this.moi = new RbsSubrackMoi(new String[]{MimDeviceGroup.MOTYPENAME}, "1", true);
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        this.shouldCreateRuwRis = bl;
        if (bl) {
            for (int i = n2; i <= n; ++i) {
                this.createSlot(i, new RuwRI(rbs, this.moi, i));
            }
        }
    }

    public RuwSubrackRI(Rbs rbs, int n, String string, String string2, int n2, boolean bl, String string3) throws BemException {
        super(name, rbs, n, string, string2);
        if (string3.indexOf("RUW") != -1) {
            this.boards = new RuwRI[n];
            this.moi = new RbsSubrackMoi(new String[]{MimDeviceGroup.MOTYPENAME}, string3, true);
        } else {
            this.boards = new IruRI[n];
            this.moi = new RbsSubrackMoi(new String[]{MimRruDeviceGroup.MOTYPENAME}, string3, true);
        }
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        this.shouldCreateRuwRis = bl;
        if (bl) {
            for (int i = n2; i <= n; ++i) {
                if (string3.indexOf("RUW") != -1) {
                    this.createSlot(i, new RuwRI(rbs, this.moi, i));
                    continue;
                }
                this.createSlot(i, new IruRI(rbs, this.moi, i));
            }
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "RuwSubrack:" + this.ldn;
    }

    public RuwRI[] getSubRIs() {
        RuwRI[] ruwRIArray = new RuwRI[]{};
        if (this.shouldCreateRuwRis) {
            ruwRIArray = new RuwRI[this.boards.length - (this.firstPositionSlot - 1)];
            for (int i = 0; i < ruwRIArray.length; ++i) {
                ruwRIArray[i] = (RuwRI)this.boards[i + (this.firstPositionSlot - 1)];
            }
        }
        return ruwRIArray;
    }

    public RuwRI getSlot(int n) throws BemException {
        RuwRI ruwRI = null;
        if (this.shouldCreateRuwRis) {
            if (n < this.firstPositionSlot || n > this.getNoOfSlots()) {
                throw new BemException("RuwSubrack.getSlot() slot number out of range: " + n);
            }
            ruwRI = (RuwRI)this.boards[n - 1];
        }
        return ruwRI;
    }

    private void createSlot(int n, AbstractDbControlledAuxillaryUnitRI abstractDbControlledAuxillaryUnitRI) {
        this.boards[n - 1] = abstractDbControlledAuxillaryUnitRI;
    }

    public MoInstance getRuwSubrackMoi() {
        return this.moi;
    }
}

