/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.check.ConfigurationCheckReport;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.AntennaSystemProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CellAndCarrierProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.CpriProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.IsSharedWithExternalMeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.MixedModeRadioParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.DigitalBuildingBlockParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.ConsistencyChecker;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.CpriProviderImpl;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.DuwToDuwCpriCableManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.RbsLoader;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.atfmgmt.RadioEquipmentAtfNameManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.atfmgmt.RadioEquipmentAtfProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.hspamgmt.HspaResourcesManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.CreateSectorParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public abstract class AbstractDuwRadioEquipmentCI
extends AbstractConfigurationItem {
    private boolean isOpen;
    private SectorRI[] sectorRis;
    private int maxNoOfSectors;
    protected int startingSectorNumber;
    private SectorCustomerParameterManager scpm;
    private CreateSectorParameterManager cspm;
    private RbbManager rbbManager;
    private DbbManager dbbManager;
    private HspaResourcesManager hspaResourcesManager;
    private ModifyManager modifyManager;
    private CpriProvider cpriProvider;
    private boolean pantherHybridRbs;
    public static final String name = "RadioEquipmentCI";
    private static final String NO_CREATED_SECTORS_ERROR_MESSAGE = "At least one remote sector must be chosen on second DUW";
    private static final int DEFAULT_MAX_SUPPORTED_TX_BRANCHES_PER_CARRIER = 1;
    private Enumeration[] mixedModeRadioParam;
    private DigitalBuildingBlockParameter digitalBuildingBlockParameter;
    protected final String FIRST_SUBRACK_NAME = "1";
    protected final String SECOND_SUBRACK_NAME = "2";

    public AbstractDuwRadioEquipmentCI(Rbs rbs, int n) {
        this(rbs, n, 1);
    }

    public AbstractDuwRadioEquipmentCI(Rbs rbs, int n, int n2) {
        super(rbs);
        this.maxNoOfSectors = n;
        this.startingSectorNumber = n2;
        this.isOpen = false;
        this.pantherHybridRbs = rbs.isPantherHybridRbs();
    }

    public boolean open() throws BemException {
        if (!this.isOpen) {
            this.createSectorRis();
            this.createRadioSubrackResources();
            RadioEquipmentAtfNameManager radioEquipmentAtfNameManager = new RadioEquipmentAtfNameManager(this.maxNoOfSectors, this.startingSectorNumber);
            this.rbbManager = this.createRbbManager(radioEquipmentAtfNameManager);
            this.dbbManager = new DbbManager(this.rbs);
            this.scpm = this.setupSectorCustomerParameters(this.rbbManager);
            if (this.pantherHybridRbs) {
                this.cspm = this.setupCreatSectorCustomerParameters(this.rbbManager);
            }
            this.createDbbCustomerParameters();
            this.setDbbParameterRestriction();
            int n = this.getDuwSlotNumber();
            this.rbbManager.addSectorCustomerParameterManagerAfterInitialization(this.scpm);
            RadioEquipmentAtfProvider radioEquipmentAtfProvider = new RadioEquipmentAtfProvider(this.rbbManager, radioEquipmentAtfNameManager);
            this.hspaResourcesManager = new HspaResourcesManager(this, this.getDuwSlotArray());
            this.cpriProvider = new CpriProviderImpl(radioEquipmentAtfNameManager);
            this.rbs.registerProvider(this.rbbManager, n);
            this.updateLoadedValues();
            this.hspaResourcesManager.setParameterRestrictions();
            this.scpm.setCustomerParameterRestrictions();
            this.modifyManager = new ModifyManager(this, this.rbbManager, this.scpm, this.startingSectorNumber);
            this.rbs.registerProvider(this.hspaResourcesManager, n);
            this.rbs.registerAtfProvider(radioEquipmentAtfProvider, n);
            this.rbs.registerProvider(this.cpriProvider, n);
            this.rbs.registerProvider(this.rbbManager, n);
            this.checkConsistency(false);
            this.isOpen = true;
        }
        return this.isOpen;
    }

    public boolean open(ServiceValue serviceValue) throws BemException {
        boolean bl = this.open();
        if (bl) {
            this.setCustomerParameters(serviceValue);
        }
        return bl;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        List list;
        String[] stringArray = null;
        ArrayList arrayList = this.scpm.getAllCpPseudoNames();
        ArrayList arrayList2 = this.hspaResourcesManager.getAllCpPseudoNames();
        arrayList.addAll(arrayList2);
        if (this.pantherHybridRbs) {
            list = this.cspm.getAllCpPseudoNames();
            arrayList.addAll(list);
        }
        list = this.modifyManager.getAllCpPseudoNames();
        arrayList.addAll(list);
        arrayList.addAll(this.getDbbCpPseudoNames());
        arrayList.addAll(this.getMixModeRadioCpPseudoNames());
        arrayList.addAll(this.getIsSharedWithExternalMeCpPseudoNames());
        stringArray = arrayList.toArray(new String[0]);
        this.scpm.disableListeners();
        super.setCustomerParametersFromSV(stringArray, serviceValue);
        this.modifyManager.updateScpmIfAppropriate(serviceValue, this.scpm);
        this.scpm.enableListeners();
        if (this.isRadioEquipmentCustParamUpdated(stringArray)) {
            this.rbbManager.notifyThatRbbsMightBeChanged(this.scpm, true);
        }
        this.modifyManager.doModification();
        this.rbbManager.notifyRadioEquipmentListeners();
    }

    private boolean isRadioEquipmentCustParamUpdated(String[] stringArray) throws BemException {
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            if (this.excludeCustParam(string) || !customerParameter.hasValueChanged()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean excludeCustParam(String string) {
        String[] stringArray = new String[]{"mixedModeRadio", "needRuPositionAllocation"};
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.endsWith(stringArray[i])) continue;
            bl = true;
        }
        return bl;
    }

    public ArrayList getNeededRIs() throws BemException {
        int n;
        if (!this.isOpen) {
            throw new BemException("RadioEquipmentCI is not open.");
        }
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        RuwSubrackRI[] ruwSubrackRIArray = this.getNeededRuwSubrackRi();
        if (ruwSubrackRIArray != null) {
            for (int i = 0; i < ruwSubrackRIArray.length; ++i) {
                if (ruwSubrackRIArray[i] == null) continue;
                arrayList.add(ruwSubrackRIArray[i]);
            }
        }
        AbstractRbb[] abstractRbbArray = this.rbbManager.getRadioBuildingBlocks();
        for (n = 0; n < this.maxNoOfSectors; ++n) {
            List list = new ArrayList();
            int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
            if (abstractRbbArray[n] == null) continue;
            Object object = this.getCellAndCarrierProvider(n2);
            Object object2 = "0";
            if (object.isSingleBand(n)) {
                object2 = object.getSingleBandValue(n);
            }
            list = abstractRbbArray[n].getResourceItems(this.rbbManager, (String)object2);
            arrayList.addAll(list);
            object = abstractRbbArray[n].getRadioBuildingBlockMomValue();
            this.sectorRis[n].setRadioBuildingBlock((Integer)object);
            object2 = this.scpm.getLineRateMomValue(n);
            this.sectorRis[n].setLineRate((Integer)object2);
            this.sectorRis[n].setSectorConfiguration(this.getSectorConfiguration(n2));
            Boolean bl = this.getMixedModeRadioMomValue(n2);
            this.sectorRis[n].setMixedModeRadio(bl);
            arrayList.add(this.sectorRis[n]);
        }
        if (this.pantherHybridRbs) {
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                int n3 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
                if (!this.cspm.getCreateSector(n3) || !this.rbs.getRbsStep().equals("STEP_CABINET")) continue;
                arrayList.add(this.sectorRis[n]);
            }
        }
        List list = this.hspaResourcesManager.getAllHspaResourceItems();
        arrayList.addAll(list);
        if (!this.pantherHybridRbs) {
            List list2 = DuwToDuwCpriCableManager.getNeededRis(this.rbs);
            arrayList.addAll(list2);
        }
        return arrayList;
    }

    private RuwSubrackRI[] getNeededRuwSubrackRi() {
        return this.rbbManager.getRuwSubrackRI();
    }

    public List getRIsToUninstall() throws BemException {
        ArrayList arrayList = new ArrayList();
        List list = this.modifyManager.getRIsToUninstall();
        arrayList.addAll(list);
        if (this.getRbs().getRbsStep().equals("STEP_SITE") && this.rbbManager.getCarrierAllocationMode().equals("Flexible")) {
            int n;
            boolean bl = false;
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                if (this.getSectorRis()[n].isInstalled() || this.rbbManager.getRadioBuildingBlock(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber)) == null) continue;
                bl = true;
                break;
            }
            for (n = 0; n < this.maxNoOfSectors; ++n) {
                int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
                AbstractRbb abstractRbb = this.rbbManager.getRadioBuildingBlock(n2);
                if (!bl || !this.getSectorRis()[n].isInstalled() || abstractRbb == null) continue;
                abstractRbb = this.rbbManager.getLoadedRadioBuildingBlock(n2);
                int n3 = 0;
                if (this.getRbs().isPantherHybridRbs() && this.startingSectorNumber == 7) {
                    n3 = 1;
                }
                this.getRbs().getAntennaSystemProvider(n3).requestUninitAllBranches(n2);
                this.getRbs().getCellAndCarrierProvider(n3).requestUninitiateSector(n2, this);
                this.getRbs().getCellAndCarrierProvider(n3).requestInitiateSector(n2, this);
                arrayList.addAll(abstractRbb.getLoadedResourceItems());
            }
        }
        return arrayList;
    }

    public void checkConsistency() throws BemException {
        this.checkConsistency(true);
        this.checkSectors();
    }

    private void checkIsSharedWithExternalMeWhenRadioSharedBy(int[] nArray) throws BemException {
        for (int i = 0; i < nArray.length; ++i) {
            int n = nArray[i];
            AbstractRuRI[] abstractRuRIArray = this.rbbManager.getSectorRadioUnits(n);
            if (null == abstractRuRIArray || 0 == abstractRuRIArray.length) continue;
            for (int j = 0; j < abstractRuRIArray.length; ++j) {
                String string = MessageFormat.format("S{0}_", Integer.toString(n));
                IsSharedWithExternalMeParameter isSharedWithExternalMeParameter = (IsSharedWithExternalMeParameter)abstractRuRIArray[j].getIsSharedWithExternalMeCp();
                String string2 = string + "radioSharedBySector";
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string2);
                String string3 = customerParameter.getValue();
                if (string3 == null || string3.equals("") || string3.equals("##UNDEFINED")) continue;
                int n2 = Integer.valueOf(string3);
                if (abstractRuRIArray.length != 1 || !"FALSE".equals(isSharedWithExternalMeParameter.getValue())) continue;
                throw new BemException(isSharedWithExternalMeParameter.getName() + " should be TRUE since sector: " + n + " is radio shared by with sector: " + n2 + " .");
            }
        }
    }

    private void checkSectors() throws BemException {
        boolean bl = false;
        if (this.pantherHybridRbs && this.rbs.getRbsStep().equals("STEP_CABINET")) {
            int n;
            for (int i = 0; i < this.maxNoOfSectors && !(bl = this.cspm.getCreateSector(n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber))); ++i) {
            }
            if (!bl) {
                throw new BemException(NO_CREATED_SECTORS_ERROR_MESSAGE);
            }
        }
    }

    public void checkConsistency(boolean bl) throws BemException {
        super.checkConsistency();
        if (bl && this.rbs.isPantherHybridRbs() && this.rbs.getRbsStep().equals("STEP_SITE")) {
            for (int i = 0; i < this.maxNoOfSectors; ++i) {
                int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
                SectorRI[] sectorRIArray = this.getSectorRis();
                if (!sectorRIArray[i].isInstalled() || !this.scpm.getRbbNameForSector(n).equals("")) continue;
                throw new BemException("Sector number " + n + " must be configed.");
            }
        }
        ConsistencyChecker.checkConsistency(this.rbs, this.scpm, this.rbbManager, this.cpriProvider, this.hspaResourcesManager, this.modifyManager, this.maxNoOfSectors, this.startingSectorNumber, bl);
        this.rbbManager.notifyRadioEquipmentListeners();
    }

    public AntennaSystemProvider getAntennaSystemProvider() throws BemException {
        AntennaSystemProvider antennaSystemProvider = null;
        try {
            antennaSystemProvider = this.rbs.getAntennaSystemProvider(this.getDuwSlotNumber());
        }
        catch (Exception exception) {
            throw new BemException("getAntennaSystemProvider()", "AntennaSystemCI", (Throwable)exception);
        }
        return antennaSystemProvider;
    }

    public CellAndCarrierProvider getCellAndCarrierProvider(int n) throws BemException {
        CellAndCarrierProvider cellAndCarrierProvider = null;
        int n2 = 0;
        if (this.rbs.isPantherHybridRbs() && n >= 7) {
            n2 = 1;
        }
        cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider(n2);
        return cellAndCarrierProvider;
    }

    public boolean isAntennaSystemProviderOpened() {
        return this.rbs.isAntennaSystemProviderOpen(this.getDuwSlotNumber());
    }

    public ConfigurationCheckReport checkConfiguration() throws BemException {
        ConfigurationCheckReport configurationCheckReport = new ConfigurationCheckReport();
        return configurationCheckReport;
    }

    protected int getMaxNoOfSectors() {
        return this.maxNoOfSectors;
    }

    private void createSectorRis() throws BemException {
        this.sectorRis = new SectorRI[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string = SectorUtil.getSectorLdn(n);
            this.sectorRis[i] = new SectorRI(this.rbs, string, n);
        }
    }

    protected void updateLoadedValues() throws BemException {
        RbsLoader.getInstance().updateLoadedValues(this, this.rbbManager, this.scpm, this.hspaResourcesManager);
        this.rbbManager.verifyThatAllRisAreInstalled();
        this.setMixedModeRadioLoadedValues();
        this.setIsSharedWithExternalMeLoadedValues();
        this.setDbbLoadedValue();
    }

    public String getName() {
        return name;
    }

    protected int getDuwSlotNumber() {
        if (this.startingSectorNumber == 7) {
            return 1;
        }
        return 0;
    }

    private int[] getDuwSlotArray() throws BemException {
        int[] nArray = this.rbs.isPantherHybridRbs() && this.startingSectorNumber == 7 ? new int[]{1} : (DuwUtil.hasDualDuws() && !this.rbs.isPantherHybridRbs() ? new int[]{0, 1} : new int[]{0});
        return nArray;
    }

    private CreateSectorParameterManager setupCreatSectorCustomerParameters(RbbManager rbbManager) throws BemException {
        CreateSectorParameterManager createSectorParameterManager = new CreateSectorParameterManager(this, rbbManager, this.maxNoOfSectors, this.startingSectorNumber);
        return createSectorParameterManager;
    }

    public int getStartingSectorNumber() {
        return this.startingSectorNumber;
    }

    public SectorRI[] getSectorRis() {
        return this.sectorRis;
    }

    protected abstract void createRadioSubrackResources() throws BemException;

    protected abstract RbbManager createRbbManager(RadioEquipmentAtfNameManager var1) throws BemException;

    protected abstract SectorCustomerParameterManager setupSectorCustomerParameters(RbbManager var1) throws BemException;

    public int getMaxNumberOfSupportedCarrierTxBranches(int n) {
        return 1;
    }

    public int[] getSectorConfiguration(int n) throws BemException {
        Integer n2;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n3 = 0;
        if (this.rbs.isPantherHybridRbs() && n >= 7) {
            n3 = 1;
        }
        CellAndCarrierProvider cellAndCarrierProvider = this.rbs.getCellAndCarrierProvider(n3);
        int n4 = cellAndCarrierProvider.getConfiguredNumberOfRxBranches(n);
        if (this.isConfigurationSupported(1, n) && (n4 == 6 || n4 == 4)) {
            arrayList.add(new Integer(1));
        }
        if ((n2 = this.getCarrierAllocationModeMomValue()) != null && n2 != 0) {
            arrayList.add(n2);
        }
        Integer[] integerArray = arrayList.toArray(new Integer[0]);
        return BemUtil.convertIntegerArrayToIntArray(integerArray);
    }

    private boolean isConfigurationSupported(int n, int n2) {
        int[] nArray = ((AbstractRbb)this.rbbManager.getConfiguredRbb(n2)).getSupportedConfiguration();
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] != n) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private Integer getCarrierAllocationModeMomValue() throws BemException {
        if (!this.rbs.isPantherHybridRbs() && this.rbs.isParameterSupported("carrierAllocationMode")) {
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("carrierAllocationMode");
            return (Integer)customerParameterServer.getValueMom();
        }
        return null;
    }

    public boolean isSectorDowngradedAfterConfiguration(int n) {
        return this.modifyManager.isSectorDowngraded(n);
    }

    public boolean isLocalCellNeedToBeDeleted(int n, int n2) {
        return this.modifyManager.isLocalCellDeleted(n, n2);
    }

    private ArrayList getDbbCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("digitalBuildingBlock");
        return arrayList;
    }

    private ArrayList getMixModeRadioCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string2 = MessageFormat.format("S{0}_", new Integer(n));
            string = string2 + "mixedModeRadio";
            arrayList.add(string);
        }
        return arrayList;
    }

    private ArrayList getIsSharedWithExternalMeCpPseudoNames() {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = "";
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            for (int j = 0; j < 3; ++j) {
                String string2 = MessageFormat.format("S{0}_", new Integer(n));
                String string3 = MessageFormat.format("AUX{0}_", new Integer(j + 1));
                string = string2 + string3 + "isSharedWithExternalMe";
                arrayList.add(string);
            }
        }
        return arrayList;
    }

    private void createDbbCustomerParameters() throws BemException {
        this.digitalBuildingBlockParameter = new DigitalBuildingBlockParameter();
        super.addParameter(this.digitalBuildingBlockParameter);
        this.createMixedModeRadioCP();
        this.createIsSharedWithExternalMeCP();
    }

    private void setDbbParameterRestriction() {
        if (this.digitalBuildingBlockParameter != null && !DuwUtil.hasDualDuws()) {
            String string = "Single DUW does not support digitalBuildingBlock parameter!";
            ParameterRestriction parameterRestriction = new ParameterRestriction(string, 1);
            this.digitalBuildingBlockParameter.addRestriction(parameterRestriction);
        }
    }

    private void createMixedModeRadioCP() throws BemException {
        this.mixedModeRadioParam = new Enumeration[this.maxNoOfSectors];
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string = MessageFormat.format("S{0}_", new Integer(n));
            String string2 = string + "mixedModeRadio";
            this.mixedModeRadioParam[i] = new MixedModeRadioParameter(string2);
            this.mixedModeRadioParam[i].setDefaultValue("FALSE");
            super.addParameter(this.mixedModeRadioParam[i]);
        }
    }

    private void createIsSharedWithExternalMeCP() throws BemException {
        ArrayList arrayList = new ArrayList();
        arrayList = this.getIsSharedWithExternalMeCpPseudoNames();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i);
            IsSharedWithExternalMeParameter isSharedWithExternalMeParameter = new IsSharedWithExternalMeParameter(string);
            isSharedWithExternalMeParameter.setDefaultValue("FALSE");
            super.addParameter(isSharedWithExternalMeParameter);
        }
    }

    private Boolean getMixedModeRadioMomValue(int n) throws BemException {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        String string2 = string + "mixedModeRadio";
        if (this.rbs.isParameterSupported(string2)) {
            int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
            return (Boolean)this.mixedModeRadioParam[n2].getValueMom();
        }
        return null;
    }

    private void setMixedModeRadioLoadedValues() throws BemException {
        SectorRI[] sectorRIArray = this.getSectorRis();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            Boolean bl;
            if (!sectorRIArray[i].isInstalled() || (bl = sectorRIArray[i].getLoadedMixedModeRadio()) == null) continue;
            if (bl.booleanValue()) {
                this.mixedModeRadioParam[i].setLoadedValue("TRUE");
                continue;
            }
            this.mixedModeRadioParam[i].setLoadedValue("FALSE");
        }
    }

    private void setIsSharedWithExternalMeLoadedValues() throws BemException {
        SectorRI[] sectorRIArray = this.getSectorRis();
        for (int i = 0; i < this.maxNoOfSectors; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            AbstractRbb abstractRbb = this.rbbManager.getLoadedRadioBuildingBlock(n);
            if (!sectorRIArray[i].isInstalled() || abstractRbb == null) continue;
            AbstractRuRI[] abstractRuRIArray = this.rbbManager.getSectorRadioUnits(n);
            for (int j = 0; j < abstractRuRIArray.length; ++j) {
                if (!abstractRuRIArray[j].isInstalled()) continue;
                abstractRuRIArray[j].loadIsSharedWithExternalMe();
            }
        }
    }

    private void setDbbLoadedValue() throws BemException {
        if (this.dbbManager.isTwoCpriLinkInstalled()) {
            this.digitalBuildingBlockParameter.setLoadedValue("DBB22");
        } else {
            this.digitalBuildingBlockParameter.setLoadedValue("SYSTEM_DEFINED");
        }
    }

    public boolean getMixedModeRadioForSector(int n) throws BemException {
        boolean bl = false;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.mixedModeRadioParam[n2].getValueMom().toString();
        if (string.equals("TRUE")) {
            bl = true;
        }
        return bl;
    }

    public boolean getLoadedMixedModeRadioForSector(int n) throws BemException {
        boolean bl = false;
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        String string = this.mixedModeRadioParam[n2].getLoadedValue();
        if (string.equals("TRUE")) {
            bl = true;
        }
        return bl;
    }
}

