/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEventQueue;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestricter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.RestrictionChangedListener;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;

public class CustomerParameterImpl
implements CustomerParameter,
CustomerParameterServer,
RestrictionChangedListener,
Comparable {
    private final String parameterName;
    private ParameterRange enabledValueRange;
    private final ParameterRange supportedValueRange;
    private String defaultValue = "##UNDEFINED";
    private String loadedValue = "##UNDEFINED";
    private MomConverter momConverter;
    private String configuredValue = "##UNDEFINED";
    private String newConfiguredValue = "##UNDEFINED";
    protected int accessLevel = 3;
    private boolean lastReportedIsValid = false;
    private ArrayList listeners = new ArrayList();
    private ArrayList restrictions = new ArrayList();

    public CustomerParameterImpl(String string, ParameterRange parameterRange) {
        this.parameterName = string;
        this.supportedValueRange = parameterRange;
        this.updateAll();
    }

    public String getName() {
        return this.parameterName;
    }

    public int getAccessLevel() {
        return this.accessLevel;
    }

    public String getAccessLevelString() {
        String string = "ACCESSLEVEL_NOT_SET";
        if (this.accessLevel == 1) {
            string = "ACCESS_IGNORED";
        } else if (this.accessLevel == 3) {
            string = "ACCESS_MANDATORY";
        } else if (this.accessLevel == 2) {
            string = "ACCESS_OPTIONAL";
        } else if (this.accessLevel == 0) {
            string = "ACCESS_READ_ONLY";
        }
        return string;
    }

    public boolean isValidValue(String string) {
        switch (this.accessLevel) {
            case 0: {
                return string.equals(this.loadedValue);
            }
            case 1: {
                return true;
            }
            case 2: 
            case 3: {
                return this.enabledValueRange.isValueInRange(string);
            }
        }
        throw new Error("Unrecognised access level" + this.accessLevel);
    }

    public String getInvalidityReason() {
        String string = this.getInvalidityReason(this.getValue());
        return string;
    }

    public String getInvalidityReason(String string) {
        if (this.isValidValue()) {
            return "The parameter setting is valid";
        }
        String string2 = "The parameter setting is invalid - the reason is not specified";
        switch (this.accessLevel) {
            case 0: {
                if (this.getValue().equals(this.getLoadedValue())) {
                    string2 = this.getOutOfRangeReason(string);
                    break;
                }
                string2 = this.getReadOnlyReason();
                break;
            }
            case 1: {
                string2 = "The parameter setting is valid";
                break;
            }
            case 2: 
            case 3: {
                string2 = this.getOutOfRangeReason(string);
                break;
            }
            default: {
                throw new Error("Unrecognised access level" + this.accessLevel);
            }
        }
        return string2;
    }

    protected String getReadOnlyReason() {
        int n = 3;
        StringBuffer stringBuffer = new StringBuffer("Access level is ReadOnly");
        for (ParameterRestriction parameterRestriction : this.restrictions) {
            n = parameterRestriction.getAccessLevel();
            if (n != 0) continue;
            stringBuffer.append(" - ").append(parameterRestriction.getReasonText());
            break;
        }
        return stringBuffer.toString();
    }

    protected String getOutOfRangeReason(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.supportedValueRange.isValueInRange(string)) {
            if (string.equals("##UNDEFINED")) {
                stringBuffer.append("The parameter is mandatory but no value was provided. ");
            } else {
                stringBuffer.append("Value \"").append(string).append("\" is not supported");
            }
        } else {
            if (string.equals("##UNDEFINED")) {
                stringBuffer.append("The parameter is mandatory but no value was provided. Mandatory reason: ");
            } else {
                stringBuffer.append("Value \"").append(string).append("\" is restricted: ");
            }
            for (ParameterRestriction parameterRestriction : this.restrictions) {
                if (!parameterRestriction.isValueRestricted(string)) continue;
                stringBuffer.append(" - ").append(parameterRestriction.getReasonText());
                break;
            }
        }
        return stringBuffer.toString();
    }

    public boolean isValidValue() {
        String string = this.getValue();
        return this.isValidValue(string);
    }

    public String getValue() {
        return this.getConfiguredValue();
    }

    private String getConfiguredValue() {
        return this.configuredValue;
    }

    public String getLoadedValue() {
        return this.loadedValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void addRestriction(ParameterRestriction parameterRestriction) {
        this.restrictions.add(parameterRestriction);
        parameterRestriction.addListener(this);
        this.updateRange();
        this.updateAccessLevel();
    }

    public void removeRestriction(ParameterRestriction parameterRestriction) {
        this.restrictions.remove(parameterRestriction);
        parameterRestriction.removeListener(this);
        this.updateRange();
        this.updateAccessLevel();
    }

    public void removeAllRestrictions() {
        if (this.restrictions != null && this.restrictions.size() > 0) {
            while (this.restrictions.size() > 0) {
                ParameterRestriction parameterRestriction = (ParameterRestriction)this.restrictions.get(0);
                this.restrictions.remove(parameterRestriction);
                parameterRestriction.removeListener(this);
            }
            this.updateRange();
            this.updateAccessLevel();
        }
    }

    public void restrictionChanged(ParameterRestricter parameterRestricter, ParameterEvent parameterEvent) {
        if (parameterEvent.isAccessLevelChanged()) {
            this.updateAccessLevel();
        }
        if (parameterEvent.isRangeChanged()) {
            this.updateRange();
        }
    }

    public boolean isCustomerParameterListenerAdded(CustomerParameterListener customerParameterListener) {
        return this.listeners.contains(customerParameterListener);
    }

    public void addCustomerParameterListener(CustomerParameterListener customerParameterListener) {
        if (!this.isCustomerParameterListenerAdded(customerParameterListener)) {
            this.listeners.add(customerParameterListener);
        }
    }

    public void removeCustomerParameterListener(CustomerParameterListener customerParameterListener) {
        if (this.isCustomerParameterListenerAdded(customerParameterListener)) {
            this.listeners.remove(customerParameterListener);
        }
    }

    public void removeAllCustomerParameterListeners() {
        this.listeners = new ArrayList();
    }

    protected void updateAll() {
        this.updateAccessLevel();
        this.updateRange();
        this.updateValue();
        this.updateIsValid();
    }

    public void update(ParameterEvent parameterEvent) {
        if (parameterEvent.isAccessLevelChanged()) {
            this.updateAccessLevel();
        }
        if (parameterEvent.isRangeChanged()) {
            this.updateRange();
        }
        if (parameterEvent.isValueChanged()) {
            this.updateValue();
        }
        this.updateIsValid();
    }

    public void notifyAllListeners(ParameterEvent parameterEvent) {
        for (CustomerParameterListener customerParameterListener : this.listeners) {
            customerParameterListener.parameterPropertiesChanged(this, parameterEvent);
        }
    }

    protected void updateAccessLevel() {
        int n = 3;
        for (ParameterRestriction parameterRestriction : this.restrictions) {
            int n2 = parameterRestriction.getAccessLevel();
            if (n2 >= n) continue;
            n = n2;
        }
        if (n != this.accessLevel) {
            this.accessLevel = n;
            this.queueEvent(new ParameterEvent(4));
        }
    }

    protected void queueEvent(ParameterEvent parameterEvent) {
        ParameterEventQueue.getInstance().queueEvent(this, parameterEvent);
    }

    public void updateRange() {
        ParameterRange parameterRange = this.supportedValueRange;
        for (ParameterRestriction parameterRestriction : this.restrictions) {
            parameterRange = parameterRestriction.getAdjustedRange(parameterRange);
        }
        this.enabledValueRange = parameterRange;
        this.queueEvent(new ParameterEvent(2));
    }

    protected void updateValue() {
        if (this.newConfiguredValue == null) {
            Nal.getLog().nalTrace(2, this.getClass(), "STRANGE! newConfiguredValue == null in updateValue! Race condition?", new NullPointerException("newConfiguredValue == null"));
            this.newConfiguredValue = "##UNDEFINED";
        }
        if (this.newConfiguredValue.equals("##UNDEFINED")) {
            this.newConfiguredValue = this.loadedValue;
        }
        if (this.newConfiguredValue.equals("##UNDEFINED")) {
            this.newConfiguredValue = this.defaultValue;
        }
        if (this.configuredValue != this.newConfiguredValue) {
            this.configuredValue = this.newConfiguredValue;
            this.queueEvent(new ParameterEvent(1));
        }
    }

    protected void updateIsValid() {
        boolean bl = this.isValidValue();
        if (this.lastReportedIsValid != bl) {
            this.lastReportedIsValid = bl;
            this.queueEvent(new ParameterEvent(8));
        }
    }

    public ParameterRange getSupportedValueRange() {
        return this.supportedValueRange;
    }

    public ParameterRange getEnabledValueRange() {
        return this.enabledValueRange;
    }

    protected void setConfiguredValue(String string) {
        if (this.configuredValue.equals(string)) {
            return;
        }
        this.newConfiguredValue = string;
        this.updateValue();
    }

    public void setLoadedValue(Object object) {
        if (object != null) {
            String string = null;
            string = this.momConverter != null ? this.momConverter.convertToParameterValue(object) : object.toString();
            if (string.equals(this.loadedValue)) {
                return;
            }
            this.newConfiguredValue = this.loadedValue = string;
            this.updateValue();
        }
    }

    public Object getValueMom() {
        Object object = this.getValue();
        if (this.momConverter != null && object != null) {
            object = this.momConverter.convertToMomValue(object.toString());
        }
        return object;
    }

    public Object getLoadedValueMom() {
        Object object = this.getLoadedValue();
        if (this.momConverter != null && object != null) {
            object = this.momConverter.convertToMomValue(object.toString());
        }
        return object;
    }

    public void setValue(String string) {
        this.setConfiguredValue(string);
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
        this.updateValue();
    }

    public void resetValue() {
        this.setConfiguredValue("##UNDEFINED");
    }

    public boolean isValueEqualTo(Object object) {
        CustomerParameter customerParameter;
        return object instanceof CustomerParameter ? (customerParameter = (CustomerParameter)object).getValue().equals(this.getValue()) : object.toString().equals(this.getValue());
    }

    public String getMoTypeName() {
        String string = null;
        if (this.momConverter != null) {
            string = this.momConverter.getMoTypeName();
        }
        return string;
    }

    public String getAttributeName() {
        String string = null;
        if (this.momConverter != null) {
            string = this.momConverter.getAttributeName();
        }
        return string;
    }

    public void setMomConverter(MomConverter momConverter) {
        this.momConverter = momConverter;
    }

    public boolean hasValueChanged() {
        boolean bl = false;
        if (this.loadedValue.equals("##UNDEFINED") && this.configuredValue.equals("")) {
            bl = false;
        } else if (!this.loadedValue.equals("##UNDEFINED")) {
            if (!this.loadedValue.equals(this.configuredValue)) {
                bl = true;
            }
        } else if (this.configuredValue != null && !this.configuredValue.equals("##UNDEFINED")) {
            bl = true;
        }
        return bl;
    }

    public boolean isDefault() {
        boolean bl = false;
        if (this.configuredValue != null && this.configuredValue.equals(this.defaultValue)) {
            bl = true;
        }
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('{');
        stringBuffer.append(this.getName());
        stringBuffer.append('=');
        stringBuffer.append(this.getValue());
        stringBuffer.append(", flags=");
        stringBuffer.append(this.isValidValue() ? (char)'V' : 'v');
        stringBuffer.append(this.hasValueChanged() ? (char)'C' : 'c');
        stringBuffer.append(this.isDefault() ? (char)'D' : 'd');
        stringBuffer.append('-');
        switch (this.getAccessLevel()) {
            case 0: {
                stringBuffer.append("r/o");
                break;
            }
            case 1: {
                stringBuffer.append("ign");
                break;
            }
            case 2: {
                stringBuffer.append("opt");
                break;
            }
            case 3: {
                stringBuffer.append("man");
                break;
            }
            default: {
                stringBuffer.append("al?");
            }
        }
        stringBuffer.append('}');
        String string = stringBuffer.toString();
        return string;
    }

    public int compareTo(Object object) {
        CustomerParameter customerParameter = (CustomerParameter)object;
        int n = this.parameterName.compareTo(customerParameter.getName());
        return n;
    }

    public ArrayList getRestrictions() {
        return this.restrictions;
    }
}

