/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3101.configitem;

import java.util.HashMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.CluNpuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3CabinetBasicCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3CommonBasicCvRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsProduct;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;

public class CabinetBasic3101CI
extends Rbs3CabinetBasicCI {
    private static final int noOfSlots = 28;
    private static final String cabinetPos = "1";
    private static final String subrackPos = "1C1";
    private static final int noOfRfSlots = 16;
    private static final String rfCabinetPos = "2";
    private static final String rfSubrackPos = "2B1";
    private static final HashMap BOARD_POS = new HashMap();
    private static final HashMap RF_BOARD_POS = new HashMap();
    private final RbsData rbsData;
    private CluNpuRI cluNpuRI;
    private Rbs3CommonBasicCvRI basicCvRI;
    private static final boolean IS_BB_RF_SUBRACK = false;

    public CabinetBasic3101CI(Rbs rbs) {
        super(rbs);
        this.rbsData = new RbsData(rbs, RbsProduct.RBS_3101);
        this.rbsData.setNoOfSlots(28);
        this.rbsData.setRfNoOfSlots(16);
        this.rbsData.setCabinetPosition(cabinetPos);
        this.rbsData.setRfCabinetPosition(rfCabinetPos);
        this.rbsData.setSubrackPosition(subrackPos);
        this.rbsData.setRfSubrackPosition(rfSubrackPos);
        this.rbsData.setBoardPositions(BOARD_POS);
        this.rbsData.setFcuConfigurable(false);
        this.rbsData.setRfBoardPositions(RF_BOARD_POS);
        super.setRbsData(this.rbsData);
    }

    protected Rbs3CommonBasicCvRI getCommonBasicCvRI() throws BemException {
        this.basicCvRI = new Rbs3CommonBasicCvRI(this.getRbs(), false);
        return this.basicCvRI;
    }

    protected CluNpuRI getCluRI() {
        this.cluNpuRI = new CluNpuRI(this.getRbs());
        return this.cluNpuRI;
    }

    static {
        BOARD_POS.put(MimSwitchCoreUnit.MOTYPENAME, new String[]{cabinetPos, "28"});
        BOARD_POS.put(MimTimingUnit.MOTYPENAME, new String[]{"4", "5"});
        BOARD_POS.put(MimGeneralProcessorUnit.MOTYPENAME, new String[]{"20", "21"});
        RF_BOARD_POS.put(MimSwitchCoreUnit.MOTYPENAME, new String[]{cabinetPos, "16"});
    }
}

