/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3202.configitem;

import java.util.HashMap;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3CabinetBasicCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.Rbs3CommonBasicCvRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsData;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsProduct;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimGeneralProcessorUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSwitchCoreUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTimingUnit;

public class CabinetBasic3202CI
extends Rbs3CabinetBasicCI {
    private static final int noOfSlots = 28;
    private static final String cabinetPos = "1";
    private static final String subrackPos = "1C1";
    private static final int noOfRfSlots = 16;
    private static final String rfCabinetPos = "1";
    private static final String rfSubrackPos = "1B1";
    private static final HashMap BOARD_POS = new HashMap();
    private static final HashMap RF_BOARD_POS = new HashMap();
    private RbsData rbsData;
    private Rbs3CommonBasicCvRI basicCvRI = null;
    private boolean isBbRfSubrack = false;

    public CabinetBasic3202CI(Rbs rbs) {
        super(rbs);
        this.rbsData = new RbsData(rbs, RbsProduct.RBS_3202);
        this.rbsData.setNoOfSlots(28);
        this.rbsData.setRfNoOfSlots(16);
        this.rbsData.setCabinetPosition("1");
        this.rbsData.setRfCabinetPosition("1");
        this.rbsData.setSubrackPosition(subrackPos);
        this.rbsData.setRfSubrackPosition(rfSubrackPos);
        this.rbsData.setBoardPositions(BOARD_POS);
        this.rbsData.setFcuConfigurable(false);
        this.rbsData.setRfBoardPositions(RF_BOARD_POS);
        super.setRbsData(this.rbsData);
    }

    protected Rbs3CommonBasicCvRI getCommonBasicCvRI() throws BemException {
        this.basicCvRI = new Rbs3CommonBasicCvRI(this.rbs, this.isBbRfSubrack);
        return this.basicCvRI;
    }

    static {
        BOARD_POS.put(MimSwitchCoreUnit.MOTYPENAME, new String[]{"1", "28"});
        BOARD_POS.put(MimTimingUnit.MOTYPENAME, new String[]{"4", "5"});
        BOARD_POS.put(MimGeneralProcessorUnit.MOTYPENAME, new String[]{"20", "21"});
        RF_BOARD_POS.put(MimSwitchCoreUnit.MOTYPENAME, new String[]{"1", "16"});
    }
}

