/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs3308.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.AbstractPowerSupplyCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.BfuRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;

public class PowerSupply3308CI
extends AbstractPowerSupplyCI {
    private static final int[] PSU_SLOTS = new int[]{1};
    private static final int BFU_SLOT = 1;
    private static final IntegerRange PSU_RANGE = new IntegerRange(new Integer(1), new Integer(1));
    private static final int AU_HUB_TYPE = 1;
    private static final String POWER_SUBRACK_CABINET_POSITION = "1";
    private static final String POWER_SUBRACK_POSITION = "1A1";
    private static final String BATTERY_SUBRACK_CABINET_POSITION = "2";
    private static final String BATTERY_SUBRACK_POSITION = "2A1";

    public PowerSupply3308CI(Rbs rbs) {
        super(rbs, false);
        this.fcuConfigurable = true;
        super.setPsuSlots(PSU_SLOTS);
        super.setBfuSlot(1);
        this.cabinetParameters = new Integer[50];
        for (int i = 0; i < 50; ++i) {
            this.cabinetParameters[i] = new Integer(0);
        }
        this.cabinetParameters[0] = new Integer(1);
        this.cabinetParameters[1] = new Integer(2);
        this.cabinetParameters[2] = new Integer(43);
        this.cabinetParameters[3] = new Integer(90);
        this.cabinetParameters[4] = new Integer(15);
        this.cabinetParameters[5] = new Integer(14);
        this.cabinetParameters[6] = new Integer(10);
        this.cabinetParameters[7] = new Integer(50);
        this.cabinetParameters[11] = new Integer(10);
        this.cabinetParameters[12] = new Integer(10);
        this.cabinetParameters[13] = new Integer(10);
        this.cabinetParameters[14] = new Integer(100);
        this.cabinetParameters[15] = new Integer(10);
    }

    protected void setDefaultParameterValues() throws BemException {
        this.noPsuCustParam.setDefaultValue(POWER_SUBRACK_CABINET_POSITION);
        this.confPowerSupplyCustParam.setDefaultValue("NO");
        this.confBatteryBackupCustParam.setDefaultValue("NO");
    }

    protected IntegerRange getPsuRange() {
        return PSU_RANGE;
    }

    protected boolean isInternalPowerSupplyMandatory() {
        return false;
    }

    protected boolean hasInternalBatteryBackup() {
        return true;
    }

    protected String getPowerSubrackPosition() {
        return POWER_SUBRACK_POSITION;
    }

    protected String getPowerSubrackCabinetPosition() {
        return POWER_SUBRACK_CABINET_POSITION;
    }

    public void setCustomerParameterRestrictions() throws BemException {
        super.setCustomerParameterRestrictions();
        this.batteryCapacityCustParam.addRestriction(new ParameterRestriction("", 1));
    }

    protected AbstractRbsSubrackRI getBfSubrackRI() {
        return this.bfSubrackRI;
    }

    protected void createBfSubrackRI(MoInstance moInstance) throws BemException {
        this.bfSubrackRI = new BfSubrackRI(this.getRbs(), moInstance, BATTERY_SUBRACK_CABINET_POSITION, BATTERY_SUBRACK_POSITION);
    }

    protected ArrayList getNeededBfSubrackRIs() {
        ArrayList<AbstractRbsSubrackRI> arrayList = new ArrayList<AbstractRbsSubrackRI>();
        arrayList.add(this.getBfSubrackRI());
        return arrayList;
    }

    protected void createBfuRIs() throws BemException {
        MoInstance moInstance = this.bfSubrackRI.getMoiSlot(1);
        this.bfuRI = new BfuRI(this.getRbs(), 1, moInstance);
    }

    protected void updateLoadedValues() throws BemException {
        super.updateBoards(1);
        this.updateLoadedPowerSupplyValues();
        this.updateBattery();
        this.updateBfu();
    }

    private void updateBfu() throws BemException {
        if (this.bfuRI != null) {
            boolean bl = this.bfuRI.isInstalled();
            if (bl) {
                this.confBatteryBackupCustParam.setLoadedValue("YES");
            } else {
                this.confBatteryBackupCustParam.setLoadedValue("NO");
                if (!this.hasInternalBatteryBackup()) {
                    this.confBatteryBackupCustParam.addRestriction(this.restBatteryNoSupport);
                }
            }
        }
    }

    private void updateBattery() throws BemException {
        this.batteryCapacityCustParam.setLoadedValue("##UNDEFINED");
        this.batteryCapacityCustParam.addRestriction(this.restBatteryCapacityIgnored);
    }

    protected ArrayList getNeededBatteryRIs(boolean bl, String string) throws BemException {
        return new ArrayList();
    }
}

