/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6201.configitem;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuifRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.Ruw8USubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet11;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet12;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.CableSet15;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.RbsCableSets;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.GenericRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB1B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB3B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RB4B;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.SectorCapability;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.DiscBranchBReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.Reconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.reconfigurations.UninitSectorReconfiguration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRaxDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRuifDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimTxDeviceGroup;

public class RadioEquipment6201CI
extends GenericRadioEquipmentCI {
    private static final int MAX_NO_OF_SECTORS = 3;
    private static final int MAX_NO_OF_RUS = 0;
    private static final int MAX_NO_OF_CARRIERS = 2;
    private ReservedConnectorRI[] a = new ReservedConnectorRI[1];
    private ReservedConnectorRI[] b = new ReservedConnectorRI[1];
    private ReservedConnectorRI[] c = new ReservedConnectorRI[1];
    private ReservedConnectorRI[] d = new ReservedConnectorRI[1];
    private ReservedConnectorRI[] e = new ReservedConnectorRI[1];
    private ReservedConnectorRI[] f = new ReservedConnectorRI[1];
    private EnumeratedRange radioIfTypeRange;

    public RadioEquipment6201CI(Rbs rbs) {
        super(rbs, 3, 0, 2, false);
        this.setBoardPositions(MimTxDeviceGroup.MOTYPENAME, new String[]{"10", "11"});
        this.setBoardPositions(MimRuifDeviceGroup.MOTYPENAME, new String[]{"12"});
        this.setBoardPositions(MimRaxDeviceGroup.MOTYPENAME, new String[]{"4", "5", "6", "7", "8", "9"});
    }

    public boolean open() throws BemException {
        this.initiateCPRanges();
        return super.open();
    }

    protected void createRadioBuildingBlocks() throws BemException {
        int n = this.getMaxNoOfSectors();
        this.radioBuildingBlocks = new RadioBuildingBlock[n];
        this.createReservedConnectors();
        for (int i = 1; i <= n; ++i) {
            SectorCapability sectorCapability = new SectorCapability();
            int n2 = i + 4;
            RuwRI ruwRI = this.ruwSubrack.getSlot(n2);
            RB1B rB1B = new RB1B(this.rbs, i, ruwRI, this.ruif[0], 60);
            RB4B rB4B = new RB4B(this.rbs, i, ruwRI, this.ruif[0], 60);
            rB1B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            rB4B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            RuwRI ruwRI2 = this.ruwSubrack1.getSlot(n2 * 2 - 1);
            RB3B rB3B = new RB3B(this.rbs, i, ruwRI, ruwRI2, this.ruif[0], 60, 0, 0, 0, 0);
            rB3B.setRadioIfConnectors(this.a[0], this.b[0], this.c[0], this.d[0], this.e[0], this.f[0]);
            Reconfiguration[] reconfigurationArray = new Reconfiguration[]{new DiscBranchBReconfiguration(this.getRbs(), rB1B, rB3B, i), new UninitSectorReconfiguration(this.getRbs(), rB1B, rB4B, i)};
            Reconfiguration[] reconfigurationArray2 = new Reconfiguration[]{new UninitSectorReconfiguration(this.getRbs(), rB4B, rB3B, i)};
            sectorCapability.addConfiguration(rB1B, reconfigurationArray);
            sectorCapability.addConfiguration(rB4B, reconfigurationArray2);
            sectorCapability.addConfiguration(rB3B);
            this.addSectorCapability(i, sectorCapability);
        }
    }

    protected void createRadioInterfaceBoard() {
        this.ruif[0] = new RuifRI(this.rbs, 12, this.hubSubrackMoi);
    }

    protected void createSubracks() throws BemException {
        this.ruwSubrack = new RuwSubrackRI(this.rbs, 7, "", "0Z0", 5);
        this.ruwSubrack1 = new Ruw8USubrackRI(this.rbs, 14, "", "1z1", 9);
    }

    protected RbsCableSets getRbsCableSets() {
        RbsCableSets rbsCableSets = new RbsCableSets();
        rbsCableSets.addCableSet("RB1B", new CableSet11());
        rbsCableSets.addCableSet("RB4B", new CableSet12());
        rbsCableSets.addCableSet("RB4Bb", new CableSet12());
        rbsCableSets.addCableSet("RB3B", new CableSet15());
        return rbsCableSets;
    }

    private void createReservedConnectors() {
        String string = MimDigitalCable.MOTYPENAME;
        String string2 = "objectAConnector";
        for (int i = 0; i <= 0; ++i) {
            this.a[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 1, string, string2);
            this.b[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 2, string, string2);
            this.c[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 3, string, string2);
            this.d[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 4, string, string2);
            this.e[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 5, string, string2);
            this.f[i] = new ReservedConnectorRI(this.rbs, this.ruif[i].getPiuLdn(), 6, string, string2);
        }
    }

    private void initiateCPRanges() {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("RUIF");
        this.radioIfTypeRange = new EnumeratedRange(arrayList);
    }

    protected EnumeratedRange getRadioIfTypeRange() {
        return this.radioIfTypeRange;
    }
}

