/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTable;

public class CustomerParameterPanel
extends JPanel
implements CustomerParameterListener {
    private final JLabel mandatory;
    private final JLabel label;
    private JScrollPane sp;
    private final CustomerParameterComponent widget;
    private final CustomerParameter customerParameter;
    private final boolean showLabel;

    public CustomerParameterPanel(String string, CustomerParameterComponent customerParameterComponent, boolean bl) {
        this.label = new JLabel(string);
        this.mandatory = new JLabel("*");
        this.showLabel = bl;
        this.widget = customerParameterComponent;
        this.customerParameter = customerParameterComponent.getCustomerParameter();
        if (this.customerParameter == null) {
            System.out.println("Error: Customer parameter not set for: " + string);
            return;
        }
        this.customerParameter.addCustomerParameterListener(this);
        this.init();
        this.updateGui();
    }

    public CustomerParameterPanel(String string, CustomerParameterComponent customerParameterComponent) {
        this(string, customerParameterComponent, true);
    }

    public JLabel getLabel() {
        return this.label;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter != this.customerParameter) {
            return;
        }
        if (!parameterEvent.isAccessLevelChanged()) {
            return;
        }
        this.updateGui();
    }

    public boolean containCustomerParameter(String string) {
        boolean bl = false;
        String string2 = this.customerParameter.getName();
        bl = string2.equals(string);
        return bl;
    }

    public void requestFocus() {
        ((JComponent)((Object)this.widget)).requestFocus();
    }

    private void updateGui() {
        switch (this.customerParameter.getAccessLevel()) {
            case 1: {
                this.setFieldsEnabled(false);
                this.setMandatory(false);
                break;
            }
            case 3: {
                this.setFieldsEnabled(true);
                this.setMandatory(true);
                break;
            }
            case 2: {
                this.setFieldsEnabled(true);
                this.setMandatory(false);
                break;
            }
            case 0: {
                this.setFieldsEnabled(false);
                this.setMandatory(false);
                break;
            }
        }
    }

    private void setFieldsEnabled(boolean bl) {
        this.label.setEnabled(bl);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            if (this.getComponent(i).getClass() != JButton.class) continue;
            this.getComponent(i).setEnabled(bl);
        }
    }

    private void setMandatory(boolean bl) {
        if (bl) {
            this.mandatory.setForeground(null);
        } else {
            this.mandatory.setForeground(this.mandatory.getBackground());
        }
    }

    private void init() {
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        if (this.showLabel) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 10);
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            this.add((Component)this.label, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 10;
        this.add((Component)this.mandatory, gridBagConstraints);
        if (this.widget instanceof CustomerParameterTable) {
            this.sp = new JScrollPane((CustomerParameterTable)this.widget);
            this.add((Component)this.sp, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else if (this.customerParameter instanceof IntegerParameter) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            this.add((Component)((JComponent)((Object)this.widget)), gridBagConstraints);
        } else if (this.customerParameter instanceof IpAddressParameter) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            this.add((Component)((JComponent)((Object)this.widget)), gridBagConstraints);
        } else if (this.customerParameter instanceof SubnetParameter) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 0;
            this.add((Component)((JComponent)((Object)this.widget)), gridBagConstraints);
        } else {
            ++gridBagConstraints.gridx;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.weightx = 10.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            this.add((Component)((JComponent)((Object)this.widget)), gridBagConstraints);
        }
    }

    public CustomerParameterComponent getCustomerParameterComponent() {
        return this.widget;
    }

    public String toString() {
        String string = this.label.getText();
        string = string + " - ";
        string = string + super.toString();
        return string;
    }
}

