/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.app;

import java.awt.Image;
import java.awt.Toolkit;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.Locale;
import java.util.Properties;
import se.ericsson.security.launcher.Launchable;
import se.ericsson.security.launcher.LauncherInterface;
import se.ericsson.security.launcher.ProgressListenerInterface;
import se.ericsson.security.launcher.ProgressUpdaterInterface;
import se.ericsson.wcdma.rbs.bem.common.gui.app.BemLaunchable;
import se.ericsson.wcdma.rbs.bem.common.gui.app.LaunchProperties;
import se.ericsson.wcdma.rbs.bem.common.gui.app.MibLocator;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.nex.NalFactoryNexParameters;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.support.gui.guilib.infra.ApplicationManager;
import se.ericsson.wcdma.support.gui.resources.ImageConstant;

public abstract class AbstractBemLaunchable
implements Launchable,
BemLaunchable,
ProgressUpdaterInterface {
    public static final String LDNs = "LDNs";
    private LauncherInterface launcher;
    private Launchable parent;
    private LaunchProperties arguments;
    private MibLocator mibLocator;
    private Image minimizeIconImage;
    private String applName;
    private String windowTitle;
    private int logLevel = -1;
    private ProgressListenerInterface progressListenerInterface = null;

    protected abstract String getApplNameDefault();

    public String getApplName() {
        return this.applName;
    }

    protected abstract void launchGui();

    public void run(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        this.init(string, properties, launcherInterface, launchable);
        this.connectToHost();
        this.launchGui();
    }

    public boolean reconnect(String string, Properties properties) {
        LaunchProperties launchProperties = new LaunchProperties(string, properties);
        return this.reconnect(launchProperties);
    }

    private boolean reconnect(LaunchProperties launchProperties) {
        this.arguments = launchProperties;
        boolean bl = true;
        String string = launchProperties.getHostname();
        if (!this.launcher.hasNESameSecurityState(string, (Launchable)this) || !this.launcher.hasNESameVersion(string, (Launchable)this)) {
            bl = false;
        }
        Nal.getLog().nalTraceEnter(this.getClass(), "AbstractApplication.reconnect() to hostname = " + string + "    sucessfull = " + bl);
        return bl;
    }

    public void reconnectWithNewAddress(String string) {
        Nal.getLog().nalTrace(3, this.getClass(), "Using a new address '" + string + "' to reconnect.");
        this.disconnectToHost();
        this.init(string, this.arguments.getCopy(), this.launcher, this.parent);
        Nal.getFactory().reconnectMib(string, null);
    }

    public synchronized void exit() {
        Nal.getLog().nalTrace(6, this.getClass(), "AbstractBemLaunchable.exit()");
        this.launcher.onExit((Launchable)this);
        this.launcher = null;
        this.parent = null;
        this.arguments = null;
        this.mibLocator = null;
        this.minimizeIconImage = null;
    }

    protected String defaultNal() {
        return "nex";
    }

    public void init(String string, Properties properties, LauncherInterface launcherInterface, Launchable launchable) {
        String string2;
        CharSequence charSequence;
        this.arguments = new LaunchProperties(string, properties);
        this.mibLocator = new MibLocator(this.arguments.getHostname());
        this.launcher = launcherInterface;
        this.parent = launchable;
        Locale.setDefault(Locale.ENGLISH);
        if (BemLanguageHelp.getIsExecutedByDemoBem()) {
            this.minimizeIconImage = ImageConstant.BEM_SMALL.getImage();
        } else {
            charSequence = this.arguments.getToolIcon();
            if (null != charSequence && ((String)charSequence).length() > 0) {
                this.minimizeIconImage = this.getBemImage((String)charSequence);
            }
            if (null == this.minimizeIconImage) {
                this.minimizeIconImage = ImageConstant.BEM_SMALL.getImage();
            }
        }
        this.applName = this.arguments.getApplName();
        if (this.applName == null) {
            this.applName = this.getApplNameDefault();
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(' ');
        ((StringBuffer)charSequence).append(this.mibLocator.getTitleHost());
        ((StringBuffer)charSequence).append(" - ");
        if (!this.isLaunchedStandAlone() && (string2 = this.arguments.getManagerTitle()) != null) {
            ((StringBuffer)charSequence).append(string2);
            ((StringBuffer)charSequence).append(" - ");
        }
        ((StringBuffer)charSequence).append(this.getApplName());
        this.windowTitle = ((StringBuffer)charSequence).toString();
    }

    protected void connectToHost() {
        NalFactoryNexParameters nalFactoryNexParameters = new NalFactoryNexParameters();
        nalFactoryNexParameters.launcher = this.launcher;
        nalFactoryNexParameters.parent = this.parent;
        nalFactoryNexParameters.properties = this.arguments.getCopy();
        String string = this.arguments.getHostname();
        Nal.connectToMib(string, this.logLevel, "nex", nalFactoryNexParameters);
    }

    protected void disconnectToHost() {
        Nal.disconnectFromMib();
    }

    public void runApplication(Class clazz) {
        try {
            this.arguments.setApplToRun(clazz);
            ApplicationManager.Launchermain(this.arguments, this, this.progressListenerInterface);
        }
        catch (Exception exception) {
            NalCmException nalCmException = new NalCmException("Failed launching Stand-alone EmasApplication=" + clazz.getName() + "!", exception);
            Nal.getLog().nalTraceError(this.getClass(), "FATAL! Failed starting Application!", nalCmException);
            throw nalCmException;
        }
        finally {
            if (null != this.progressListenerInterface) {
                this.progressListenerInterface.close();
            }
        }
    }

    public void setProgressListener(ProgressListenerInterface progressListenerInterface) {
        this.progressListenerInterface = progressListenerInterface;
    }

    public ProgressListenerInterface getProgressListener() {
        return this.progressListenerInterface;
    }

    public Image getMinimizeIconImage() {
        return this.minimizeIconImage;
    }

    public String getWindowsTitle() {
        return this.windowTitle;
    }

    public String getHostname() {
        return this.mibLocator.getHostname();
    }

    public LaunchProperties getArguments() {
        return this.arguments;
    }

    public LauncherInterface getLauncher() {
        return this.launcher;
    }

    public Launchable getParentLaunchable() {
        return this.parent;
    }

    public boolean isLaunchedStandAlone() {
        return this.parent == null;
    }

    protected void commandLineError(String string) {
        System.out.println("\nCOMMAND LINE ERROR: " + string);
        this.printUsage();
    }

    public void printUsage() {
        this.printUsageHeader();
        this.printUsageOptionsHeader();
        this.printUsageOptions();
        this.printUsageTailer();
        System.exit(1);
    }

    public void printUsageHeader() {
        System.out.println();
        System.out.println(this.getApplName());
    }

    public void printUsageOptionsHeader() {
        System.out.println("\n  Supported command line options for this application are:");
    }

    protected void printUsageOptions() {
        System.out.println();
        System.out.println("    [hostname=<hostname>]  - Where <hostname> is an IP address or a hostname to an RBS");
        System.out.println("                             or the path to a .mib file.");
        System.out.println();
        System.out.println("    [LOG=<logLevel>]       - Where <loglevel> is 0..7 where 0 turns Nal logging off,");
        System.out.println("                             or -1 to keep the Log implementation default.");
        System.out.println("                             Default for the statndard logger is NOTIFY=3.");
        System.out.println();
        System.out.println("    [NAL={neal|emas|mib}]  - Controls the implementation of Nal to use.");
        System.out.println("                             The default when connecting to a live node, " + this.defaultNal() + ", is modified with system property NAL");
        System.out.println("                             The default when connecting to a .mib file is mib.");
    }

    protected void printUsageTailer() {
    }

    private Image getBemImage(String string) {
        Image image = null;
        boolean bl = false;
        if (null == string) {
            bl = true;
        } else {
            File file = new File(string);
            if (!file.exists()) {
                bl = true;
            } else {
                try {
                    int n;
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n = bufferedInputStream.read()) != -1) {
                        byteArrayOutputStream.write(n);
                    }
                    image = Toolkit.getDefaultToolkit().createImage(byteArrayOutputStream.toByteArray());
                    bufferedInputStream.close();
                }
                catch (Exception exception) {
                    bl = true;
                }
            }
        }
        if (bl) {
            image = ImageConstant.BEM_SMALL.getImage();
        }
        return image;
    }

    public String toString() {
        return this.getApplName();
    }
}

