/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.app;

import java.io.File;
import java.net.URI;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;

public class MibLocator {
    private final String hostname;
    private final String titleHost;
    private final boolean isFile;
    private final boolean isIpAddress;

    public MibLocator(String string) {
        this.hostname = string;
        File file = new File(string);
        this.isFile = file.canRead();
        this.isIpAddress = Nal.isIpAddress(string);
        this.titleHost = this.isFile ? (BemLanguageHelp.getIsExecutedByDemoBem() ? "1.2.3.4" : file.getName()) : string;
    }

    public boolean isFile() {
        return this.isFile;
    }

    public boolean isIpAddress() {
        return this.isIpAddress;
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getTitleHost() {
        return this.titleHost;
    }

    public String toString() {
        return this.hostname;
    }

    protected MibLocator(String string, String string2, boolean bl, boolean bl2) {
        this.hostname = string;
        this.titleHost = string2;
        this.isFile = bl;
        this.isIpAddress = bl2;
    }

    public static MibLocator getByURI(URI uRI) {
        File file = new File(uRI);
        boolean bl = file.canRead();
        String string = file.getName();
        MibLocator mibLocator = new MibLocator(uRI.toString(), string, bl, false);
        return mibLocator;
    }

    public static MibLocator getByURI(String string) {
        URI uRI = URI.create(string);
        return MibLocator.getByURI(uRI);
    }
}

