/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Color;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemComponentCustomizer;
import se.ericsson.wcdma.rbs.bem.common.gui.components.GenIntegerField;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;

public class BemIntegerField
extends GenIntegerField
implements BemComponentCustomizer {
    private boolean mandatory;
    private Integer maxValue = null;
    private Integer minValue = null;
    private Integer stepValue = null;
    private String label;
    private String pseudoName = "";
    private String momAttributeName = "";

    public BemIntegerField(String string, Integer n, Integer n2, Boolean bl, Integer n3, String string2, String string3) {
        super(string, n3);
        super.setMinimumValue(n);
        this.minValue = n;
        super.setMaximumValue(n2);
        this.maxValue = n2;
        super.setMandatory(bl);
        this.setDefaultBackgroundColor(DEFAULT_BACKGROUND_COLOR);
        this.refreshToolTip();
        this.mandatory = bl;
        this.label = string;
        this.pseudoName = string2;
        this.momAttributeName = string3;
    }

    public BemIntegerField(String string, Integer n, Integer n2, Integer n3, Boolean bl, Integer n4, String string2, String string3) {
        this(string, n, n2, bl, n4, string2, string3);
        this.stepValue = n3;
    }

    public BemIntegerField(String string, Integer n, Integer n2, Boolean bl, Integer n3) {
        this(string, n, n2, bl, n3, "", "");
    }

    public BemIntegerField(String string, Integer n, Integer n2, Integer n3, Boolean bl, Integer n4) {
        this(string, n, n2, bl, n4);
        this.stepValue = n3;
    }

    public BemIntegerField(String string, Integer n, Integer n2, Boolean bl) {
        this(string, n, n2, bl, n2.toString().length());
    }

    public BemIntegerField(String string, Integer n, Integer n2) {
        this(string, n, n2, false, n2.toString().length());
    }

    public BemIntegerField(Integer n, Integer n2, Boolean bl) {
        this("", n, n2, bl, n2.toString().length());
    }

    public void setDefaultBackgroundColor(Color color) {
        if (color != null) {
            JTextField jTextField = (JTextField)super.getFieldComponent();
            jTextField.setBackground(color);
        }
    }

    public void setEnabled(boolean bl) {
        JTextField jTextField = (JTextField)super.getFieldComponent();
        jTextField.setEnabled(bl);
        super.getLabel().setEnabled(bl);
        super.setEnabled(bl);
    }

    public void setToolTip(String string) {
        super.setToolTip(string);
    }

    public void setMandatory(boolean bl) {
        this.mandatory = bl;
        super.setMandatory(bl);
    }

    public void setFocus() {
        this.textField.requestFocus();
    }

    public boolean isValidSyntax() {
        boolean bl = true;
        try {
            bl = super.isValidSyntax();
            if (bl) {
                int n;
                int n2 = 1;
                if (this.stepValue != null) {
                    n2 = this.stepValue;
                }
                if ((n = Integer.parseInt(this.textField.getText())) % n2 > 0) {
                    bl = false;
                }
            }
        }
        catch (Exception exception) {
            bl = false;
        }
        return bl;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean isEmpty(String string) {
        JTextField jTextField = (JTextField)super.getFieldComponent();
        if (super.getValue() != null) {
            return false;
        }
        return jTextField.getText().equals("");
    }

    public String getComponentLabel() {
        return this.label;
    }

    public Object getMinValue() {
        return this.minValue;
    }

    public Object getMaxValue() {
        return this.maxValue;
    }

    public void setMinValue(Integer n) {
        this.minValue = n;
        this.setMinimumValue(this.minValue);
        this.refreshToolTip();
    }

    public void setMaxValue(Integer n) {
        this.maxValue = n;
        this.setMaximumValue(this.maxValue);
        this.refreshToolTip();
    }

    public Object getStepValue() {
        return this.stepValue;
    }

    public boolean clear() {
        boolean bl = super.fillInValue("");
        JTextField jTextField = (JTextField)super.getFieldComponent();
        jTextField.setText("");
        jTextField.setForeground(Color.black);
        return bl;
    }

    private void refreshToolTip() {
        this.setToolTip("[" + this.minValue.toString() + ".." + this.maxValue.toString() + "]");
    }

    public String getPseudoName() {
        return this.pseudoName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setObjectValue(String string, Object object) {
        if (object != null) {
            if (object instanceof Integer) {
                Integer n = (Integer)object;
                super.setValue(n);
                return true;
            } else {
                if (!(object instanceof String)) return false;
                Integer n = Integer.valueOf((String)object);
                super.setValue(n);
            }
            return true;
        } else {
            if (object != null) return true;
            return false;
        }
    }

    public NalNameValue getNameValue() {
        Integer n = super.getValue();
        NalNameValue nalNameValue = Nal.getFactory().getNameValue(this.momAttributeName, n);
        return nalNameValue;
    }

    public String getRange() {
        String string = "";
        String string2 = "";
        if (this.minValue != null) {
            string = this.minValue.toString();
        }
        if (this.maxValue != null) {
            string2 = this.maxValue.toString();
        }
        String string3 = string + ".." + string2;
        return string3;
    }

    public boolean isCorrectSyntax(String string) {
        return this.isValidSyntax();
    }
}

