/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.rbs.bem.common.gui.components.AbstractGenLabelledField;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

abstract class EntryField
extends AbstractGenLabelledField
implements FocusListener,
KeyListener {
    public JTextField textField = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String text = null;
    protected boolean faultyValueEntered = false;
    protected Color myRedColor;

    public EntryField(String string, String string2, Integer n) {
        super(string, string2);
        Log.trace("Constructor()");
        this.myRedColor = new Color(204, 0, 0);
        this.textField = new JTextField(n);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
        this.toolTipBundle = "se.ericsson.wcdma.support.gui.gengui.resources.language.ToolTip";
        this.toolTipTag = this.getTag();
    }

    public EntryField(String string, Integer n) {
        super(string);
        Log.trace("EntryField()");
        this.myRedColor = new Color(204, 0, 0);
        this.textField = new JTextField(n);
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
    }

    public void setActionListener(ActionListener actionListener, String string) {
        this.actionListener = actionListener;
        this.actionCommand = string;
    }

    abstract boolean isValidSyntax();

    abstract boolean fillInValue(String var1);

    abstract String getTag();

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        boolean bl = false;
        String string = this.textField.getText();
        if (string.equals("")) {
            this.faultyValueEntered = false;
            bl = this.fillInValue(string);
        } else if (this.isValidSyntax()) {
            this.faultyValueEntered = false;
            bl = this.fillInValue(string);
            this.textField.setForeground(Color.black);
        } else {
            bl = this.fillInValue("");
            this.faultyValueEntered = true;
            this.textField.setForeground(this.myRedColor);
        }
        if (!string.equals(this.text)) {
            this.text = string;
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
            }
        }
        if (this.actionListener != null && bl && !this.actionCommand.equals("ENTRYFIELD_FILLEDIN")) {
            this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
        }
    }

    public boolean isFilledIn() {
        return !this.textField.getText().trim().equals("") && this.isValidSyntax();
    }

    public boolean faultyValueEntered() {
        return this.faultyValueEntered;
    }

    public void focusGained(FocusEvent focusEvent) {
        this.text = this.textField.getText();
        this.textField.selectAll();
    }

    public void focusLost(FocusEvent focusEvent) {
        Log.trace("focusLost()");
        if (!focusEvent.isTemporary() && !this.textField.getText().equals("") && this.faultyValueEntered) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Toolkit.getDefaultToolkit().beep();
                }
            });
        }
    }

    public Object getFieldComponent() {
        Log.trace("getFieldComponent()");
        return this.textField;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }

    public void setBackgroundOfFilledInValue(Color color) {
        if (this.textField != null) {
            this.textField.setBackground(color);
        }
    }
}

