/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Color;
import se.ericsson.wcdma.rbs.bem.common.gui.components.EntryField;
import se.ericsson.wcdma.support.gui.guilib.comp.Log;

class GenIntegerField
extends EntryField {
    protected Integer integerValue = null;
    private int minValue = 0;
    private int maxValue = 0;
    boolean checkMinValue = false;
    boolean checkMaxValue = false;

    public GenIntegerField(String string, String string2, Integer n) {
        super(string, string2, n);
        Log.trace("Constructor()");
        this.textField.setHorizontalAlignment(4);
    }

    public GenIntegerField(String string, Integer n) {
        super(string, n);
        Log.trace("GenIntegerField()");
        this.textField.setHorizontalAlignment(4);
    }

    public boolean setValue(Integer n) {
        Log.trace("setValue()");
        if (this.isValidSyntax(n)) {
            this.textField.setForeground(Color.black);
            this.textField.setText(String.valueOf(n));
            this.integerValue = n;
            this.faultyValueEntered = false;
            return true;
        }
        return false;
    }

    public Integer getValue() {
        Log.trace("getValue()");
        if (this.textField.getText().equals("") || this.isValidSyntax()) {
            this.fillInValue(this.textField.getText());
            this.faultyValueEntered = false;
            this.textField.setForeground(Color.black);
        } else {
            this.integerValue = null;
            this.faultyValueEntered = true;
            this.textField.setForeground(this.myRedColor);
        }
        return this.integerValue;
    }

    public void setMinimumValue(Integer n) {
        Log.trace("setMinimumValue()");
        this.checkMinValue = true;
        this.minValue = n;
        if (this.checkMaxValue) {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...]");
        }
    }

    public void setMaximumValue(Integer n) {
        Log.trace("setMaximumValue()");
        this.checkMaxValue = true;
        this.maxValue = n;
        if (this.checkMinValue) {
            this.textField.setToolTipText("[" + this.minValue + "," + (this.minValue + 1) + ",...," + this.maxValue + "]");
        } else {
            this.textField.setToolTipText("[...," + (this.maxValue - 1) + "," + this.maxValue + "]");
        }
    }

    protected boolean isValidSyntax() {
        Log.trace("isValixSyntax()");
        boolean bl = false;
        try {
            int n = Integer.parseInt(this.textField.getText());
            if (!(this.checkMinValue && n < this.minValue || this.checkMaxValue && n > this.maxValue)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }

    protected String getTag() {
        return null;
    }

    protected boolean fillInValue(String string) {
        int n;
        Log.trace("FillInValue()");
        if (string.equals("")) {
            if (this.integerValue == null) {
                return false;
            }
            this.integerValue = null;
            return true;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (null == this.integerValue) {
                return false;
            }
            this.integerValue = null;
            return true;
        }
        if (this.integerValue != null && this.integerValue == n) {
            return false;
        }
        this.integerValue = n;
        return true;
    }

    private boolean isValidSyntax(Integer n) {
        Log.trace("isValixSyntax()");
        boolean bl = false;
        try {
            if (!(this.checkMinValue && n < this.minValue || this.checkMaxValue && n > this.maxValue)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bl;
    }
}

