/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.moi;

import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SingleChildMoi
extends MoInstance {
    private final String moType;
    private final MoInstance parentMoi;
    private final String defaultRdnId;

    public SingleChildMoi(MoInstance moInstance, String string, String string2) {
        this.moType = string;
        this.parentMoi = moInstance;
        this.defaultRdnId = string2;
    }

    protected String getDiscoveredOrDefaultLdn() throws BemException {
        MoHandler moHandler = this.getMoHandler();
        try {
            String string = this.parentMoi.getLdn();
            BemMo bemMo = moHandler.getMo(string);
            if (moHandler.isExisting(bemMo)) {
                BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, this.moType, "");
                if (bemMoArray.length > 1) {
                    throw new BemException("Found more than one MO of type " + this.moType);
                }
                if (bemMoArray.length == 1) {
                    return bemMoArray[0].getDN();
                }
            }
            return this.generateDefaultLdn(string, this.moType, this.defaultRdnId);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("MoHandlerException at discovery of MOI", "-", (Throwable)moHandlerException);
        }
    }
}

