/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import java.lang.reflect.Array;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalBackendFactory;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalLog;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalObject;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTypes;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.ConnectionNotifier;

public class NalBackend {
    private static final Class THIS_CLASS = NalBackend.class;
    private static boolean assertDecorated = false;
    public static final ConnectionNotifier theConnectionListeners = new ConnectionNotifier();
    private static Class classBemMo = null;

    public static NalBackendFactory getFactory() {
        return (NalBackendFactory)Nal.getFactory();
    }

    public static NalMo wrapNativeMo(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (!NalBackend.getFactory().getNativeTypes().MO.isInstance(object)) {
            throw new ClassCastException("Can't make NalMo from " + object.getClass().getName() + "!");
        }
        NalMo nalMo = NalBackend.getFactory().wrapNativeMo(object);
        return nalMo;
    }

    public static NalMo[] wrapNativeMoArray(Object[] objectArray) throws ClassCastException {
        if (objectArray == null) {
            return null;
        }
        NalMo[] nalMoArray = new NalMo[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nalMoArray[i] = NalBackend.wrapNativeMo(objectArray[i]);
        }
        return nalMoArray;
    }

    public static NalNameValue wrapNativeNameValue(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (!NalBackend.getFactory().getNativeTypes().NAME_VALUE.isInstance(object)) {
            throw new ClassCastException("Can't make NalNameValue from " + object.getClass().getName() + "!");
        }
        NalNameValue nalNameValue = NalBackend.getFactory().wrapNativeNameValue(object);
        return nalNameValue;
    }

    public static NalNameValue[] wrapNativeNameValueArray(Object[] objectArray) throws ClassCastException {
        if (objectArray == null) {
            return null;
        }
        if (!NalBackend.getFactory().getNativeTypes().NAME_VALUE_ARRAY.isInstance(objectArray)) {
            throw new ClassCastException("Can't make NalNameValue array from " + objectArray.getClass().getName() + "!");
        }
        NalNameValue[] nalNameValueArray = new NalNameValue[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nalNameValueArray[i] = NalBackend.wrapNativeNameValue(objectArray[i]);
        }
        return nalNameValueArray;
    }

    public static NalStruct wrapNativeStruct(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        if (!NalBackend.getFactory().getNativeTypes().STRUCT.isInstance(object)) {
            throw new ClassCastException("Can't make NalStruct from " + object.getClass().getName() + "!");
        }
        NalStruct nalStruct = NalBackend.getFactory().wrapNativeStruct(object);
        return nalStruct;
    }

    public static NalStruct[] wrapNativeStructArray(Object[] objectArray) throws ClassCastException {
        if (objectArray == null) {
            return null;
        }
        NalStruct[] nalStructArray = new NalStruct[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            nalStructArray[i] = NalBackend.wrapNativeStruct(objectArray[i]);
        }
        return nalStructArray;
    }

    public static NalTransaction wrapNativeTransaction(Object object) throws ClassCastException {
        NalTransaction nalTransaction = NalBackend.getFactory().wrapNativeTransaction(object);
        return nalTransaction;
    }

    public static NalCmNotificationConsumer wrapNativeCmNotificationConsumer(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        NalCmNotificationConsumer nalCmNotificationConsumer = NalBackend.getFactory().wrapNativeCmNotificationConsumer(object);
        return nalCmNotificationConsumer;
    }

    public static NalCmSubscription wrapNativeCmSubscription(Object object) throws ClassCastException {
        if (object == null) {
            return null;
        }
        NalCmSubscription nalCmSubscription = NalBackend.getFactory().wrapNativeCmSubscription(object);
        return nalCmSubscription;
    }

    public static Object[] wrapNativeObjectArray(Object[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] objectArray2 = new Object[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray2[i] = NalBackend.wrapNativeObject(objectArray[i]);
        }
        return objectArray2;
    }

    public static Object wrapNativeObject(Object object) {
        try {
            if (object == null) {
                return null;
            }
            if (NalBackend.isGenericCmType(object.getClass())) {
                return object;
            }
            NalTypes nalTypes = NalBackend.getFactory().getNativeTypes();
            if (!object.getClass().isArray()) {
                if (nalTypes.MO.isInstance(object)) {
                    return NalBackend.wrapNativeMo(object);
                }
                if (nalTypes.NAME_VALUE.isInstance(object)) {
                    return NalBackend.wrapNativeNameValue(object);
                }
                if (nalTypes.STRUCT.isInstance(object)) {
                    return NalBackend.wrapNativeStruct(object);
                }
                if (NalObject.class.isInstance(object)) {
                    return object;
                }
                if ("se.ericsson.wcdma.rbs.bem.common.moi.ValueList".equals(object.getClass().getName())) {
                    return object;
                }
                throw new ClassCastException("Don't know how to make Nal object from none-array type " + object.getClass().getName() + "!");
            }
            Class<?> clazz = object.getClass().getComponentType();
            Class clazz2 = null;
            if (NalObject.class.isAssignableFrom(clazz)) {
                return object;
            }
            if (nalTypes.MO.isAssignableFrom(clazz)) {
                clazz2 = NalMo.class;
            } else if (nalTypes.NAME_VALUE.isAssignableFrom(clazz)) {
                clazz2 = NalNameValue.class;
            } else if (nalTypes.STRUCT.isAssignableFrom(clazz)) {
                clazz2 = NalStruct.class;
            } else if (Object.class.equals(clazz)) {
                clazz2 = Object.class;
            } else {
                throw new ClassCastException("Don't know how to make Nal object from array type " + object.getClass().getName() + "!");
            }
            Object[] objectArray = (Object[])object;
            Object[] objectArray2 = (Object[])Array.newInstance(clazz2, objectArray.length);
            for (int i = 0; i < objectArray2.length; ++i) {
                Object object2 = NalBackend.wrapNativeObject(objectArray[i]);
                try {
                    objectArray2[i] = object2;
                    continue;
                }
                catch (Exception exception) {
                    throw new NalCmException("Failed storing object of type " + object2.getClass().getName() + "\n   in array of type " + objectArray2.getClass().getName() + " on position " + i + "!", exception);
                }
            }
            return objectArray2;
        }
        catch (Exception exception) {
            NalCmException nalCmException = new NalCmException("Failed making Nal type of " + object.getClass().getName() + "!", exception);
            Nal.getLog().nalTraceError(THIS_CLASS, "INTERNAL CONVERSION ERROR!", nalCmException);
            return object;
        }
    }

    public static Class getImplClass(Class clazz) {
        NalTypes nalTypes = NalBackend.getFactory().getImplTypes();
        if (NalMo.class == clazz) {
            return nalTypes.MO;
        }
        if (NalNameValue.class == clazz) {
            return nalTypes.NAME_VALUE;
        }
        if (NalStruct.class == clazz) {
            return nalTypes.STRUCT;
        }
        if (NalTransaction.class == clazz) {
            return nalTypes.TRANSACTION;
        }
        if (NalCmSubscription.class == clazz) {
            return nalTypes.CM_SUBSCRIPTION;
        }
        if (NalCmNotificationConsumer.class == clazz) {
            return nalTypes.CM_NOTIFICATION_CONSUMER;
        }
        if (NalCmException.class == clazz) {
            return nalTypes.CM_EXCEPTION;
        }
        if (NalLog.class == clazz) {
            return nalTypes.LOG;
        }
        return null;
    }

    public static void assertSame(Class clazz, String string, String string2, Object object, Class clazz2) {
        if (!assertDecorated) {
            return;
        }
        if (object == null) {
            return;
        }
        Class<?> clazz3 = object.getClass();
        if (clazz2 != clazz3) {
            String string3 = "PROGRAMMING ERROR! " + string2 + "=" + object + " from " + string + " is of WRONG CLASS!" + "\n   Expected : " + clazz2.getName() + "\n   Actual   : " + clazz3.getName();
            RuntimeException runtimeException = new RuntimeException(string3);
            Nal.getLog().nalTraceError(clazz, string2 + " not decorated from " + string + "!", runtimeException);
            throw runtimeException;
        }
    }

    public static void assertDecorated(Class clazz, String string, NalMo nalMo) {
        Class clazz2 = NalBackend.getImplClass(NalMo.class);
        NalBackend.assertSame(clazz, string, "nalMo", nalMo, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, NalMo[] nalMoArray) {
        Class clazz2 = NalBackend.getImplClass(NalMo.class);
        for (int i = 0; i < nalMoArray.length; ++i) {
            String string2 = "nalMo[" + i + "]";
            NalBackend.assertSame(clazz, string, string2, nalMoArray[i], clazz2);
        }
    }

    public static void assertDecorated(Class clazz, String string, NalNameValue nalNameValue) {
        Class clazz2 = NalBackend.getImplClass(NalNameValue.class);
        NalBackend.assertSame(clazz, string, "nalNameValue", nalNameValue, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, NalNameValue[] nalNameValueArray) {
        Class clazz2 = NalBackend.getImplClass(NalNameValue.class);
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            String string2 = "nalNameValue[" + i + "]";
            NalBackend.assertSame(clazz, string, string2, nalNameValueArray[i], clazz2);
        }
    }

    public static void assertDecorated(Class clazz, String string, NalStruct nalStruct) {
        Class clazz2 = NalBackend.getImplClass(NalStruct.class);
        NalBackend.assertSame(clazz, string, "nalStruct", nalStruct, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, NalStruct[] nalStructArray) {
        Class clazz2 = NalBackend.getImplClass(NalStruct.class);
        for (int i = 0; i < nalStructArray.length; ++i) {
            String string2 = "nalStruct[" + i + "]";
            NalBackend.assertSame(clazz, string, string2, nalStructArray[i], clazz2);
        }
    }

    public static void assertDecorated(Class clazz, String string, NalTransaction nalTransaction) {
        Class clazz2 = NalBackend.getImplClass(NalTransaction.class);
        NalBackend.assertSame(clazz, string, "nalTransaction", nalTransaction, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, NalCmSubscription nalCmSubscription) {
        Class clazz2 = NalBackend.getImplClass(NalCmSubscription.class);
        NalBackend.assertSame(clazz, string, "nalCmSubscription", nalCmSubscription, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, NalCmNotificationConsumer nalCmNotificationConsumer) {
        Class clazz2 = NalBackend.getImplClass(NalCmNotificationConsumer.class);
        NalBackend.assertSame(clazz, string, "nalCmNotificationConsumer", nalCmNotificationConsumer, clazz2);
    }

    public static void assertDecorated(Class clazz, String string, Object object) {
        if (!assertDecorated) {
            return;
        }
        if (object instanceof NalMo) {
            NalBackend.assertDecorated(clazz, string, (NalMo)object);
        } else if (object instanceof NalNameValue) {
            NalBackend.assertDecorated(clazz, string, (NalNameValue)object);
        } else if (object instanceof NalStruct) {
            NalBackend.assertDecorated(clazz, string, (NalStruct)object);
        } else if (object instanceof NalTransaction) {
            NalBackend.assertDecorated(clazz, string, (NalTransaction)object);
        } else if (object instanceof NalCmSubscription) {
            NalBackend.assertDecorated(clazz, string, (NalCmSubscription)object);
        } else if (object instanceof NalCmNotificationConsumer) {
            NalBackend.assertDecorated(clazz, string, (NalCmNotificationConsumer)object);
        } else {
            object = string;
        }
    }

    public static void assertDecorated(Class clazz, String string, Object[] objectArray) {
        if (!assertDecorated) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            stringBuffer.append("[").append(i).append("]");
            if (object.getClass().isArray()) {
                NalBackend.assertDecorated(clazz, stringBuffer.toString(), (Object[])object);
                continue;
            }
            NalBackend.assertDecorated(clazz, stringBuffer.toString(), object);
        }
    }

    private static boolean isNativeCmType(Class clazz) {
        if (clazz.isArray()) {
            return NalBackend.isNativeCmType(clazz.getComponentType());
        }
        NalTypes nalTypes = NalBackend.getFactory().getNativeTypes();
        boolean bl = nalTypes.MO.isAssignableFrom(clazz) || nalTypes.NAME_VALUE.isAssignableFrom(clazz) || nalTypes.STRUCT.isAssignableFrom(clazz);
        return bl;
    }

    private static boolean isGenericCmType(Class clazz) {
        if (clazz.isArray()) {
            return NalBackend.isGenericCmType(clazz.getComponentType());
        }
        boolean bl = clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) || clazz.equals(Long.class) || clazz.equals(Long.TYPE) || clazz.equals(Float.class) || clazz.equals(Float.TYPE) || clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) || clazz.equals(String.class);
        return bl;
    }

    private static Object[] toNativeArray(Class clazz, NalObject[] nalObjectArray) {
        Object[] objectArray = (Object[])Array.newInstance(clazz, nalObjectArray.length);
        for (int i = 0; i < nalObjectArray.length; ++i) {
            Object object;
            NalObject nalObject = nalObjectArray[i];
            objectArray[i] = object = nalObject == null ? null : nalObject.getNative();
        }
        return objectArray;
    }

    public static Object[] toNative(NalMo[] nalMoArray) {
        Class clazz = NalBackend.getFactory().getNativeTypes().MO;
        Object[] objectArray = NalBackend.toNativeArray(clazz, nalMoArray);
        return objectArray;
    }

    public static Object[] toNative(NalNameValue[] nalNameValueArray) {
        Class clazz = NalBackend.getFactory().getNativeTypes().NAME_VALUE;
        Object[] objectArray = NalBackend.toNativeArray(clazz, nalNameValueArray);
        return objectArray;
    }

    public static Object[] toNative(NalStruct[] nalStructArray) {
        Class clazz = NalBackend.getFactory().getNativeTypes().STRUCT;
        Object[] objectArray = NalBackend.toNativeArray(clazz, nalStructArray);
        return objectArray;
    }

    public static Object toNative(Object object) {
        try {
            if (object == null) {
                return null;
            }
            Class<?> clazz = object.getClass();
            if (NalBackend.isNativeCmType(clazz)) {
                return object;
            }
            if (NalBackend.isGenericCmType(clazz)) {
                return object;
            }
            if (object instanceof NalObject) {
                object = ((NalObject)object).getNative();
                return object;
            }
            if ("se.ericsson.wcdma.rbs.bem.common.moi.ValueList".equals(object.getClass().getName())) {
                return object;
            }
            if (clazz.isArray()) {
                if (object instanceof NalMo[]) {
                    return NalBackend.toNative((NalMo[])object);
                }
                if (object instanceof NalNameValue[]) {
                    return NalBackend.toNative((NalNameValue[])object);
                }
                if (object instanceof NalStruct[]) {
                    return NalBackend.toNative((NalStruct[])object);
                }
                if (clazz == Object[].class) {
                    Object[] objectArray = (Object[])object;
                    Object[] objectArray2 = new Object[objectArray.length];
                    for (int i = 0; i < objectArray.length; ++i) {
                        objectArray2[i] = NalBackend.toNative(objectArray[i]);
                    }
                    return objectArray2;
                }
                if (NalBackend.isInstanceOfBemMoArray(object)) {
                    Class clazz2 = NalBackend.getFactory().getNativeTypes().MO;
                    NalObject[] nalObjectArray = (NalObject[])object;
                    Object[] objectArray = NalBackend.toNativeArray(clazz2, nalObjectArray);
                    return objectArray;
                }
            }
            throw new ClassCastException("Don't know how to make native type of " + object.getClass().getName() + "!");
        }
        catch (Exception exception) {
            NalCmException nalCmException = new NalCmException("Failed making native type of " + object.getClass().getName() + "!", exception);
            Nal.getLog().nalTraceError(THIS_CLASS, "INTERNAL CONVERSION ERROR!", nalCmException);
            return object;
        }
    }

    private static boolean isInstanceOfBemMoArray(Object object) {
        if (classBemMo == null) {
            try {
                classBemMo = Class.forName("se.ericsson.wcdma.rbs.bem.common.proxy.BemMo");
            }
            catch (ClassNotFoundException classNotFoundException) {
                classBemMo = NalMo.class;
            }
        }
        if (classBemMo == NalMo.class) {
            return false;
        }
        if (!object.getClass().isArray()) {
            return false;
        }
        Object[] objectArray = (Object[])object;
        Class<?> clazz = objectArray.getClass().getComponentType();
        boolean bl = classBemMo.isAssignableFrom(clazz);
        return bl;
    }

    public static String MOProxy_compatible_toString(NalNameValue[] nalNameValueArray) {
        if (nalNameValueArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(nalNameValueArray.length * 30);
        stringBuffer.append('[');
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(nalNameValueArray[i].getName());
            stringBuffer.append('=');
            stringBuffer.append(nalNameValueArray[i].getValue());
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }

    public static String toString(NalNameValue[] nalNameValueArray) {
        if (nalNameValueArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer(nalNameValueArray.length * 30);
        stringBuffer.append('[');
        for (int i = 0; i < nalNameValueArray.length; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(nalNameValueArray[i]);
        }
        stringBuffer.append(']');
        return stringBuffer.toString();
    }
}

